/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.gatling.plugin.model.HostByLocation;
import io.gatling.plugin.model.MeaningfulTimeWindow;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class SimulationCreationPayload {
    public final String name;
    public final UUID teamId;
    public final String className;
    @JsonProperty(value="build")
    @JsonSerialize(using=PkgIdJsonSerializer.class)
    public final UUID pkgId;
    public final Map<String, String> systemProperties;
    public final Map<String, String> environmentVariables;
    public final boolean ignoreGlobalProperties;
    public final MeaningfulTimeWindow meaningfulTimeWindow;
    public final Map<String, HostByLocation> hostsByPool;
    public final boolean usePoolWeights;
    public final boolean usePoolDedicatedIps;

    public SimulationCreationPayload(String string, UUID uUID, String string2, UUID uUID2, Map<String, String> map, Map<String, String> map2, boolean bl, MeaningfulTimeWindow meaningfulTimeWindow, Map<String, HostByLocation> map3, boolean bl2, boolean bl3) {
        ObjectsUtil.nonNullParam(string, "name");
        ObjectsUtil.nonNullParam(uUID, "teamId");
        ObjectsUtil.nonNullParam(string2, "className");
        ObjectsUtil.nonNullParam(uUID2, "pkgId");
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(map2, "environmentVariables");
        ObjectsUtil.nonNullParam(meaningfulTimeWindow, "meaningfulTimeWindow");
        ObjectsUtil.nonNullParam(map3, "hostsByPool");
        this.name = string;
        this.teamId = uUID;
        this.className = string2;
        this.pkgId = uUID2;
        this.systemProperties = map;
        this.environmentVariables = map2;
        this.ignoreGlobalProperties = bl;
        this.meaningfulTimeWindow = meaningfulTimeWindow;
        this.hostsByPool = map3;
        this.usePoolWeights = bl2;
        this.usePoolDedicatedIps = bl3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimulationCreationPayload simulationCreationPayload = (SimulationCreationPayload)object;
        return this.ignoreGlobalProperties == simulationCreationPayload.ignoreGlobalProperties && this.usePoolWeights == simulationCreationPayload.usePoolWeights && this.usePoolDedicatedIps == simulationCreationPayload.usePoolDedicatedIps && this.name.equals(simulationCreationPayload.name) && this.teamId.equals(simulationCreationPayload.teamId) && this.className.equals(simulationCreationPayload.className) && this.pkgId.equals(simulationCreationPayload.pkgId) && this.systemProperties.equals(simulationCreationPayload.systemProperties) && this.environmentVariables.equals(simulationCreationPayload.environmentVariables) && this.meaningfulTimeWindow.equals(simulationCreationPayload.meaningfulTimeWindow) && this.hostsByPool.equals(simulationCreationPayload.hostsByPool);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.teamId, this.className, this.pkgId, this.systemProperties, this.environmentVariables, this.ignoreGlobalProperties, this.meaningfulTimeWindow, this.hostsByPool, this.usePoolWeights, this.usePoolDedicatedIps);
    }

    public String toString() {
        return String.format("Simulation{name='%s',teamId='%s',className='%s',pkgId='%s'}", this.name, this.teamId, this.className, this.pkgId);
    }

    private static final class PkgIdJsonSerializer
    extends JsonSerializer<UUID> {
        private PkgIdJsonSerializer() {
        }

        public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("pkgId", uUID.toString());
            jsonGenerator.writeEndObject();
        }
    }
}

