/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.client.http.ApiPath;
import io.gatling.plugin.client.http.HttpResponse;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.RunNotFoundException;
import io.gatling.plugin.model.RequestsSummary;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.Series;
import java.net.URL;
import java.util.List;
import java.util.UUID;

class RunsApiRequests
extends AbstractApiRequests {
    private static final ApiPath RUN_PATH = ApiPath.of("run");
    private static final ApiPath SERIES_PATH = ApiPath.of("series");
    private static final ApiPath SUMMARY_PATH = ApiPath.of("summaries", "requests");

    RunsApiRequests(URL uRL, String string) {
        super(uRL, string);
    }

    RunInformation getRunInformation(UUID uUID) throws EnterprisePluginException {
        return this.getJson(RUN_PATH.addQueryParam("run", uUID.toString()), RunInformation.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new RunNotFoundException(uUID);
            }
        });
    }

    public List<Series> getConcurrentUserMetric(UUID uUID, String string) throws EnterprisePluginException {
        return this.getJson(SERIES_PATH.addQueryParam("run", uUID.toString()).addQueryParam("scenario", string).addQueryParam("group", "").addQueryParam("request", "").addQueryParam("node", "").addQueryParam("remote", "").addQueryParam("metric", "usrActive"), new TypeReference<List<Series>>(){});
    }

    public RequestsSummary getRequestsSummary(UUID uUID) throws EnterprisePluginException {
        return this.getJson(SUMMARY_PATH.addQueryParam("run", uUID.toString()), RequestsSummary.class);
    }
}

