/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.RunStatusTask;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SimulationOngoingRunException;
import io.gatling.plugin.exceptions.SimulationScannerIOException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.pkg.EnterprisePackager;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

abstract class PluginClient
implements EnterprisePlugin {
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;
    private final EnterprisePackager enterprisePackager;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
        this.enterprisePackager = new EnterprisePackager(pluginLogger);
    }

    protected long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        if (this.enterpriseClient.uploadPackageWithChecksum(uUID, file) == -1L) {
            this.logger.info("No code changes detected, skipping package upload");
        } else {
            this.logger.info("Package uploaded");
        }
        return file.length();
    }

    protected void validateJavaVersion(File file) throws EnterprisePluginException {
        int n;
        try {
            n = EnterprisePackager.getJavaVersion(file);
        }
        catch (IOException iOException) {
            throw new SimulationScannerIOException(file, iOException);
        }
        int n2 = Integer.parseInt(this.enterpriseClient.getServerInformation().versions.java.max);
        if (n > n2) {
            throw new UnsupportedJavaVersionException(n, n2);
        }
    }

    protected List<String> getSimulationClasses(File file) throws EnterprisePluginException {
        try {
            return EnterprisePackager.getSimulationClasses(file);
        }
        catch (IOException iOException) {
            throw new SimulationScannerIOException(file, iOException);
        }
    }

    @Override
    public SimulationEndResult waitForRunEnd(RunSummary runSummary) throws EnterprisePluginException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Timer timer = new Timer();
        RunStatusTask runStatusTask = new RunStatusTask(this.enterpriseClient, this.logger, runSummary.runId, countDownLatch);
        try {
            timer.schedule((TimerTask)runStatusTask, 5000L, 5000L);
            countDownLatch.await();
        }
        catch (Exception exception) {
            throw new SimulationOngoingRunException(runSummary.runId, (Throwable)exception);
        }
        finally {
            timer.cancel();
        }
        if (runStatusTask.exception != null) {
            throw new SimulationOngoingRunException(runSummary.runId, (Throwable)runStatusTask.exception);
        }
        SimulationEndResult simulationEndResult = runStatusTask.result;
        this.logAssertionResults(simulationEndResult.assertions);
        this.logResult(runSummary, simulationEndResult.status);
        return simulationEndResult;
    }

    @Override
    public boolean abortRun(UUID uUID) throws EnterprisePluginException {
        return this.enterpriseClient.abortRun(uUID);
    }

    private void logAssertionResults(List<RunAssertion> list) {
        if (!list.isEmpty()) {
            this.logger.info("Assertion results:");
            for (RunAssertion runAssertion : list) {
                if (runAssertion.result) {
                    this.logger.info("> " + runAssertion.message + " succeeded with value " + runAssertion.actualValue);
                    continue;
                }
                this.logger.error("> " + runAssertion.message + " failed with value " + runAssertion.actualValue);
            }
            this.logger.info("");
        }
    }

    private void logResult(RunSummary runSummary, RunStatus runStatus) {
        if (runStatus.successful) {
            this.logger.info("Simulation result: Run " + String.valueOf(runSummary.runId) + " finished with status " + String.valueOf((Object)runStatus));
        } else {
            this.logger.error("Simulation result: Run " + String.valueOf(runSummary.runId) + " failed with status " + String.valueOf((Object)runStatus));
        }
        this.logger.info("See the run reports at " + String.valueOf(this.enterpriseClient.getBaseUrl()) + runSummary.reportsPath);
    }
}

