/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.client.http.ApiPath;
import io.gatling.plugin.client.http.HttpResponse;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SimulationNotFoundException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationClassName;
import io.gatling.plugin.model.SimulationCreationPayload;
import io.gatling.plugin.model.Simulations;
import io.gatling.plugin.model.StartOptions;
import java.net.URL;
import java.util.List;
import java.util.UUID;

class SimulationsApiRequests
extends AbstractApiRequests {
    private static final ApiPath SIM_PATH = ApiPath.of("simulations");

    SimulationsApiRequests(URL uRL, String string) {
        super(uRL, string);
    }

    Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        return this.getJson(SIM_PATH.append(uUID.toString()), Simulation.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new SimulationNotFoundException(uUID);
            }
        });
    }

    Simulations listSimulations() throws EnterprisePluginException {
        List<Simulation> list = this.getJson(SIM_PATH, new TypeReference<List<Simulation>>(){});
        return new Simulations(list);
    }

    Simulation createSimulation(SimulationCreationPayload simulationCreationPayload) throws EnterprisePluginException {
        return this.postJson(SIM_PATH, simulationCreationPayload, Simulation.class);
    }

    RunSummary startSimulation(UUID uUID, StartOptions startOptions) throws EnterprisePluginException {
        ApiPath apiPath = SIM_PATH.append("start").addQueryParam("simulation", uUID.toString());
        return this.postJson(apiPath, startOptions, RunSummary.class);
    }

    SimulationClassName updateSimulationClassName(UUID uUID, String string) throws EnterprisePluginException {
        return this.putJson(SIM_PATH.append(uUID.toString(), "classname"), new SimulationClassName(string), SimulationClassName.class);
    }
}

