/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.pkg;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public final class Git {
    private Git() {
    }

    public static Metadata getMetadata(Path path) throws IOException {
        Path path2 = Git.findGitDir(path);
        if (path2 == null) {
            return null;
        }
        Path path3 = path2.resolve("HEAD");
        if (!Files.isRegularFile(path3, new LinkOption[0])) {
            return null;
        }
        List<String> list = Files.readAllLines(path3, StandardCharsets.US_ASCII);
        if (list.isEmpty()) {
            return null;
        }
        String string = list.get(0);
        if (!string.startsWith("ref: refs/heads/")) {
            return null;
        }
        String string2 = string.substring("ref: refs/heads/".length());
        Path path4 = path2.resolve("refs").resolve("heads").resolve(string2);
        if (!Files.isRegularFile(path4, new LinkOption[0])) {
            return null;
        }
        List<String> list2 = Files.readAllLines(path4, StandardCharsets.US_ASCII);
        if (list2.isEmpty()) {
            return null;
        }
        String string3 = list2.get(0);
        return new Metadata(string2, string3);
    }

    private static Path findGitDir(Path path) {
        Path path2 = path.resolve(".git");
        if (Files.isDirectory(path2, new LinkOption[0])) {
            return path2;
        }
        Path path3 = path.getParent();
        return path3 != null ? Git.findGitDir(path3) : null;
    }

    public static final class Metadata {
        public final String branch;
        public final String headCommit;

        public Metadata(String string, String string2) {
            this.branch = string;
            this.headCommit = string2;
        }

        public String toString() {
            return "Metadata{branch='" + this.branch + "', headCommit='" + this.headCommit + "'}";
        }
    }
}

