/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import io.gatling.plugin.exceptions.ApiCallIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApiPath {
    private final List<String> segments;
    private final Map<String, String> queryParams;

    public static ApiPath of(String ... stringArray) {
        return new ApiPath().append(stringArray);
    }

    private ApiPath() {
        this(List.of(), Map.of());
    }

    private ApiPath(List<String> list, Map<String, String> map) {
        this.segments = list;
        this.queryParams = map;
    }

    public URL buildUrl(URL uRL) throws ApiCallIOException {
        String string = uRL.toString();
        String string2 = this.encodePath(String.join((CharSequence)"/", this.segments));
        String string3 = this.queryParams.entrySet().stream().map(entry -> this.encodeQueryParam((String)entry.getKey()) + "=" + this.encodeQueryParam((String)entry.getValue())).collect(Collectors.joining("&"));
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.endsWith("/")) {
            stringBuilder.deleteCharAt(string.length() - 1);
        }
        if (!string2.isEmpty()) {
            stringBuilder.append("/").append(string2);
        }
        if (!string3.isEmpty()) {
            stringBuilder.append("?").append(string3);
        }
        String string4 = stringBuilder.toString();
        try {
            return new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ApiCallIOException("Fail to compute URL from " + string4, malformedURLException);
        }
    }

    public ApiPath append(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(this.segments.size() + stringArray.length);
        arrayList.addAll(this.segments);
        arrayList.addAll(List.of(stringArray));
        return new ApiPath(Collections.unmodifiableList(arrayList), this.queryParams);
    }

    public ApiPath append(ApiPath apiPath) {
        List list = Stream.concat(this.segments.stream(), apiPath.segments.stream()).collect(Collectors.toList());
        return new ApiPath(Collections.unmodifiableList(list), this.queryParams);
    }

    public ApiPath addQueryParam(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.queryParams);
        hashMap.put(string, string2);
        return new ApiPath(this.segments, Collections.unmodifiableMap(hashMap));
    }

    private String encodePath(String string) {
        try {
            return new URI(null, null, string, null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private String encodeQueryParam(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }
}

