/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.HttpResponse;
import io.gatling.plugin.client.json.JsonUtil;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.ForbiddenApiCallException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.JsonRequestProcessingException;
import io.gatling.plugin.exceptions.JsonResponseProcessingException;
import io.gatling.plugin.exceptions.UnauthorizedApiCallException;
import io.gatling.plugin.exceptions.UnhandledApiCallException;
import io.gatling.plugin.util.LambdaExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

abstract class AbstractApi {
    private static final String HTTP_GET_METHOD = "GET";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_PUT_METHOD = "PUT";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ACCEPT_HEADER = "Accept";
    private static final Map<String, String> NO_ADDITIONAL_HEADERS;
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONNECTION_HEADER = "Connection";
    protected static final String OCTET_STREAM_MEDIA_TYPE = "application/octet-stream";
    protected static final String JSON_MEDIA_TYPE = "application/json";
    protected static final String CLOSE = "close";
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    protected final URL apiUrl;
    protected final String token;

    AbstractApi(URL uRL, String string) {
        this.apiUrl = uRL;
        this.token = string;
    }

    protected HttpResponse get(ApiPath apiPath, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.executeRequest(HTTP_GET_METHOD, apiPath, NO_ADDITIONAL_HEADERS, httpURLConnection -> {}, consumerWithExceptions);
    }

    protected HttpResponse get(ApiPath apiPath, Map<String, String> map, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.executeRequest(HTTP_GET_METHOD, apiPath, map, httpURLConnection -> {}, consumerWithExceptions);
    }

    protected <T> T getJson(ApiPath apiPath, Map<String, String> map, Class<T> clazz, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.parseJsonResponse(this.get(apiPath, map, consumerWithExceptions), clazz);
    }

    protected <T> T getJson(ApiPath apiPath, Class<T> clazz, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.parseJsonResponse(this.get(apiPath, consumerWithExceptions), clazz);
    }

    protected <T> T getJson(ApiPath apiPath, Class<T> clazz) throws EnterprisePluginException {
        return this.getJson(apiPath, clazz, (HttpResponse httpResponse) -> {});
    }

    protected <T> T getJson(ApiPath apiPath, TypeReference<T> typeReference, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.parseJsonResponse(this.get(apiPath, consumerWithExceptions), typeReference);
    }

    protected <T> T getJson(ApiPath apiPath, TypeReference<T> typeReference) throws EnterprisePluginException {
        return this.getJson(apiPath, typeReference, (HttpResponse httpResponse) -> {});
    }

    protected HttpResponse post(ApiPath apiPath, LambdaExceptionUtil.ConsumerWithExceptions<HttpURLConnection, EnterprisePluginException> consumerWithExceptions, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions2) throws EnterprisePluginException {
        return this.executeRequest(HTTP_POST_METHOD, apiPath, NO_ADDITIONAL_HEADERS, consumerWithExceptions, consumerWithExceptions2);
    }

    protected HttpResponse postJson(ApiPath apiPath, Object object, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.post(apiPath, httpURLConnection -> this.writeJsonRequestBody((HttpURLConnection)httpURLConnection, object), consumerWithExceptions);
    }

    protected HttpResponse postJson(ApiPath apiPath, Object object) throws EnterprisePluginException {
        return this.postJson(apiPath, object, (HttpResponse httpResponse) -> {});
    }

    protected <T> T postJson(ApiPath apiPath, Object object, Class<T> clazz) throws EnterprisePluginException {
        return this.parseJsonResponse(this.postJson(apiPath, object), clazz);
    }

    protected HttpResponse put(ApiPath apiPath, LambdaExceptionUtil.ConsumerWithExceptions<HttpURLConnection, EnterprisePluginException> consumerWithExceptions, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions2) throws EnterprisePluginException {
        return this.executeRequest(HTTP_PUT_METHOD, apiPath, NO_ADDITIONAL_HEADERS, consumerWithExceptions, consumerWithExceptions2);
    }

    protected HttpResponse putJson(ApiPath apiPath, Object object, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.put(apiPath, httpURLConnection -> this.writeJsonRequestBody((HttpURLConnection)httpURLConnection, object), consumerWithExceptions);
    }

    protected HttpResponse putJson(ApiPath apiPath, Object object) throws EnterprisePluginException {
        return this.putJson(apiPath, object, (HttpResponse httpResponse) -> {});
    }

    protected <T> T putJson(ApiPath apiPath, Object object, Class<T> clazz, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions) throws EnterprisePluginException {
        return this.parseJsonResponse(this.putJson(apiPath, object, consumerWithExceptions), clazz);
    }

    protected <T> T putJson(ApiPath apiPath, Object object, Class<T> clazz) throws EnterprisePluginException {
        return this.parseJsonResponse(this.putJson(apiPath, object), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeRequest(String string, ApiPath apiPath, Map<String, String> map, LambdaExceptionUtil.ConsumerWithExceptions<HttpURLConnection, EnterprisePluginException> consumerWithExceptions, LambdaExceptionUtil.ConsumerWithExceptions<HttpResponse, EnterprisePluginException> consumerWithExceptions2) throws EnterprisePluginException {
        HttpURLConnection httpURLConnection = this.openConnection(string, apiPath.buildUrl(this.apiUrl), map);
        consumerWithExceptions.accept(httpURLConnection);
        httpURLConnection.connect();
        try {
            HttpResponse httpResponse = this.readResponse(httpURLConnection);
            consumerWithExceptions2.accept(httpResponse);
            this.defaultValidateResponse(httpResponse);
            HttpResponse httpResponse2 = httpResponse;
            httpURLConnection.disconnect();
            return httpResponse2;
        }
        catch (Throwable throwable) {
            try {
                httpURLConnection.disconnect();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ApiCallIOException("Fail to perform HTTP request", iOException);
            }
        }
    }

    private HttpURLConnection openConnection(String string, URL uRL, Map<String, String> map) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setRequestProperty(AUTHORIZATION_HEADER, this.token);
            httpURLConnection.setRequestProperty(ACCEPT_HEADER, JSON_MEDIA_TYPE);
            httpURLConnection.setRequestProperty(CONNECTION_HEADER, CLOSE);
            if (map != null) {
                map.forEach(httpURLConnection::setRequestProperty);
            }
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            String string2 = uRL.getProtocol();
            String string3 = System.getProperty(string2 + ".proxyHost");
            final String string4 = System.getProperty(string2 + ".proxyUser");
            if (string3 != null && string4 != null) {
                final String string5 = System.getProperty(string2 + ".proxyPassword", "");
                httpURLConnection.setAuthenticator(new Authenticator(this){
                    final /* synthetic */ AbstractApi this$0;
                    {
                        this.this$0 = abstractApi;
                    }

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.getRequestorType() == Authenticator.RequestorType.PROXY ? new PasswordAuthentication(string4, string5.toCharArray()) : null;
                    }
                });
            }
            return httpURLConnection;
        }
        throw new IllegalStateException("Expected an HttpURLConnection, got " + uRLConnection.getClass().getName());
    }

    private InputStream getRealInputStream(HttpURLConnection httpURLConnection) {
        try {
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return httpURLConnection.getErrorStream();
        }
    }

    private HttpResponse readResponse(HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getResponseCode();
        if (n < 0) {
            throw new IOException("Response could not be parsed as HTTP");
        }
        InputStream inputStream = this.getRealInputStream(httpURLConnection);
        if (inputStream == null) {
            return new HttpResponse(n, "");
        }
        return new HttpResponse(n, new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
    }

    private void defaultValidateResponse(HttpResponse httpResponse) throws EnterprisePluginException {
        if (!httpResponse.isSuccessful()) {
            switch (httpResponse.code) {
                case 401: {
                    throw new UnauthorizedApiCallException();
                }
                case 403: {
                    throw new ForbiddenApiCallException();
                }
                case 400: {
                    throw new InvalidApiCallException(httpResponse.body);
                }
            }
            throw new UnhandledApiCallException(httpResponse.code, httpResponse.body);
        }
    }

    private <T> T parseJsonResponse(HttpResponse httpResponse, Class<T> clazz) {
        try {
            return (T)JsonUtil.JSON_MAPPER.readValue(httpResponse.body, clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonResponseProcessingException(jsonProcessingException);
        }
    }

    private <T> T parseJsonResponse(HttpResponse httpResponse, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.JSON_MAPPER.readValue(httpResponse.body, typeReference);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonResponseProcessingException(jsonProcessingException);
        }
    }

    private void writeJsonRequestBody(HttpURLConnection httpURLConnection, Object object) throws ApiCallIOException {
        httpURLConnection.setRequestProperty(CONTENT_TYPE_HEADER, JSON_MEDIA_TYPE);
        httpURLConnection.setDoOutput(true);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            JsonUtil.JSON_MAPPER.writeValue(outputStream, object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonRequestProcessingException(jsonProcessingException);
        }
        catch (IOException iOException) {
            throw new ApiCallIOException("Fail to write JSON request body", iOException);
        }
    }

    static {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        NO_ADDITIONAL_HEADERS = Collections.emptyMap();
    }
}

