/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.scanner.SimulationScanResult;
import io.gatling.scanner.SimulationScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.SelectorUtils;

public final class SimulationSelector {
    private static final int MAX_INTERACTIVE_SIMULATION_SELECT_ATTEMPTS = 5;

    public static Result simulations(String string, List<String> list, List<String> list2, List<String> list3, boolean bl, boolean bl2) {
        if (string != null) {
            return Result.success(List.of(string));
        }
        List<String> list4 = SimulationSelector.resolveSimulations(list, list2, list3);
        if (list4.isEmpty()) {
            return Result.error(Result.Error.NoSimulations);
        }
        if (list4.size() > 1 && !bl) {
            if (bl2) {
                return SimulationSelector.selectSingleSimulation(list4);
            }
            return Result.error(Result.Error.MoreThanOneSimulationInNonInteractiveMode);
        }
        return Result.success(list4);
    }

    private static List<String> resolveSimulations(List<String> list, List<String> list2, List<String> list3) {
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (String string2 : list) {
                File file = new File(string2);
                if (file.isDirectory()) {
                    arrayList2.add(file);
                    continue;
                }
                if (!file.isFile()) continue;
                arrayList.add(file);
            }
            SimulationScanResult simulationScanResult = SimulationScanner.scan(arrayList, arrayList2);
            return simulationScanResult.getSimulationClasses().stream().filter(string -> {
                boolean bl = list2.isEmpty() || SimulationSelector.match(list2, string);
                boolean bl2 = !list3.isEmpty() && SimulationSelector.match(list3, string);
                return bl && !bl2;
            }).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static boolean match(List<String> list, String string) {
        for (String string2 : list) {
            if (string2 == null || !SelectorUtils.match((String)string2, (String)string)) continue;
            return true;
        }
        return false;
    }

    public static Result selectSingleSimulation(List<String> list) {
        return SimulationSelector.selectSingleSimulationRec(new Scanner(System.in), list, 0);
    }

    private static Result selectSingleSimulationRec(Scanner scanner, List<String> list, int n) {
        int n2;
        if (n > 5) {
            return Result.error(Result.Error.TooManyInteractiveAttempts);
        }
        System.out.println("Choose a simulation number:");
        for (n2 = 0; n2 < list.size(); ++n2) {
            System.out.println("     [" + n2 + "] " + list.get(n2));
        }
        try {
            n2 = Integer.parseInt(scanner.nextLine());
            if (n2 < 0 || n2 >= list.size()) {
                System.out.println("Invalid selection. Please try again.");
                return SimulationSelector.selectSingleSimulationRec(scanner, list, n + 1);
            }
            return Result.success(List.of(list.get(n2)));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid number. Please try again.");
            return SimulationSelector.selectSingleSimulationRec(scanner, list, n + 1);
        }
    }

    public static final class Result {
        public final Error error;
        public final List<String> simulations;

        public static Result error(Error error) {
            return new Result(error, null);
        }

        public static Result success(List<String> list) {
            return new Result(null, list);
        }

        private Result(Error error, List<String> list) {
            this.error = error;
            this.simulations = list;
        }

        public static enum Error {
            NoSimulations,
            MoreThanOneSimulationInNonInteractiveMode,
            TooManyInteractiveAttempts;

        }
    }
}

