/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.domain;

import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.domain.RunStatusTask;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InterruptedRetryException;
import io.gatling.plugin.exceptions.SimulationOngoingRunException;
import io.gatling.plugin.exceptions.SimulationScannerIOException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.pkg.EnterprisePackager;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

abstract class PluginClient
implements EnterprisePlugin {
    private static final int MAX_RETRIES = 3;
    private static final int SECONDS_BETWEEN_RETRY = 3;
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;
    protected final URL webAppUrl;
    private final EnterprisePackager enterprisePackager;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger, URL uRL) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
        this.webAppUrl = uRL;
        this.enterprisePackager = new EnterprisePackager(pluginLogger);
    }

    protected long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        return this.uploadPackageWithRetry(uUID, file, 3);
    }

    private long uploadPackageWithRetry(UUID uUID, File file, int n) throws EnterprisePluginException {
        try {
            return this.uploadPackage(uUID, file);
        }
        catch (ApiCallIOException apiCallIOException) {
            if (n < 1) {
                throw apiCallIOException;
            }
            try {
                this.logger.info("Upload failed, retrying in 3 seconds");
                TimeUnit.SECONDS.sleep(3L);
                return this.uploadPackageWithRetry(uUID, file, n - 1);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedRetryException(interruptedException);
            }
        }
    }

    private long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        if (this.enterpriseClient.uploadPackageWithChecksum(uUID, file) == -1L) {
            this.logger.info("No code changes detected, skipping package upload");
        } else {
            this.logger.info(String.format("Package uploaded (id='%s')", uUID));
        }
        return file.length();
    }

    protected void validateJavaVersion(File file) throws EnterprisePluginException {
        int n;
        try {
            n = EnterprisePackager.getJavaVersion(file);
        }
        catch (IOException iOException) {
            throw new SimulationScannerIOException(file, iOException);
        }
        int n2 = Integer.parseInt(this.enterpriseClient.getServerInformation().versions.java.max);
        if (n > n2) {
            throw new UnsupportedJavaVersionException(n, n2);
        }
    }

    protected RunSummary startSimulation(DeployedSimulationInfo deployedSimulationInfo, RunComment runComment) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(deployedSimulationInfo, "deployedSimulationInfo");
        this.logger.info(String.format("Starting simulation '%s' (id='%s')", deployedSimulationInfo.name, deployedSimulationInfo.id));
        return this.enterpriseClient.startSimulation(deployedSimulationInfo.id, runComment);
    }

    @Override
    public SimulationEndResult waitForRunEnd(RunSummary runSummary) throws EnterprisePluginException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Timer timer = new Timer();
        RunStatusTask runStatusTask = new RunStatusTask(this.enterpriseClient, this.logger, runSummary.runId, countDownLatch);
        try {
            timer.schedule((TimerTask)runStatusTask, 5000L, 5000L);
            countDownLatch.await();
        }
        catch (Exception exception) {
            throw new SimulationOngoingRunException(runSummary.runId, (Throwable)exception);
        }
        finally {
            timer.cancel();
        }
        if (runStatusTask.exception != null) {
            throw new SimulationOngoingRunException(runSummary.runId, (Throwable)runStatusTask.exception);
        }
        SimulationEndResult simulationEndResult = runStatusTask.result;
        this.logAssertionResults(simulationEndResult.assertions);
        this.logResult(runSummary, simulationEndResult.status);
        return simulationEndResult;
    }

    @Override
    public boolean abortRun(UUID uUID) throws EnterprisePluginException {
        return this.enterpriseClient.abortRun(uUID);
    }

    private void logAssertionResults(List<RunAssertion> list) {
        if (!list.isEmpty()) {
            this.logger.info("Assertion results:");
            for (RunAssertion runAssertion : list) {
                if (runAssertion.result) {
                    this.logger.info("> " + runAssertion.message + " succeeded with value " + runAssertion.actualValue);
                    continue;
                }
                this.logger.error("> " + runAssertion.message + " failed with value " + runAssertion.actualValue);
            }
            this.logger.info("");
        }
    }

    private void logResult(RunSummary runSummary, RunStatus runStatus) {
        if (runStatus.successful) {
            this.logger.info("Simulation result: Run " + String.valueOf(runSummary.runId) + " finished with status " + String.valueOf((Object)runStatus));
        } else {
            this.logger.error("Simulation result: Run " + String.valueOf(runSummary.runId) + " failed with status " + String.valueOf((Object)runStatus));
        }
        this.logger.info("See the run reports at " + String.valueOf(this.webAppUrl) + runSummary.reportsPath);
    }
}

