/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.AssertionSerializer;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.UserEndMessageSerializer;
import io.gatling.core.stats.writer.UserStartMessageSerializer;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t4A!\u0003\u0006\u0001+!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015y\u0006\u0001\"\u0011a\u0005Eaun\u001a$jY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u00171\taa\u001e:ji\u0016\u0014(BA\u0007\u000f\u0003\u0015\u0019H/\u0019;t\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aE\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u0003)I!!\u0007\u0006\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u0002\u00187%\u0011AD\u0003\u0002\t\r&dW\rR1uC\u0006)1\r\\8dWB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$!\u000591m\\7n_:\u001c\u0018BA\u0013!\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001fK\u0007\u0002S)\u0011!FD\u0001\u0007G>tg-[4\n\u00051J#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\f\u0001\u0011\u0015i2\u00011\u0001\u001f\u0011\u001513\u00011\u0001(\u0003\u0019yg.\u00138jiR\u0011!\u0004\u000e\u0005\u0006k\u0011\u0001\rAN\u0001\u0005S:LG\u000f\u0005\u00028u9\u0011q\u0003O\u0005\u0003s)\t\u0011\u0003R1uC^\u0013\u0018\u000e^3s\u001b\u0016\u001c8/Y4f\u0013\tYDH\u0001\u0003J]&$(BA\u001d\u000b\u0003\u001dygN\u00127vg\"$\"aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r\u0016\u0001\rAG\u0001\u0005I\u0006$\u0018-A\u0005p]6+7o]1hKR\u0019q(\u0013(\t\u000b)3\u0001\u0019A&\u0002\u000f5,7o]1hKB\u0011q\u0007T\u0005\u0003\u001br\u0012\u0011\u0002T8bI\u00163XM\u001c;\t\u000b\u00193\u0001\u0019\u0001\u000e\u0002\u000f=t7I]1tQR\u0019q(\u00150\t\u000bI;\u0001\u0019A*\u0002\u000b\r\fWo]3\u0011\u0005Q[fBA+Z!\t1\u0016)D\u0001X\u0015\tAF#\u0001\u0004=e>|GOP\u0005\u00035\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,\u0011\u0005\u0006\r\u001e\u0001\rAG\u0001\u0007_:\u001cFo\u001c9\u0015\u0005}\n\u0007\"\u0002$\t\u0001\u0004Q\u0002")
public class LogFileDataWriter
extends DataWriter<FileData> {
    private final GatlingConfiguration configuration;

    @Override
    public FileData onInit(DataWriterMessage.Init init) {
        BufferedFileChannelWriter writer = BufferedFileChannelWriter$.MODULE$.apply(init.runMessage().runId(), this.configuration);
        AssertionSerializer assertionSerializer = new AssertionSerializer(writer);
        init.assertions().foreach((Function1 & Serializable)assertion -> {
            assertionSerializer.serialize(assertion);
            return BoxedUnit.UNIT;
        });
        new RunMessageSerializer(writer).serialize(init.runMessage());
        return new FileData(new UserStartMessageSerializer(writer), new UserEndMessageSerializer(writer), new ResponseMessageSerializer(writer), new GroupMessageSerializer(writer), new ErrorMessageSerializer(writer), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, FileData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserStart) {
            DataWriterMessage.LoadEvent.UserStart userStart = (DataWriterMessage.LoadEvent.UserStart)loadEvent;
            data.userStartMessageSerializer().serialize(userStart);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserEnd) {
            DataWriterMessage.LoadEvent.UserEnd userEnd = (DataWriterMessage.LoadEvent.UserEnd)loadEvent;
            data.userEndMessageSerializer().serialize(userEnd);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Group) {
            DataWriterMessage.LoadEvent.Group group = (DataWriterMessage.LoadEvent.Group)loadEvent;
            data.groupMessageSerializer().serialize(group);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            data.responseMessageSerializer().serialize(response);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            data.errorMessageSerializer().serialize(error);
            return;
        }
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public LogFileDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

