/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.UserEndMessage;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%e!B\u000f\u001f\u0003\u0013I\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"AQ\f\u0001B\u0001B\u0003%a\fC\u0003f\u0001\u0011\u0005a\rC\u0004o\u0001\u0001\u0007I\u0011B8\t\u000fM\u0004\u0001\u0019!C\u0005i\"1!\u0010\u0001Q!\nADqa\u001f\u0001A\u0002\u0013%q\u000eC\u0004}\u0001\u0001\u0007I\u0011B?\t\r}\u0004\u0001\u0015)\u0003q\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!A\u0011\u0011\u0003\u0001!B\u0013\t)\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005]\u0001\u0001\"\u0005\u0002\u0016!9\u0011\u0011\u0004\u0001\u0005\u0012\u0005U\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003g\u0001A\u0011CA\u001b\u0011\u0019\tI\u0005\u0001C\t_\"9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA3\u0001\u0019\u0005\u0011q\r\u0005\b\u0003[\u0002a\u0011AA8\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Aq!a!\u0001\t\u0003\t\u0019\u0001C\u0004\u0002B\u00011\t!!\"\t\u000f\u0005\u001d\u0005A\"\u0001\u0002\u0004\tAqk\u001c:lY>\fGM\u0003\u0002 A\u00051\u0011N\u001c6fGRT!!\t\u0012\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002$I\u0005!1m\u001c:f\u0015\t)c%A\u0004hCRd\u0017N\\4\u000b\u0003\u001d\n!![8\u0004\u0001M\u0019\u0001A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\t\u0004(D\u00013\u0015\t\u0019D'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00026m\u0005AA/\u001f9fg\u00064WMC\u00018\u0003\r\u0019w.\\\u0005\u0003sI\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017\u0001C:dK:\f'/[8\u0011\u0005qrT\"A\u001f\u000b\u0005i\u0012\u0013BA >\u0005!\u00196-\u001a8be&|\u0017!C;tKJLEmR3o!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\r\u001e\u000b!bY8oGV\u0014(/\u001a8u\u0015\tA\u0015*\u0001\u0003vi&d'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u000e\u0013!\"\u0011;p[&\u001cGj\u001c8h\u00039)g/\u001a8u\u0019>|\u0007o\u0012:pkB\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u000f\rD\u0017M\u001c8fY*\u00111KJ\u0001\u0006]\u0016$H/_\u0005\u0003+B\u0013a\"\u0012<f]Rdun\u001c9He>,\b/A\u0006ti\u0006$8/\u00128hS:,\u0007C\u0001-\\\u001b\u0005I&B\u0001.#\u0003\u0015\u0019H/\u0019;t\u0013\ta\u0016LA\u0006Ti\u0006$8/\u00128hS:,\u0017!B2m_\u000e\\\u0007CA0d\u001b\u0005\u0001'B\u0001%b\u0015\t\u0011G%A\u0004d_6lwN\\:\n\u0005\u0011\u0004'!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0004hS*\\G.\u001c\t\u0003Q\u0002i\u0011A\b\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0005\u0006\u001b\u001a\u0001\rA\u0014\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u0006;\u001a\u0001\rAX\u0001\ng\u000eDW\rZ;mK\u0012,\u0012\u0001\u001d\t\u0003WEL!A\u001d\u0017\u0003\u0007%sG/A\u0007tG\",G-\u001e7fI~#S-\u001d\u000b\u0003kb\u0004\"a\u000b<\n\u0005]d#\u0001B+oSRDq!\u001f\u0005\u0002\u0002\u0003\u0007\u0001/A\u0002yIE\n!b]2iK\u0012,H.\u001a3!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u0011QO \u0005\bs.\t\t\u00111\u0001q\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0013\u0001D1mYN\u001b\u0007.\u001a3vY\u0016$WCAA\u0003!\rY\u0013qA\u0005\u0004\u0003\u0013a#a\u0002\"p_2,\u0017M\\\u0001\u0011C2d7k\u00195fIVdW\rZ0%KF$2!^A\b\u0011!Ih\"!AA\u0002\u0005\u0015\u0011!D1mYN\u001b\u0007.\u001a3vY\u0016$\u0007%A\fj]\u000e\u0014X-\\3oiN\u001b\u0007.\u001a3vY\u0016$Wk]3sgR\tQ/A\btKR\fE\u000e\\*dQ\u0016$W\u000f\\3e\u0003UIgn\u0019:f[\u0016tGo\u0015;paB,G-V:feN\f\u0011b\u001d;beR,6/\u001a:\u0015\u000bU\fy\"!\u000b\t\u000f\u0005\u00052\u00031\u0001\u0002$\u00051Qo]3s\u0013\u0012\u00042aKA\u0013\u0013\r\t9\u0003\f\u0002\u0005\u0019>tw\rC\u0004\u0002,M\u0001\r!!\f\u0002\u0013\u00154XM\u001c;M_>\u0004\bcA(\u00020%\u0019\u0011\u0011\u0007)\u0003\u0013\u00153XM\u001c;M_>\u0004\u0018AC5oU\u0016\u001cG/V:feR\u0019Q/a\u000e\t\u000f\u0005eB\u00031\u0001\u0002<\u0005)A-\u001a7bsB!\u0011QHA#\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\u0019c\u0013\u0002BA$\u0003\u007f\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\nhKR\u001cuN\\2veJ,g\u000e^+tKJ\u001c\u0018\u0001D:dK:\f'/[8OC6,WCAA(!\u0011\t\t&a\u0018\u000f\t\u0005M\u00131\f\t\u0004\u0003+bSBAA,\u0015\r\tI\u0006K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005uC&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;b\u0013aC5oU\u0016\u001cGOQ1uG\"$2!^A5\u0011\u001d\tYg\u0006a\u0001\u0003w\t1BY1uG\"<\u0016N\u001c3po\u00069QM\u001c3Vg\u0016\u0014HcA;\u0002r!9\u00111\u000f\rA\u0002\u0005U\u0014aC;tKJlUm]:bO\u0016\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wJ\u0016AB<sSR,'/\u0003\u0003\u0002\u0000\u0005e$AD+tKJ,e\u000eZ'fgN\fw-Z\u0001\u0014SN\fE\u000e\\+tKJ\u001c8k\u00195fIVdW\rZ\u0001\u0012SN\fE\u000e\\+tKJ\u001c8\u000b^8qa\u0016$WCAA\u001e\u0003\u001dI7/R7qif\u0004")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final EventLoopGroup eventLoopGroup;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private int scheduled;
    private int stopped;
    private boolean allScheduled;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(int x$1) {
        this.scheduled = x$1;
    }

    private int stopped() {
        return this.stopped;
    }

    private void stopped_$eq(int x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1);
    }

    public void setAllScheduled() {
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1);
    }

    private void startUser(long userId, EventLoop eventLoop) {
        BoxedUnit boxedUnit;
        Session rawSession = Session$.MODULE$.apply(this.scenario.name(), userId, this.scenario.onExit(), eventLoop);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        long timestamp = this.clock.nowMillis();
        this.scenario.entry().$bang(session);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", (Object)BoxesRunTime.boxToLong((long)session.userId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUserStart(this.scenario.name(), timestamp);
    }

    public void injectUser(FiniteDuration delay) {
        block2: {
            this.incrementScheduledUsers();
            long userId = this.userIdGen.incrementAndGet();
            EventLoop eventLoop = this.eventLoopGroup.next();
            if (eventLoop.isShutdown()) break block2;
            if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
                eventLoop.execute(() -> this.startUser(userId, eventLoop));
            } else {
                eventLoop.schedule(() -> this.startUser(userId, eventLoop), delay.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public int getConcurrentUsers() {
        return this.scheduled() - this.stopped();
    }

    public String scenarioName() {
        return this.scenario.name();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser(UserEndMessage var1);

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public abstract FiniteDuration duration();

    public abstract boolean isEmpty();

    public Workload(Scenario scenario, AtomicLong userIdGen, EventLoopGroup eventLoopGroup, StatsEngine statsEngine, Clock clock) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.eventLoopGroup = eventLoopGroup;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0;
        this.stopped = 0;
        this.allScheduled = false;
        Statics.releaseFence();
    }
}

