/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserEndMessage;
import io.gatling.core.stats.writer.UserStartMessage;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\b\u0011\u0001mA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0013I\u0004B\u0002\"\u0001A\u0003%!\bC\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00053\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003]\u0001\u0011%Q\fC\u0003e\u0001\u0011%Q\rC\u0003l\u0001\u0011%A\u000eC\u0003|\u0001\u0011%A\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\t\t2i\u001c8t_2,G)\u0019;b/JLG/\u001a:\u000b\u0005E\u0011\u0012AB<sSR,'O\u0003\u0002\u0014)\u0005)1\u000f^1ug*\u0011QCF\u0001\u0005G>\u0014XM\u0003\u0002\u00181\u00059q-\u0019;mS:<'\"A\r\u0002\u0005%|7\u0001A\n\u0003\u0001q\u00012!\b\u0010!\u001b\u0005\u0001\u0012BA\u0010\u0011\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003;\u0005J!A\t\t\u0003\u0017\r{gn]8mK\u0012\u000bG/Y\u0001\u0006G2|7m\u001b\t\u0003K)j\u0011A\n\u0006\u0003O!\nA!\u001e;jY*\u0011\u0011FF\u0001\bG>lWn\u001c8t\u0013\tYcEA\u0003DY>\u001c7.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003]Ej\u0011a\f\u0006\u0003aQ\taaY8oM&<\u0017B\u0001\u001a0\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2!\u000e\u001c8!\ti\u0002\u0001C\u0003$\u0007\u0001\u0007A\u0005C\u0003-\u0007\u0001\u0007Q&\u0001\bgYV\u001c\b\u000eV5nKJt\u0015-\\3\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t1\fgn\u001a\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0004TiJLgnZ\u0001\u0010M2,8\u000f\u001b+j[\u0016\u0014h*Y7fA\u00051qN\\%oSR$\"\u0001I#\t\u000b\u00193\u0001\u0019A$\u0002\t%t\u0017\u000e\u001e\t\u0003;!K!!\u0013\t\u0003\t%s\u0017\u000e^\u0001\b_:4E.^:i)\ta%\u000b\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJ\u0001\u0003V]&$\b\"B*\b\u0001\u0004\u0001\u0013\u0001\u00023bi\u0006\f\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u0007136\fC\u0003X\u0011\u0001\u0007\u0001,A\u0004nKN\u001c\u0018mZ3\u0011\u0005uI\u0016B\u0001.\u0011\u0005Aau.\u00193Fm\u0016tG/T3tg\u0006<W\rC\u0003T\u0011\u0001\u0007\u0001%\u0001\np]V\u001bXM]*uCJ$X*Z:tC\u001e,Gc\u0001'_G\")q,\u0003a\u0001A\u0006!Qo]3s!\ti\u0012-\u0003\u0002c!\t\u0001Rk]3s'R\f'\u000f^'fgN\fw-\u001a\u0005\u0006'&\u0001\r\u0001I\u0001\u0011_:,6/\u001a:F]\u0012lUm]:bO\u0016$2\u0001\u00144k\u0011\u0015y&\u00021\u0001h!\ti\u0002.\u0003\u0002j!\tqQk]3s\u000b:$W*Z:tC\u001e,\u0007\"B*\u000b\u0001\u0004\u0001\u0013!E8o%\u0016\u001c\bo\u001c8tK6+7o]1hKR\u0019A*\u001c:\t\u000b9\\\u0001\u0019A8\u0002\u0011I,7\u000f]8og\u0016\u0004\"!\b9\n\u0005E\u0004\"a\u0004*fgB|gn]3NKN\u001c\u0018mZ3\t\u000bM[\u0001\u0019\u0001\u0011)\t-!x\u000f\u001f\t\u0003wUL!A\u001e\u001f\u0003!M+\b\u000f\u001d:fgN<\u0016M\u001d8j]\u001e\u001c\u0018!\u0002<bYV,G&A=\"\u0003i\f\u0001e\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f'jgR\f\u0005\u000f]3oI\u0006qqN\\#se>\u0014X*Z:tC\u001e,G\u0003\u0002'~\u0003\u000bAQA \u0007A\u0002}\fQ!\u001a:s_J\u00042!HA\u0001\u0013\r\t\u0019\u0001\u0005\u0002\r\u000bJ\u0014xN]'fgN\fw-\u001a\u0005\u0006'2\u0001\r\u0001I\u0001\b_:\u001c%/Y:i)\u0015a\u00151BA\u0012\u0011\u001d\ti!\u0004a\u0001\u0003\u001f\tQaY1vg\u0016\u0004B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)BT\u0007\u0003\u0003/Q1!!\u0007\u001b\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0004(\u0002\rA\u0013X\rZ3g\u0013\r\t\u0015\u0011\u0005\u0006\u0004\u0003;q\u0005\"B*\u000e\u0001\u0004\u0001\u0013AB8o'R|\u0007\u000fF\u0002M\u0003SAQa\u0015\bA\u0002\u0001\u0002")
public class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(this.clock.nowMillis());
        init.scenarios().foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.startTimerAtFixedRate(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().console().writePeriod());
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, new Date());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserStartMessage) {
            UserStartMessage userStartMessage = (UserStartMessage)loadEventMessage;
            this.onUserStartMessage(userStartMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof UserEndMessage) {
            UserEndMessage userEndMessage = (UserEndMessage)loadEventMessage;
            this.onUserEndMessage(userEndMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserStartMessage(UserStartMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userStart();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onUserEndMessage(UserEndMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userDone();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

