/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.check;

import io.gatling.commons.util.Equality;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.Validator;
import io.gatling.core.check.Validator$;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!B\u0013'\u0011\u0003yc!B\u0019'\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Qd\u0001B\u001e\u0002\u0005qB\u0001\u0002T\u0002\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u001b\u000e\u0011\t\u0011)A\u0005\u001d\")\u0011h\u0001C\u0001-\")1l\u0001C\u00019\")Qm\u0001C!M\u001a!q/\u0001\u0002y\u0011\u0015I\u0014\u0002\"\u0001~\u0011\u0015Y\u0016\u0002\"\u0001]\u0011\u0015)\u0017\u0002\"\u0011\u0000\r\u0019\tI!\u0001\u0002\u0002\f!IA*\u0004B\u0001B\u0003%\u0011\u0011\u0003\u0005\n\u001b6\u0011\t\u0011)A\u0005\u0003+Aa!O\u0007\u0005\u0002\u0005]\u0001\"B.\u000e\t\u0003a\u0006BB3\u000e\t\u0003\nyB\u0002\u0004\u0002*\u0005\u0011\u00111\u0006\u0005\u0007sM!\t!!\u000e\t\u000bm\u001bB\u0011\u0001/\t\r\u0015\u001cB\u0011IA\u001d\r\u0019\t\u0019%\u0001\u0002\u0002F!IAj\u0006B\u0001B\u0003%\u0011q\n\u0005\u0007s]!\t!a\u001a\t\rm;B\u0011AA7\u0011\u0019)w\u0003\"\u0011\u0002~\u00191\u0011qQ\u0001\u0003\u0003\u0013C!\"a%\u001d\u0005\u000b\u0007I\u0011AA7\u0011)\t)\n\bB\u0001B\u0003%\u0011q\u000e\u0005\u000b\u0003/c\"\u0011!Q\u0001\n\u0005=\u0004BCAM9\t\u0005\t\u0015!\u0003\u0002\u001c\"IA\n\bB\u0001B\u0003%\u0011q\u0012\u0005\u0007sq!\t!!)\t\u000bmcB\u0011\u0001/\t\r\u0015dB\u0011IAW\u0003\u001di\u0015\r^2iKJT!a\n\u0015\u0002\u000b\rDWmY6\u000b\u0005%R\u0013\u0001B2pe\u0016T!a\u000b\u0017\u0002\u000f\u001d\fG\u000f\\5oO*\tQ&\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0019\u0002\u001b\u00051#aB'bi\u000eDWM]\n\u0003\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010\u0005\tI5/\u0006\u0002>\u0007N\u00191a\r \u0011\u0007Az\u0014)\u0003\u0002AM\tIa+\u00197jI\u0006$xN\u001d\t\u0003\u0005\u000ec\u0001\u0001B\u0003E\u0007\t\u0007QIA\u0001B#\t1\u0015\n\u0005\u00025\u000f&\u0011\u0001*\u000e\u0002\b\u001d>$\b.\u001b8h!\t!$*\u0003\u0002Lk\t\u0019\u0011I\\=\u0002\u0011\u0015D\b/Z2uK\u0012\f\u0001\"Z9vC2LG/\u001f\t\u0004\u001fR\u000bU\"\u0001)\u000b\u0005E\u0013\u0016\u0001B;uS2T!a\u0015\u0016\u0002\u000f\r|W.\\8og&\u0011Q\u000b\u0015\u0002\t\u000bF,\u0018\r\\5usR\u0019q+\u0017.\u0011\u0007a\u001b\u0011)D\u0001\u0002\u0011\u0015ae\u00011\u0001B\u0011\u0015ie\u00011\u0001O\u0003\u0011q\u0017-\\3\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004TiJLgnZ\u0001\u0006CB\u0004H.\u001f\u000b\u0004OB\u0014\bc\u00015l[6\t\u0011N\u0003\u0002k%\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\n\u00051L'A\u0003,bY&$\u0017\r^5p]B\u0019AG\\!\n\u0005=,$AB(qi&|g\u000eC\u0003r\u0011\u0001\u0007Q.\u0001\u0004bGR,\u0018\r\u001c\u0005\u0006g\"\u0001\r\u0001^\u0001\u0013I&\u001c\b\u000f\\1z\u0003\u000e$X/\u00197WC2,X\r\u0005\u00025k&\u0011a/\u000e\u0002\b\u0005>|G.Z1o\u0005\u0019I5OT;mYV\u0011\u0011\u0010`\n\u0004\u0013MR\bc\u0001\u0019@wB\u0011!\t \u0003\u0006\t&\u0011\r!\u0012\u000b\u0002}B\u0019\u0001,C>\u0015\r\u0005\u0005\u0011QAA\u0004!\u0011A7.a\u0001\u0011\u0007Qr7\u0010\u0003\u0004r\u0019\u0001\u0007\u00111\u0001\u0005\u0006g2\u0001\r\u0001\u001e\u0002\u0004\u001d>$X\u0003BA\u0007\u0003'\u0019B!D\u001a\u0002\u0010A!\u0001gPA\t!\r\u0011\u00151\u0003\u0003\u0006\t6\u0011\r!\u0012\t\u0005\u001fR\u000b\t\u0002\u0006\u0004\u0002\u001a\u0005m\u0011Q\u0004\t\u000516\t\t\u0002\u0003\u0004M!\u0001\u0007\u0011\u0011\u0003\u0005\u0007\u001bB\u0001\r!!\u0006\u0015\r\u0005\u0005\u0012QEA\u0014!\u0011A7.a\t\u0011\tQr\u0017\u0011\u0003\u0005\u0007cJ\u0001\r!a\t\t\u000bM\u0014\u0002\u0019\u0001;\u0003\u000f9{GOT;mYV!\u0011QFA\u001a'\u0011\u00192'a\f\u0011\tAz\u0014\u0011\u0007\t\u0004\u0005\u0006MB!\u0002#\u0014\u0005\u0004)ECAA\u001c!\u0011A6#!\r\u0015\r\u0005m\u0012qHA!!\u0011A7.!\u0010\u0011\tQr\u0017\u0011\u0007\u0005\u0007cZ\u0001\r!!\u0010\t\u000bM4\u0002\u0019\u0001;\u0003\u0005%sW\u0003BA$\u0003\u001b\u001aBaF\u001a\u0002JA!\u0001gPA&!\r\u0011\u0015Q\n\u0003\u0006\t^\u0011\r!\u0012\t\u0007\u0003#\n\t'a\u0013\u000f\t\u0005M\u0013Q\f\b\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\u0018\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014bAA0k\u00059\u0001/Y2lC\u001e,\u0017\u0002BA2\u0003K\u00121aU3r\u0015\r\ty&\u000e\u000b\u0005\u0003S\nY\u0007\u0005\u0003Y/\u0005-\u0003B\u0002'\u001a\u0001\u0004\ty%\u0006\u0002\u0002pA!\u0011\u0011OA=\u001d\u0011\t\u0019(!\u001e\u0011\u0007\u0005US'C\u0002\u0002xU\na\u0001\u0015:fI\u00164\u0017b\u00013\u0002|)\u0019\u0011qO\u001b\u0015\r\u0005}\u00141QAC!\u0011A7.!!\u0011\tQr\u00171\n\u0005\u0007cn\u0001\r!!!\t\u000bM\\\u0002\u0019\u0001;\u0003\u000f\r{W\u000e]1sKV!\u00111RAI'\u0011a2'!$\u0011\tAz\u0014q\u0012\t\u0004\u0005\u0006EE!\u0002#\u001d\u0005\u0004)\u0015AD2p[B\f'/[:p]:\u000bW.Z\u0001\u0010G>l\u0007/\u0019:jg>tg*Y7fA\u00059Q.Z:tC\u001e,\u0017aB2p[B\f'/\u001a\t\ti\u0005u\u0015qRAHi&\u0019\u0011qT\u001b\u0003\u0013\u0019+hn\u0019;j_:\u0014DCCAR\u0003K\u000b9+!+\u0002,B!\u0001\fHAH\u0011\u001d\t\u0019J\ta\u0001\u0003_Bq!a&#\u0001\u0004\ty\u0007C\u0004\u0002\u001a\n\u0002\r!a'\t\r1\u0013\u0003\u0019AAH)\u0019\ty+a-\u00026B!\u0001n[AY!\u0011!d.a$\t\rE$\u0003\u0019AAY\u0011\u0015\u0019H\u00051\u0001u\u0001")
public final class Matcher {

    public static final class Compare<A>
    implements Validator<A> {
        private final String comparisonName;
        private final String message;
        private final Function2<A, A, Object> compare;
        private final A expected;

        public String comparisonName() {
            return this.comparisonName;
        }

        @Override
        public String name() {
            return this.comparisonName() + "(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (BoxesRunTime.unboxToBoolean((Object)this.compare.apply(actualValue, this.expected))) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                if (displayActualValue) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(actualValue + " is not " + this.message + " " + this.expected));
                }
                return Validator$.MODULE$.GenericFailure();
            }
            return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("can't compare nothing and " + this.expected));
        }

        public Compare(String comparisonName, String message, Function2<A, A, Object> compare, A expected) {
            this.comparisonName = comparisonName;
            this.message = message;
            this.compare = compare;
            this.expected = expected;
        }
    }

    public static final class In<A>
    implements Validator<A> {
        private final Seq<A> expected;

        @Override
        public String name() {
            Seq<A> seq = this.expected;
            if (seq instanceof Range) {
                Range range = (Range)seq;
                return "in(" + range.toString() + ")";
            }
            return this.expected.mkString("in(", ",", ")");
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.expected.contains(actualValue)) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                if (displayActualValue) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
                }
                return Validator$.MODULE$.GenericFailure();
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }

        public In(Seq<A> expected) {
            this.expected = expected;
        }
    }

    public static final class Is<A>
    implements Validator<A> {
        private final A expected;
        private final Equality<A> equality;

        @Override
        public String name() {
            return "is(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.equality.equals(actualValue, this.expected)) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                if (displayActualValue) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
                }
                return Validator$.MODULE$.GenericFailure();
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }

        public Is(A expected, Equality<A> equality) {
            this.expected = expected;
            this.equality = equality;
        }
    }

    public static final class IsNull<A>
    implements Validator<A> {
        @Override
        public String name() {
            return "isNull";
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (actualValue == null) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                if (displayActualValue) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("found " + actualValue));
                }
                return Validator$.MODULE$.GenericFailure();
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }
    }

    public static final class Not<A>
    implements Validator<A> {
        private final A expected;
        private final Equality<A> equality;

        @Override
        public String name() {
            return "not(" + this.expected + ")";
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (this.equality.equals(actualValue, this.expected)) {
                    return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("unexpectedly found " + actualValue));
                }
                if (displayActualValue) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
                }
                return Validator$.MODULE$.GenericFailure();
            }
            return Validation$.MODULE$.NoneSuccess();
        }

        public Not(A expected, Equality<A> equality) {
            this.expected = expected;
            this.equality = equality;
        }
    }

    public static final class NotNull<A>
    implements Validator<A> {
        @Override
        public String name() {
            return "notNull";
        }

        @Override
        public Validation<Option<A>> apply(Option<A> actual, boolean displayActualValue) {
            Option<A> option = actual;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object actualValue = some.value();
                if (actualValue == null) {
                    return Validator$.MODULE$.GenericFailure();
                }
                return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(actual));
            }
            return Validator$.MODULE$.FoundNothingFailure();
        }
    }
}

