/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.stats.writer.StringInternals;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c!\u0002\u000b\u0016\u0005Uy\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011}\u0002!\u0011!Q\u0001\n\u0001CQ\u0001\u0012\u0001\u0005\u0002\u0015CqA\u0013\u0001A\u0002\u0013%1\nC\u0004S\u0001\u0001\u0007I\u0011B*\t\re\u0003\u0001\u0015)\u0003M\u0011\u001dQ\u0006A1A\u0005\nmCa\u0001\u001d\u0001!\u0002\u0013a\u0006\"B9\u0001\t\u0003\u0011\b\"B:\u0001\t\u0013!\b\"B<\u0001\t\u0003A\b\"\u0002@\u0001\t\u0003y\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!1\u00111\t\u0001\u0005BI\u0014\u0011DQ;gM\u0016\u0014X\r\u001a$jY\u0016\u001c\u0005.\u00198oK2<&/\u001b;fe*\u0011acF\u0001\u0007oJLG/\u001a:\u000b\u0005aI\u0012!B:uCR\u001c(B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005qi\u0012aB4bi2Lgn\u001a\u0006\u0002=\u0005\u0011\u0011n\\\n\u0005\u0001\u0001B3\u0006\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\r=\u0013'.Z2u!\t\t\u0013&\u0003\u0002+E\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005A\n\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003I\n1aY8n\u0013\t!TFA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\bG\"\fgN\\3m\u0007\u0001\u0001\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0011\rD\u0017M\u001c8fYNT!\u0001\u0010\u0013\u0002\u00079Lw.\u0003\u0002?s\tYa)\u001b7f\u0007\"\fgN\\3m\u0003\t\u0011'\r\u0005\u0002B\u00056\t1(\u0003\u0002Dw\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\rqJg.\u001b;?)\r1\u0005*\u0013\t\u0003\u000f\u0002i\u0011!\u0006\u0005\u0006k\r\u0001\ra\u000e\u0005\u0006\u007f\r\u0001\r\u0001Q\u0001\u0018gR\u0014\u0018N\\4DC\u000eDWmQ;se\u0016tG/\u00138eKb,\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0004\u0013:$\u0018aG:ue&twmQ1dQ\u0016\u001cUO\u001d:f]RLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q*V\u0005\u0003-:\u0013A!\u00168ji\"9\u0001,BA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005A2\u000f\u001e:j]\u001e\u001c\u0015m\u00195f\u0007V\u0014(/\u001a8u\u0013:$W\r\u001f\u0011\u0002\u0017M$(/\u001b8h\u0007\u0006\u001c\u0007.Z\u000b\u00029B!Q\f\u00192n\u001b\u0005q&BA0%\u0003\u0011)H/\u001b7\n\u0005\u0005t&a\u0002%bg\"l\u0015\r\u001d\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015tU\"\u00014\u000b\u0005\u001d4\u0014A\u0002\u001fs_>$h(\u0003\u0002j\u001d\u00061\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIg\n\u0005\u0002\"]&\u0011qN\t\u0002\b\u0013:$XmZ3s\u00031\u0019HO]5oO\u000e\u000b7\r[3!\u0003\u00151G.^:i)\u0005!\u0016AD3ogV\u0014XmQ1qC\u000eLG/\u001f\u000b\u0003)VDQA\u001e\u0006A\u00021\u000b\u0011![\u0001\noJLG/\u001a\"zi\u0016$\"\u0001V=\t\u000bi\\\u0001\u0019A>\u0002\t\tLH/\u001a\t\u0003\u001brL!! (\u0003\t\tKH/Z\u0001\roJLG/\u001a\"p_2,\u0017M\u001c\u000b\u0004)\u0006\u0005\u0001bBA\u0002\u0019\u0001\u0007\u0011QA\u0001\bE>|G.Z1o!\ri\u0015qA\u0005\u0004\u0003\u0013q%a\u0002\"p_2,\u0017M\\\u0001\u000boJLG/\u001a\"zi\u0016\u001cHc\u0001+\u0002\u0010!9\u0011\u0011C\u0007A\u0002\u0005M\u0011!\u00022zi\u0016\u001c\b\u0003B'\u0002\u0016mL1!a\u0006O\u0005\u0015\t%O]1z\u0003=9(/\u001b;f\u0005f$XMQ;gM\u0016\u0014Hc\u0001+\u0002\u001e!1\u0011q\u0004\bA\u0002\u0001\u000b1a\u001d:d\u0003E9(/\u001b;f\u0007\u0006\u001c\u0007.\u001a3TiJLgn\u001a\u000b\u0004)\u0006\u0015\u0002BBA\u0014\u001f\u0001\u0007!-\u0001\u0004tiJLgnZ\u0001\foJLG/Z*ue&tw\rF\u0002U\u0003[Aa!a\n\u0011\u0001\u0004\u0011\u0017\u0001C<sSR,\u0017J\u001c;\u0015\u0007Q\u000b\u0019\u0004\u0003\u0004\u00026E\u0001\r\u0001T\u0001\u0002Y\u0006IqO]5uK2{gn\u001a\u000b\u0004)\u0006m\u0002bBA\u001b%\u0001\u0007\u0011Q\b\t\u0004\u001b\u0006}\u0012bAA!\u001d\n!Aj\u001c8h\u0003\u0015\u0019Gn\\:f\u0001")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final ByteBuffer bb;
    private int stringCacheCurrentIndex;
    private final HashMap<String, Integer> stringCache;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int stringCacheCurrentIndex() {
        return this.stringCacheCurrentIndex;
    }

    private void stringCacheCurrentIndex_$eq(int x$1) {
        this.stringCacheCurrentIndex = x$1;
    }

    private HashMap<String, Integer> stringCache() {
        return this.stringCache;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        if (this.bb.remaining() < i) {
            this.flush();
            return;
        }
    }

    public void writeByte(byte by) {
        this.ensureCapacity(1);
        this.bb.put(by);
    }

    public void writeBoolean(boolean bl) {
        this.writeByte(bl ? (byte)1 : 0);
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(4 + bytes.length);
        this.bb.putInt(bytes.length);
        this.bb.put(bytes);
    }

    public void writeByteBuffer(ByteBuffer src) {
        this.ensureCapacity(4 + src.remaining());
        this.bb.putInt(src.remaining());
        this.bb.put(src);
    }

    public void writeCachedString(String string) {
        Integer cachedIndex = this.stringCache().get(string);
        if (cachedIndex == null) {
            this.writeInt(this.stringCacheCurrentIndex());
            this.writeString(string);
            this.stringCache().put(string, Predef$.MODULE$.int2Integer(this.stringCacheCurrentIndex()));
            this.stringCacheCurrentIndex_$eq(this.stringCacheCurrentIndex() + 1);
            return;
        }
        this.writeInt(-cachedIndex.intValue());
    }

    public void writeString(String string) {
        if (string.isEmpty()) {
            this.bb.putInt(0);
            return;
        }
        byte[] value = StringInternals.value(string);
        int valueLength = value.length;
        byte coder = StringInternals.coder(string);
        this.ensureCapacity(5 + valueLength);
        this.bb.putInt(value.length);
        int originalPosition = this.bb.position();
        System.arraycopy(value, 0, this.bb.array(), originalPosition, valueLength);
        this.bb.position(originalPosition + valueLength);
        this.bb.put(coder);
    }

    public void writeInt(int l) {
        this.ensureCapacity(4);
        this.bb.putInt(l);
    }

    public void writeLong(long l) {
        this.ensureCapacity(8);
        this.bb.putLong(l);
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
    }

    public BufferedFileChannelWriter(FileChannel channel, ByteBuffer bb) {
        this.channel = channel;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
        this.stringCacheCurrentIndex = 1;
        this.stringCache = new HashMap();
        Statics.releaseFence();
    }
}

