/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.actor;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.actor.Actor;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.AtomicRunnableActorRef;
import io.gatling.core.actor.Scheduler;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\b\u0010\u0005aAQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019A\u0005\u0001)A\u0005\u0003\")\u0011\n\u0001C\u0001\u0015\"9a\n\u0001b\u0001\n\u0003y\u0005BB*\u0001A\u0003%\u0001\u000bC\u0004U\u0001\t\u0007I\u0011B+\t\r\u0005\u0004\u0001\u0015!\u0003W\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000b\u00111\"Q2u_J\u001c\u0016p\u001d;f[*\u0011\u0001#E\u0001\u0006C\u000e$xN\u001d\u0006\u0003%M\tAaY8sK*\u0011A#F\u0001\bO\u0006$H.\u001b8h\u0015\u00051\u0012AA5p\u0007\u0001\u0019B\u0001A\r\"IA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001bE%\u00111e\u0007\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0011\u0005\u0015bS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0015+\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0016\u0002\u0007\r|W.\u0003\u0002.M\ti1\u000b\u001e:jGRdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"A\b\u0002\r\rdwn]3e+\u0005!\u0004CA\u001b=\u001b\u00051$BA\u001c9\u0003\u0019\tGo\\7jG*\u0011\u0011HO\u0001\u000bG>t7-\u001e:sK:$(BA\u001e\u001e\u0003\u0011)H/\u001b7\n\u0005u2$!D!u_6L7MQ8pY\u0016\fg.A\u0004dY>\u001cX\r\u001a\u0011\u0002\u0011\u0015DXmY;u_J,\u0012!\u0011\t\u0003\u0005\u001ak\u0011a\u0011\u0006\u0003s\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u000e\u0013q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003%)\u00070Z2vi>\u0014\b%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t1\n\u0005\u0002C\u0019&\u0011Qj\u0011\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011b]2iK\u0012,H.\u001a:\u0016\u0003A\u0003\"!M)\n\u0005I{!!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0013_:$VM]7j]\u0006$\u0018n\u001c8UCN\\7/F\u0001W!\r9\u0006LW\u0007\u0002q%\u0011\u0011\f\u000f\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012$U-];f!\rYFLX\u0007\u0002\t&\u0011Q\f\u0012\u0002\n\rVt7\r^5p]B\u0002\"aW0\n\u0005\u0001$%\u0001B+oSR\f1c\u001c8UKJl\u0017N\\1uS>tG+Y:lg\u0002\nq!Y2u_J|e-\u0006\u0002eUR\u0011Qm\u001d\t\u0004c\u0019D\u0017BA4\u0010\u0005!\t5\r^8s%\u00164\u0007CA5k\u0019\u0001!Qa[\u0006C\u00021\u0014q!T3tg\u0006<W-\u0005\u0002naB\u00111L\\\u0005\u0003_\u0012\u0013qAT8uQ&tw\r\u0005\u0002\\c&\u0011!\u000f\u0012\u0002\u0004\u0003:L\b\"\u0002\t\f\u0001\u0004!\bcA\u0019vQ&\u0011ao\u0004\u0002\u0006\u0003\u000e$xN]\u0001\u0016e\u0016<\u0017n\u001d;fe>sG+\u001a:nS:\fG/[8o+\rI\u0018\u0011\u0001\u000b\u0003=jDaa\u001f\u0007\u0005\u0002\u0004a\u0018\u0001B2pI\u0016\u00042aW?\u0000\u0013\tqHI\u0001\u0005=Eft\u0017-\\3?!\rI\u0017\u0011\u0001\u0003\u0006W2\u0011\r\u0001\\\u0001\u0006G2|7/\u001a\u000b\u0002=\u0002")
public final class ActorSystem
implements AutoCloseable,
StrictLogging {
    private final AtomicBoolean closed;
    private final ExecutionContextExecutorService executor;
    private final Scheduler scheduler;
    private final ConcurrentLinkedDeque<Function0<BoxedUnit>> onTerminationTasks;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private ExecutionContextExecutorService executor() {
        return this.executor;
    }

    public ExecutionContext executionContext() {
        return this.executor();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ConcurrentLinkedDeque<Function0<BoxedUnit>> onTerminationTasks() {
        return this.onTerminationTasks;
    }

    public <Message> ActorRef<Message> actorOf(Actor<Message> actor) {
        Predef$.MODULE$.require(!this.closed().get(), (Function0 & Serializable)() -> "Can't spawn an actor with a closed ActorSystem");
        return new AtomicRunnableActorRef<Message>(actor, this);
    }

    public <Message> void registerOnTermination(Function0<Message> code) {
        this.onTerminationTasks().add((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> code.apply());
    }

    @Override
    public void close() {
        if (this.closed().compareAndSet(false, true)) {
            this.onTerminationTasks().descendingIterator().forEachRemaining(x$1 -> x$1.apply$mcV$sp());
            this.executor().shutdown();
            this.scheduler().close();
            return;
        }
    }

    public ActorSystem() {
        StrictLogging.$init$((StrictLogging)this);
        this.closed = new AtomicBoolean();
        this.executor = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        this.scheduler = new Scheduler(Executors.newSingleThreadScheduledExecutor());
        this.onTerminationTasks = new ConcurrentLinkedDeque();
        Statics.releaseFence();
    }
}

