/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.util.Longs;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.file.Path;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Er!B\b\u0011\u0011\u0003Yb!B\u000f\u0011\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003Ac\u0001B\u000f\u0011\u0005)B\u0001\u0002\u0011\u0003\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0013\u0012\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0002B\u0001B\u0003%\u0011\u000bC\u0003&\t\u0011\u0005Q\u000bC\u0003Z\t\u0011\u0005!\fC\u0003_\t\u0011%q\fC\u0003f\t\u0011\u0005a\rC\u0003p\t\u0011\u0005\u0001\u000fC\u0003\u007f\t\u0011\u0005q\u0010\u0003\u0004\u0002\f\u0011!\tEW\u0001\u001a\u0005V4g-\u001a:fI\u001aKG.Z\"iC:tW\r\\,sSR,'O\u0003\u0002\u0012%\u00051qO]5uKJT!a\u0005\u000b\u0002\u000bM$\u0018\r^:\u000b\u0005U1\u0012\u0001B2pe\u0016T!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_\u000e\u0001\u0001C\u0001\u000f\u0002\u001b\u0005\u0001\"!\u0007\"vM\u001a,'/\u001a3GS2,7\t[1o]\u0016dwK]5uKJ\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0003baBd\u0017\u0010F\u0004*\u0003\u001b\t\t\"!\t\u0011\u0005q!1\u0003\u0002\u0003,gY\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004PE*,7\r\u001e\t\u0003YQJ!!N\u0017\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f!\t9d(D\u00019\u0015\tI$(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002<y\u0005AA/\u001f9fg\u00064WMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fa\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017aB2iC:tW\r\u001c\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0001b\u00195b]:,Gn\u001d\u0006\u0003\r>\n1A\\5p\u0013\tA5IA\u0006GS2,7\t[1o]\u0016d\u0017aB3oG>$WM\u001d\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0016\u000bqa\u00195beN,G/\u0003\u0002P\u0019\nq1\t[1sg\u0016$XI\\2pI\u0016\u0014\u0018A\u00012c!\t\u00116+D\u0001F\u0013\t!VI\u0001\u0006CsR,')\u001e4gKJ$B!\u000b,X1\")\u0001\t\u0003a\u0001\u0003\")\u0011\n\u0003a\u0001\u0015\")\u0001\u000b\u0003a\u0001#\u0006)a\r\\;tQR\t1\f\u0005\u0002!9&\u0011Q,\t\u0002\u0005+:LG/\u0001\bf]N,(/Z\"ba\u0006\u001c\u0017\u000e^=\u0015\u0005m\u0003\u0007\"B1\u000b\u0001\u0004\u0011\u0017!A5\u0011\u0005\u0001\u001a\u0017B\u00013\"\u0005\rIe\u000e^\u0001\u000boJLG/\u001a\"zi\u0016\u001cHCA.h\u0011\u0015A7\u00021\u0001j\u0003\u0015\u0011\u0017\u0010^3t!\r\u0001#\u000e\\\u0005\u0003W\u0006\u0012Q!\u0011:sCf\u0004\"\u0001I7\n\u00059\f#\u0001\u0002\"zi\u0016\f1b\u001e:ji\u0016\u001cFO]5oOR\u00111,\u001d\u0005\u0006e2\u0001\ra]\u0001\u0007gR\u0014\u0018N\\4\u0011\u0005Q\\hBA;z!\t1\u0018%D\u0001x\u0015\tA($\u0001\u0004=e>|GOP\u0005\u0003u\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\u0019\u0019FO]5oO*\u0011!0I\u0001\u0012oJLG/\u001a)pg&$\u0018N^3M_:<GcA.\u0002\u0002!9\u00111A\u0007A\u0002\u0005\u0015\u0011!\u00017\u0011\u0007\u0001\n9!C\u0002\u0002\n\u0005\u0012A\u0001T8oO\u0006)1\r\\8tK\"1\u0011qB\u0002A\u0002M\fQA];o\u0013\u0012Dq!a\u0005\u0004\u0001\u0004\t)\"\u0001\tsKN,H\u000e^:ESJ,7\r^8ssB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0015\u000bAAZ5mK&!\u0011qDA\r\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005\r2\u00011\u0001\u0002&\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0012AB2p]\u001aLw-\u0003\u0003\u00020\u0005%\"\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000e")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private Logger logger;

    public static BufferedFileChannelWriter apply(String runId, Path resultsDirectory, GatlingConfiguration configuration) {
        return BufferedFileChannelWriter$.MODULE$.apply(runId, resultsDirectory, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        if (this.bb.remaining() < i) {
            this.flush();
            return;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(bytes.length);
        this.bb.put(bytes);
    }

    public void writeString(String string) {
        this.ensureCapacity(string.length() * 4);
        CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(string), this.bb, false);
        if (coderResult.isOverflow()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Buffer overflow, you shouldn't be logging that much data. Truncating.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void writePositiveLong(long l) {
        int stringSize = Longs.positiveLongStringSize(l);
        this.ensureCapacity(stringSize);
        Longs.writePositiveLongString(l, stringSize, this.bb);
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
    }

    public BufferedFileChannelWriter(FileChannel channel, CharsetEncoder encoder, ByteBuffer bb) {
        this.channel = channel;
        this.encoder = encoder;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

