/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Sessions;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;

public final class Session {
    private final io.gatling.core.session.Session wrapped;

    public Session(io.gatling.core.session.Session session) {
        this.wrapped = session;
    }

    public <T> @Nullable T get(@NonNull String string) {
        return (T)this.wrapped.attributes().getOrElse((Object)string, () -> null);
    }

    public @Nullable String getString(@NonNull String string) {
        Object t = this.get(string);
        return t != null ? t.toString() : null;
    }

    public @Nullable Integer getIntegerWrapper(@NonNull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return (Integer)t;
        }
        if (t instanceof String) {
            return Integer.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(String.valueOf(t) + " is not an Integer: " + String.valueOf(t.getClass()));
    }

    public int getInt(@NonNull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(String.valueOf(object) + " is not an Integer: " + String.valueOf(object.getClass()));
    }

    public @Nullable Long getLongWrapper(@NonNull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return ((Integer)t).longValue();
        }
        if (t instanceof Long) {
            return (Long)t;
        }
        if (t instanceof String) {
            return Long.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(String.valueOf(t) + " is not an Long: " + String.valueOf(t.getClass()));
    }

    public long getLong(@NonNull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(String.valueOf(object) + " is not an Long: " + String.valueOf(object.getClass()));
    }

    public @Nullable Double getDoubleWrapper(@NonNull String string) {
        Object t = this.get(string);
        if (t instanceof Integer) {
            return ((Integer)t).doubleValue();
        }
        if (t instanceof Long) {
            return ((Long)t).doubleValue();
        }
        if (t instanceof Double) {
            return (Double)t;
        }
        if (t instanceof String) {
            return Double.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(String.valueOf(t) + " is not an Double: " + String.valueOf(t.getClass()));
    }

    public double getDouble(@NonNull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(String.valueOf(object) + " is not an Double: " + String.valueOf(object.getClass()));
    }

    public @Nullable Boolean getBooleanWrapper(@NonNull String string) {
        Object t = this.get(string);
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        if (t instanceof String) {
            return Boolean.valueOf((String)t);
        }
        if (t == null) {
            return null;
        }
        throw new ClassCastException(String.valueOf(t) + " is not an Boolean: " + String.valueOf(t.getClass()));
    }

    public boolean getBoolean(@NonNull String string) {
        Object object = this.wrapped.attributes().apply((Object)string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        if (object == null) {
            throw new NullPointerException(string + " is null");
        }
        throw new ClassCastException(String.valueOf(object) + " is not an Boolean: " + String.valueOf(object.getClass()));
    }

    public <T> @NonNull List<T> getList(@NonNull String string) {
        T t = this.get(string);
        if (t instanceof List) {
            return (List)t;
        }
        if (t instanceof Seq) {
            return Converters.toJavaList((Seq)t);
        }
        if (t == null) {
            return Collections.emptyList();
        }
        throw new ClassCastException(String.valueOf(t) + " is not an List: " + String.valueOf(t.getClass()));
    }

    public <T> @NonNull java.util.Set<T> getSet(@NonNull String string) {
        T t = this.get(string);
        if (t instanceof java.util.Set) {
            return (java.util.Set)t;
        }
        if (t instanceof Set) {
            return Converters.toJavaSet((Set)t);
        }
        if (t != null) {
            throw new ClassCastException(String.valueOf(t) + " is not an Set: " + String.valueOf(t.getClass()));
        }
        return Collections.emptySet();
    }

    public <T> @NonNull java.util.Map<String, T> getMap(@NonNull String string) {
        T t = this.get(string);
        if (t instanceof java.util.Map) {
            return (java.util.Map)t;
        }
        if (t instanceof Map) {
            return Converters.toJavaMap((Map)t);
        }
        if (t == null) {
            return Collections.emptyMap();
        }
        throw new ClassCastException(String.valueOf(t) + " is not an Map: " + String.valueOf(t.getClass()));
    }

    public @NonNull Session set(@NonNull String string, Object object) {
        return new Session(this.wrapped.set(string, object));
    }

    public @NonNull Session setAll(@NonNull java.util.Map<String, Object> map) {
        return new Session(this.wrapped.setAll(Converters.toScalaMap(map)));
    }

    public @NonNull Session remove(@NonNull String string) {
        return new Session(this.wrapped.remove(string));
    }

    public @NonNull Session reset() {
        return new Session(this.wrapped.reset());
    }

    public @NonNull Session removeAll(String ... stringArray) {
        return new Session(this.wrapped.removeAll(Converters.toScalaSeq(stringArray)));
    }

    public boolean contains(@NonNull String string) {
        return this.wrapped.contains(string);
    }

    public boolean isFailed() {
        return this.wrapped.isFailed();
    }

    public @NonNull Session markAsSucceeded() {
        return new Session(this.wrapped.markAsSucceeded());
    }

    public @NonNull Session markAsFailed() {
        return new Session(this.wrapped.markAsFailed());
    }

    public @NonNull String scenario() {
        return this.wrapped.scenario();
    }

    public @NonNull List<String> groups() {
        return Sessions.groups(this);
    }

    public long userId() {
        return this.wrapped.userId();
    }

    public io.gatling.core.session.Session asScala() {
        return this.wrapped;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

