/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssCheckBuilder;
import io.gatling.core.check.css.CssCheckType;
import io.gatling.core.check.css.NodeConverter;
import io.gatling.core.check.jmespath.JmesPathCheckBuilder;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckBuilder;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonFilter;
import io.gatling.core.check.jsonpath.JsonPathCheckBuilder;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckBuilder;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.GroupExtractor;
import io.gatling.core.check.regex.RegexCheckBuilder;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Comparisons;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.CoreCheckBuilders;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.javaapi.core.internal.Expressions;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeSelector;
import net.jodah.typetools.TypeResolver;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple7;
import scala.Tuple8;

public interface CheckBuilder {
    public io.gatling.core.check.CheckBuilder<?, ?> asScala();

    public CheckType type();

    public static final class Css
    extends CssOfTypeMultipleFind.Default<CssCheckType> {
        public Css(CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String> multipleFind) {
            super(multipleFind, CoreCheckType.Css);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.MultipleFind<CssCheckType, NodeSelector, X> ofType(NodeConverter<X> nodeConverter) {
            CssCheckBuilder cssCheckBuilder = (CssCheckBuilder)this.wrapped;
            return new CssCheckBuilder(cssCheckBuilder.expression(), cssCheckBuilder.nodeAttribute(), cssCheckBuilder.selectors(), nodeConverter);
        }
    }

    public static interface CssOfTypeMultipleFind
    extends MultipleFind<String> {
        @NonNull
        public MultipleFind<String> ofString();

        @NonNull
        public MultipleFind<Node> ofNode();

        public static abstract class Default<T>
        extends MultipleFind.Default<T, NodeSelector, String, String>
        implements CssOfTypeMultipleFind {
            public Default(CheckBuilder.MultipleFind<T, NodeSelector, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, String.class, null);
            }

            @NonNull
            protected abstract <X> CheckBuilder.MultipleFind<T, NodeSelector, X> ofType(NodeConverter<X> var1);

            @Override
            @NonNull
            public MultipleFind<String> ofString() {
                return new MultipleFind.Default(this.ofType(NodeConverter.stringNodeConverter()), this.type, String.class, null);
            }

            @Override
            @NonNull
            public MultipleFind<Node> ofNode() {
                return new MultipleFind.Default(this.ofType(NodeConverter.nodeNodeConverter()), this.type, Node.class, null);
            }
        }
    }

    public static final class JsonpJsonPath
    extends JsonOfTypeMultipleFind.Default<JsonpJsonPathCheckType> {
        public JsonpJsonPath(@NonNull CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String> multipleFind) {
            super(multipleFind, CoreCheckType.JsonpJsonPath);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonpJsonPathCheckBuilder jsonpJsonPathCheckBuilder = (JsonpJsonPathCheckBuilder)this.wrapped;
            return new JsonpJsonPathCheckBuilder(jsonpJsonPathCheckBuilder.path(), jsonpJsonPathCheckBuilder.jsonPaths(), jsonFilter);
        }
    }

    public static final class JsonPath
    extends JsonOfTypeMultipleFind.Default<JsonPathCheckType> {
        public JsonPath(@NonNull CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String> multipleFind) {
            super(multipleFind, CoreCheckType.JsonPath);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonPathCheckBuilder jsonPathCheckBuilder = (JsonPathCheckBuilder)this.wrapped;
            return new JsonPathCheckBuilder(jsonPathCheckBuilder.path(), jsonPathCheckBuilder.jsonPaths(), jsonFilter);
        }
    }

    public static final class JsonpJmesPath
    extends JsonOfTypeFind.Default<JsonpJmesPathCheckType> {
        public JsonpJmesPath(@NonNull CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String> find) {
            super(find, CoreCheckType.JsonpJmesPath);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonpJmesPathCheckBuilder jsonpJmesPathCheckBuilder = (JsonpJmesPathCheckBuilder)this.wrapped;
            return new JsonpJmesPathCheckBuilder(jsonpJmesPathCheckBuilder.path(), jsonpJmesPathCheckBuilder.jmesPaths(), jsonFilter);
        }
    }

    public static final class JmesPath
    extends JsonOfTypeFind.Default<JmesPathCheckType> {
        public JmesPath(CheckBuilder.Find<JmesPathCheckType, JsonNode, String> find) {
            super(find, CoreCheckType.JmesPath);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.Find<JmesPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JmesPathCheckBuilder jmesPathCheckBuilder = (JmesPathCheckBuilder)this.wrapped;
            return new JmesPathCheckBuilder(jmesPathCheckBuilder.path(), jmesPathCheckBuilder.jmesPaths(), jsonFilter);
        }
    }

    public static interface JsonOfTypeMultipleFind
    extends MultipleFind<String> {
        @NonNull
        public MultipleFind<String> ofString();

        @NonNull
        public MultipleFind<Boolean> ofBoolean();

        @NonNull
        public MultipleFind<Integer> ofInt();

        @NonNull
        public MultipleFind<Long> ofLong();

        @NonNull
        public MultipleFind<Double> ofDouble();

        @NonNull
        public MultipleFind<List<Object>> ofList();

        @NonNull
        public MultipleFind<Map<String, Object>> ofMap();

        @NonNull
        public MultipleFind<Object> ofObject();

        public static abstract class Default<T>
        extends MultipleFind.Default<T, JsonNode, String, String>
        implements JsonOfTypeMultipleFind {
            public Default(CheckBuilder.MultipleFind<T, JsonNode, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, String.class, null);
            }

            @NonNull
            protected abstract <X> CheckBuilder.MultipleFind<T, JsonNode, X> ofType(JsonFilter<X> var1);

            @Override
            @NonNull
            public MultipleFind<String> ofString() {
                return new MultipleFind.Default(this.ofType(JsonFilter.stringJsonFilter()), this.type, String.class, null);
            }

            @Override
            @NonNull
            public MultipleFind<Boolean> ofBoolean() {
                return new MultipleFind.Default<T, JsonNode, Object, Boolean>(this.ofType(JsonFilter.jBooleanJsonFilter()), this.type, Boolean.class, Boolean.class::cast);
            }

            @Override
            @NonNull
            public MultipleFind<Integer> ofInt() {
                return new MultipleFind.Default<T, JsonNode, Object, Integer>(this.ofType(JsonFilter.jIntegerJsonFilter()), this.type, Integer.class, Integer.class::cast);
            }

            @Override
            @NonNull
            public MultipleFind<Long> ofLong() {
                return new MultipleFind.Default<T, JsonNode, Object, Long>(this.ofType(JsonFilter.jLongJsonFilter()), this.type, Long.class, Long.class::cast);
            }

            @Override
            @NonNull
            public MultipleFind<Double> ofDouble() {
                return new MultipleFind.Default<T, JsonNode, Object, Double>(this.ofType(JsonFilter.jDoubleJsonFilter()), this.type, Double.class, Double.class::cast);
            }

            @Override
            @NonNull
            public MultipleFind<List<Object>> ofList() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jListJsonFilter()), this.type, List.class, null);
            }

            @Override
            @NonNull
            public MultipleFind<Map<String, Object>> ofMap() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jMapJsonFilter()), this.type, Map.class, null);
            }

            @Override
            @NonNull
            public MultipleFind<Object> ofObject() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jObjectJsonFilter()), this.type, Object.class, null);
            }
        }
    }

    public static interface JsonOfTypeFind
    extends Find<String> {
        @NonNull
        public Find<String> ofString();

        @NonNull
        public Find<Boolean> ofBoolean();

        @NonNull
        public Find<Integer> ofInt();

        @NonNull
        public Find<Long> ofLong();

        @NonNull
        public Find<Double> ofDouble();

        @NonNull
        public Find<List<Object>> ofList();

        @NonNull
        public Find<Map<String, Object>> ofMap();

        @NonNull
        public Find<Object> ofObject();

        public static abstract class Default<T>
        extends Find.Default<T, JsonNode, String, String>
        implements JsonOfTypeFind {
            public Default(CheckBuilder.Find<T, JsonNode, String> find, CheckType checkType) {
                super(find, checkType, String.class, null);
            }

            @NonNull
            protected abstract <X> CheckBuilder.Find<T, JsonNode, X> ofType(JsonFilter<X> var1);

            @Override
            @NonNull
            public Find<String> ofString() {
                return new Find.Default(this.ofType(JsonFilter.stringJsonFilter()), this.type, String.class, null);
            }

            @Override
            @NonNull
            public Find<Boolean> ofBoolean() {
                return new Find.Default<T, JsonNode, Object, Boolean>(this.ofType(JsonFilter.jBooleanJsonFilter()), this.type, Boolean.class, Boolean.class::cast);
            }

            @Override
            @NonNull
            public Find<Integer> ofInt() {
                return new Find.Default<T, JsonNode, Object, Integer>(this.ofType(JsonFilter.jIntegerJsonFilter()), this.type, Integer.class, Integer.class::cast);
            }

            @Override
            @NonNull
            public Find<Long> ofLong() {
                return new Find.Default<T, JsonNode, Object, Long>(this.ofType(JsonFilter.jLongJsonFilter()), this.type, Long.class, Long.class::cast);
            }

            @Override
            @NonNull
            public Find<Double> ofDouble() {
                return new Find.Default<T, JsonNode, Object, Double>(this.ofType(JsonFilter.jDoubleJsonFilter()), this.type, Double.class, Double.class::cast);
            }

            @Override
            @NonNull
            public Find<List<Object>> ofList() {
                return new Find.Default(this.ofType(JsonFilter.jListJsonFilter()), this.type, List.class, null);
            }

            @Override
            @NonNull
            public Find<Map<String, Object>> ofMap() {
                return new Find.Default(this.ofType(JsonFilter.jMapJsonFilter()), this.type, Map.class, null);
            }

            @Override
            @NonNull
            public Find<Object> ofObject() {
                return new Find.Default(this.ofType(JsonFilter.jObjectJsonFilter()), this.type, Object.class, null);
            }
        }
    }

    public static final class Regex
    extends CaptureGroupCheckBuilder.Default<RegexCheckType, String> {
        public Regex(CheckBuilder.MultipleFind<RegexCheckType, String, String> multipleFind) {
            super(multipleFind, CoreCheckType.Regex);
        }

        @Override
        @NonNull
        protected <X> CheckBuilder.MultipleFind<RegexCheckType, String, X> extract(@NonNull GroupExtractor<X> groupExtractor) {
            RegexCheckBuilder regexCheckBuilder = (RegexCheckBuilder)this.wrapped;
            return new RegexCheckBuilder(regexCheckBuilder.pattern(), regexCheckBuilder.patterns(), groupExtractor);
        }
    }

    public static interface CaptureGroupCheckBuilder
    extends MultipleFind<String> {
        @NonNull
        public MultipleFind<List<String>> captureGroups(int var1);

        public static abstract class Default<T, P>
        extends MultipleFind.Default<T, P, String, String>
        implements CaptureGroupCheckBuilder {
            public Default(CheckBuilder.MultipleFind<T, P, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, String.class, null);
            }

            protected abstract <X> CheckBuilder.MultipleFind<T, P, X> extract(GroupExtractor<X> var1);

            @Override
            @NonNull
            public MultipleFind<List<String>> captureGroups(int n) {
                switch (n) {
                    case 2: {
                        return new MultipleFind.Default<T, P, Tuple2, List>(this.extract(GroupExtractor.groupExtractor2()), this.type, List.class, Converters::toJavaList);
                    }
                    case 3: {
                        return new MultipleFind.Default<T, P, Tuple3, List>(this.extract(GroupExtractor.groupExtractor3()), this.type, List.class, Converters::toJavaList);
                    }
                    case 4: {
                        return new MultipleFind.Default<T, P, Tuple4, List>(this.extract(GroupExtractor.groupExtractor4()), this.type, List.class, Converters::toJavaList);
                    }
                    case 5: {
                        return new MultipleFind.Default<T, P, Tuple5, List>(this.extract(GroupExtractor.groupExtractor5()), this.type, List.class, Converters::toJavaList);
                    }
                    case 6: {
                        return new MultipleFind.Default<T, P, Tuple6, List>(this.extract(GroupExtractor.groupExtractor6()), this.type, List.class, Converters::toJavaList);
                    }
                    case 7: {
                        return new MultipleFind.Default<T, P, Tuple7, List>(this.extract(GroupExtractor.groupExtractor7()), this.type, List.class, Converters::toJavaList);
                    }
                    case 8: {
                        return new MultipleFind.Default<T, P, Tuple8, List>(this.extract(GroupExtractor.groupExtractor8()), this.type, List.class, Converters::toJavaList);
                    }
                }
                throw new IllegalArgumentException("captureGroups only supports between 2 and 8 capture groups, included, not " + n);
            }
        }
    }

    public static interface Final
    extends CheckBuilder {
        @NonNull
        public Final name(@NonNull String var1);

        @NonNull
        public Final saveAs(@NonNull String var1);

        public static final class Default<T, P>
        implements Final {
            private final CheckBuilder.Final<T, P> wrapped;
            private final CheckType type;

            public Default(CheckBuilder.Final<T, P> final_, CheckType checkType) {
                this.wrapped = final_;
                this.type = checkType;
            }

            @Override
            @NonNull
            public Final name(@NonNull String string) {
                return new Default<T, P>(this.wrapped.name(string), this.type);
            }

            @Override
            @NonNull
            public Final saveAs(@NonNull String string) {
                return new Default<T, P>(this.wrapped.saveAs(string), this.type);
            }

            @Override
            @NonNull
            public CheckType type() {
                return this.type;
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.wrapped;
            }
        }
    }

    public static interface Validate<X>
    extends Final {
        @NonNull
        public <X2> Validate<X2> transform(@NonNull Function<X, X2> var1);

        @NonNull
        public <X2> Validate<X2> transformWithSession(@NonNull BiFunction<X, Session, X2> var1);

        @NonNull
        public Validate<X> withDefault(@NonNull X var1);

        @NonNull
        public Validate<X> withDefaultEl(@NonNull String var1);

        @NonNull
        public Validate<X> withDefault(@NonNull Function<Session, X> var1);

        @NonNull
        public Final validate(@NonNull String var1, @NonNull BiFunction<X, Session, X> var2);

        @NonNull
        public Final is(X var1);

        @NonNull
        default public Final shouldBe(X x) {
            return this.is(x);
        }

        @NonNull
        public Final isEL(String var1);

        @NonNull
        public Final is(Function<Session, X> var1);

        @NonNull
        default public Final shouldBe(Function<Session, X> function) {
            return this.is(function);
        }

        public Final isNull();

        @NonNull
        public Final not(@NonNull X var1);

        @NonNull
        public Final notEL(@NonNull String var1);

        @NonNull
        public Final not(@NonNull Function<Session, X> var1);

        public Final notNull();

        @NonNull
        public Final in(X ... var1);

        @NonNull
        default public Final within(X ... XArray) {
            return this.in(XArray);
        }

        @NonNull
        public Final in(@NonNull List<X> var1);

        @NonNull
        default public Final within(@NonNull List<X> list) {
            return this.in(list);
        }

        @NonNull
        public Final inEL(@NonNull String var1);

        @NonNull
        default public Final withinEL(@NonNull String string) {
            return this.inEL(string);
        }

        @NonNull
        public Final in(@NonNull Function<Session, List<X>> var1);

        @NonNull
        default public Final within(@NonNull Function<Session, List<X>> function) {
            return this.in(function);
        }

        @NonNull
        public Final exists();

        @NonNull
        public Final notExists();

        @NonNull
        public Final optional();

        @NonNull
        public Final lt(@NonNull X var1);

        @NonNull
        public Final ltEL(@NonNull String var1);

        @NonNull
        public Final lt(@NonNull Function<Session, X> var1);

        @NonNull
        public Final lte(@NonNull X var1);

        @NonNull
        public Final lteEL(@NonNull String var1);

        @NonNull
        public Final lte(@NonNull Function<Session, X> var1);

        @NonNull
        public Final gt(@NonNull X var1);

        @NonNull
        public Final gtEL(@NonNull String var1);

        @NonNull
        public Final gt(@NonNull Function<Session, X> var1);

        @NonNull
        public Final gte(@NonNull X var1);

        @NonNull
        public Final gteEL(@NonNull String var1);

        @NonNull
        public Final gte(@NonNull Function<Session, X> var1);

        public static final class Default<T, P, X>
        implements Validate<X> {
            private final CheckBuilder.Validate<T, P, X> wrapped;
            private final CheckType type;
            private final Class<?> xClass;

            public Default(CheckBuilder.Validate<T, P, X> validate, CheckType checkType, Class<?> clazz) {
                this.wrapped = validate;
                this.type = checkType;
                this.xClass = clazz;
            }

            private Final makeFinal(CheckBuilder.Final<T, P> final_) {
                return new Final.Default<T, P>(final_, this.type);
            }

            @Override
            @NonNull
            public <X2> Validate<X2> transform(@NonNull Function<X, X2> function) {
                Class clazz = TypeResolver.resolveRawArguments(Function.class, function.getClass())[1];
                return new Default<T, P, X>(this.wrapped.transformOption(option -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(function.apply(object)));
                }), this.type, clazz);
            }

            @Override
            @NonNull
            public <X2> Validate<X2> transformWithSession(@NonNull BiFunction<X, Session, X2> biFunction) {
                Class clazz = TypeResolver.resolveRawArguments(BiFunction.class, biFunction.getClass())[2];
                return new Default<T, P, X>(this.wrapped.transformOptionWithSession((option, session) -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(biFunction.apply(object, new Session((io.gatling.core.session.Session)session))));
                }), this.type, clazz);
            }

            @Override
            @NonNull
            public Validate<X> withDefault(@NonNull X x) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.toStaticValueExpression(x)), this.type, this.xClass);
            }

            @Override
            @NonNull
            public Validate<X> withDefaultEl(@NonNull String string) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.toExpression(string, this.xClass)), this.type, this.xClass);
            }

            @Override
            @NonNull
            public Validate<X> withDefault(@NonNull Function<Session, X> function) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.javaFunctionToExpression(function)), this.type, this.xClass);
            }

            @Override
            @NonNull
            public Final is(@NonNull X x) {
                return this.makeFinal(this.wrapped.is(Expressions.toStaticValueExpression(x), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final validate(@NonNull String string, @NonNull BiFunction<X, Session, X> biFunction) {
                return this.makeFinal(this.wrapped.validate(string, (option, session) -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(biFunction.apply(object, new Session((io.gatling.core.session.Session)session))));
                }));
            }

            @Override
            @NonNull
            public Final isEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.is(Expressions.toExpression(string, this.xClass), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final is(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.is(Expressions.javaFunctionToExpression(function), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final isNull() {
                return this.makeFinal(this.wrapped.isNull());
            }

            @Override
            @NonNull
            public Final not(@NonNull X x) {
                return this.makeFinal(this.wrapped.not(Expressions.toStaticValueExpression(x), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final notEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.not(Expressions.toExpression(string, this.xClass), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final not(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.not(Expressions.javaFunctionToExpression(function), Comparisons.equality(this.xClass)));
            }

            @Override
            @NonNull
            public Final notNull() {
                return this.makeFinal(this.wrapped.notNull());
            }

            @Override
            @NonNull
            public Final in(X ... XArray) {
                return this.makeFinal(this.wrapped.in(Converters.toScalaSeq(XArray)));
            }

            @Override
            @NonNull
            public Final in(@NonNull List<X> list) {
                return this.makeFinal(this.wrapped.in(Converters.toScalaSeq(list)));
            }

            @Override
            @NonNull
            public Final inEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.in(Expressions.toSeqExpression(string)));
            }

            @Override
            @NonNull
            public Final in(@NonNull Function<Session, List<X>> function) {
                return this.makeFinal(this.wrapped.in(Expressions.javaListFunctionToExpression(function)));
            }

            @Override
            @NonNull
            public Final exists() {
                return this.makeFinal(this.wrapped.exists());
            }

            @Override
            @NonNull
            public Final notExists() {
                return this.makeFinal(this.wrapped.notExists());
            }

            @Override
            @NonNull
            public Final optional() {
                return this.makeFinal(this.wrapped.optional());
            }

            @Override
            @NonNull
            public Final lt(@NonNull X x) {
                return this.makeFinal(this.wrapped.lt(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final ltEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.lt(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final lt(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.lt(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final lte(@NonNull X x) {
                return this.makeFinal(this.wrapped.lte(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final lteEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.lte(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final lte(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.lte(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gt(@NonNull X x) {
                return this.makeFinal(this.wrapped.gt(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gtEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.gt(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gt(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.gt(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gte(@NonNull X x) {
                return this.makeFinal(this.wrapped.gte(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gteEL(@NonNull String string) {
                return this.makeFinal(this.wrapped.gte(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final gte(@NonNull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.gte(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @NonNull
            public Final name(@NonNull String string) {
                return this.exists().name(string);
            }

            @Override
            @NonNull
            public Final saveAs(@NonNull String string) {
                return this.exists().saveAs(string);
            }

            @Override
            @NonNull
            public CheckType type() {
                return this.exists().type();
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.exists().asScala();
            }
        }
    }

    public static interface MultipleFind<JavaX>
    extends Find<JavaX> {
        @NonNull
        public Validate<JavaX> find(int var1);

        @NonNull
        public Validate<List<JavaX>> findAll();

        @NonNull
        public Validate<JavaX> findRandom();

        @NonNull
        public Validate<List<JavaX>> findRandom(int var1);

        @NonNull
        public Validate<List<JavaX>> findRandom(int var1, boolean var2);

        @NonNull
        public Validate<Integer> count();

        public static class Default<T, P, ScalaX, JavaX>
        extends Find.Default<T, P, ScalaX, JavaX>
        implements MultipleFind<JavaX> {
            protected final CheckBuilder.MultipleFind<T, P, ScalaX> wrapped;

            public Default(@NonNull CheckBuilder.MultipleFind<T, P, ScalaX> multipleFind, @NonNull CheckType checkType, @NonNull Class<?> clazz, @Nullable Function<ScalaX, JavaX> function) {
                super(multipleFind, checkType, clazz, function);
                this.wrapped = multipleFind;
            }

            private <X2> Validate<X2> makeValidate(CheckBuilder.Validate<T, P, X2> validate, Class<?> clazz) {
                return new Validate.Default<T, P, X2>(validate, this.type, clazz);
            }

            @Override
            @NonNull
            public Validate<JavaX> find() {
                return this.makeValidate(CoreCheckBuilders.convertExtractedValueToJava(this.wrapped.find(), this.scalaXToJavaX), this.javaXClass);
            }

            @Override
            @NonNull
            public Validate<JavaX> find(int n) {
                return this.makeValidate(CoreCheckBuilders.convertExtractedValueToJava(this.wrapped.find(n), this.scalaXToJavaX), this.javaXClass);
            }

            @Override
            @NonNull
            public Validate<List<JavaX>> findAll() {
                return this.makeValidate(CoreCheckBuilders.convertExtractedSeqToJava(this.wrapped.findAll(), this.scalaXToJavaX), List.class);
            }

            @Override
            @NonNull
            public Validate<JavaX> findRandom() {
                return this.makeValidate(CoreCheckBuilders.convertExtractedValueToJava(this.wrapped.findRandom(), this.scalaXToJavaX), this.javaXClass);
            }

            @Override
            @NonNull
            public Validate<List<JavaX>> findRandom(int n) {
                return this.findRandom(n, false);
            }

            @Override
            @NonNull
            public Validate<List<JavaX>> findRandom(int n, boolean bl) {
                return this.makeValidate(CoreCheckBuilders.convertExtractedSeqToJava(this.wrapped.findRandom(n, bl), this.scalaXToJavaX), List.class);
            }

            @Override
            @NonNull
            public Validate<Integer> count() {
                return this.makeValidate(CoreCheckBuilders.toCountCheck(this.wrapped), Integer.class);
            }
        }
    }

    public static interface Find<JavaX>
    extends Validate<JavaX> {
        public Validate<JavaX> find();

        public static class Default<T, P, ScalaX, JavaX>
        implements Find<JavaX> {
            protected final CheckBuilder.Find<T, P, ScalaX> wrapped;
            protected final CheckType type;
            protected final Class<?> javaXClass;
            protected final Function<ScalaX, JavaX> scalaXToJavaX;

            public Default(CheckBuilder.Find<T, P, ScalaX> find, CheckType checkType, Class<?> clazz, Function<ScalaX, JavaX> function) {
                this.wrapped = find;
                this.type = checkType;
                this.javaXClass = clazz;
                this.scalaXToJavaX = function;
            }

            @Override
            @NonNull
            public Validate<JavaX> find() {
                return new Validate.Default(CoreCheckBuilders.convertExtractedValueToJava(this.wrapped.find(), this.scalaXToJavaX), this.type, this.javaXClass);
            }

            @Override
            @NonNull
            public <X2> Validate<X2> transform(@NonNull Function<JavaX, X2> function) {
                return this.find().transform(function);
            }

            @Override
            @NonNull
            public <X2> Validate<X2> transformWithSession(@NonNull BiFunction<JavaX, Session, X2> biFunction) {
                return this.find().transformWithSession(biFunction);
            }

            @Override
            @NonNull
            public Validate<JavaX> withDefault(@NonNull JavaX JavaX) {
                return this.find().withDefault(JavaX);
            }

            @Override
            @NonNull
            public Validate<JavaX> withDefaultEl(@NonNull String string) {
                return this.find().withDefaultEl(string);
            }

            @Override
            @NonNull
            public Validate<JavaX> withDefault(@NonNull Function<Session, JavaX> function) {
                return this.find().withDefault(function);
            }

            @Override
            @NonNull
            public Final validate(@NonNull String string, @NonNull BiFunction<JavaX, Session, JavaX> biFunction) {
                return this.find().validate(string, biFunction);
            }

            @Override
            @NonNull
            public Final isEL(@NonNull String string) {
                return this.find().isEL(string);
            }

            @Override
            @NonNull
            public Final is(@NonNull JavaX JavaX) {
                return this.find().is(JavaX);
            }

            @Override
            @NonNull
            public Final is(@NonNull Function<Session, JavaX> function) {
                return this.find().is(function);
            }

            @Override
            @NonNull
            public Final isNull() {
                return this.find().isNull();
            }

            @Override
            @NonNull
            public Final notEL(@NonNull String string) {
                return this.find().notEL(string);
            }

            @Override
            @NonNull
            public Final not(@NonNull JavaX JavaX) {
                return this.find().not(JavaX);
            }

            @Override
            @NonNull
            public Final not(@NonNull Function<Session, JavaX> function) {
                return this.find().not(function);
            }

            @Override
            @NonNull
            public Final notNull() {
                return this.find().notNull();
            }

            @Override
            @NonNull
            public Final in(JavaX ... JavaXArray) {
                return this.find().in(JavaXArray);
            }

            @Override
            @NonNull
            public Final in(@NonNull List<JavaX> list) {
                return this.find().in(list);
            }

            @Override
            @NonNull
            public Final inEL(@NonNull String string) {
                return this.find().inEL(string);
            }

            @Override
            @NonNull
            public Final in(@NonNull Function<Session, List<JavaX>> function) {
                return this.find().in(function);
            }

            @Override
            @NonNull
            public Final exists() {
                return this.find().exists();
            }

            @Override
            @NonNull
            public Final notExists() {
                return this.find().notExists();
            }

            @Override
            @NonNull
            public Final optional() {
                return this.find().optional();
            }

            @Override
            @NonNull
            public Final lt(@NonNull JavaX JavaX) {
                return this.find().lt(JavaX);
            }

            @Override
            @NonNull
            public Final ltEL(@NonNull String string) {
                return this.find().ltEL(string);
            }

            @Override
            @NonNull
            public Final lt(@NonNull Function<Session, JavaX> function) {
                return this.find().lt(function);
            }

            @Override
            @NonNull
            public Final lte(@NonNull JavaX JavaX) {
                return this.find().lte(JavaX);
            }

            @Override
            @NonNull
            public Final lteEL(@NonNull String string) {
                return this.find().lteEL(string);
            }

            @Override
            @NonNull
            public Final lte(@NonNull Function<Session, JavaX> function) {
                return this.find().lte(function);
            }

            @Override
            @NonNull
            public Final gt(@NonNull JavaX JavaX) {
                return this.find().gt(JavaX);
            }

            @Override
            @NonNull
            public Final gtEL(@NonNull String string) {
                return this.find().gtEL(string);
            }

            @Override
            @NonNull
            public Final gt(@NonNull Function<Session, JavaX> function) {
                return this.find().gt(function);
            }

            @Override
            @NonNull
            public Final gte(@NonNull JavaX JavaX) {
                return this.find().gte(JavaX);
            }

            @Override
            @NonNull
            public Final gteEL(@NonNull String string) {
                return this.find().gteEL(string);
            }

            @Override
            @NonNull
            public Final gte(@NonNull Function<Session, JavaX> function) {
                return this.find().gte(function);
            }

            @Override
            @NonNull
            public Final name(@NonNull String string) {
                return this.find().name(string);
            }

            @Override
            @NonNull
            public Final saveAs(@NonNull String string) {
                return this.find().saveAs(string);
            }

            @Override
            @NonNull
            public CheckType type() {
                return this.find().type();
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.find().asScala();
            }
        }
    }

    public static interface CheckType {
    }
}

