/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core.loop;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.StructureBuilder;
import io.gatling.javaapi.core.exec.Executable;
import io.gatling.javaapi.core.internal.Executables;
import io.gatling.javaapi.core.internal.loop.ScalaRepeat;
import java.util.UUID;
import java.util.function.Function;

public interface Repeat<T extends StructureBuilder<T, W>, W extends io.gatling.core.structure.StructureBuilder<W>> {
    public T make(Function<W, W> var1);

    @NonNull
    default public On<T> repeat(int n) {
        return this.repeat((Session session) -> n, UUID.randomUUID().toString());
    }

    @NonNull
    default public On<T> repeat(int n, @NonNull String string) {
        return new On(ScalaRepeat.apply(this, n, string));
    }

    @NonNull
    default public On<T> repeat(@NonNull String string) {
        return this.repeat(string, UUID.randomUUID().toString());
    }

    @NonNull
    default public On<T> repeat(@NonNull String string, @NonNull String string2) {
        return new On(ScalaRepeat.apply(this, string, string2));
    }

    @NonNull
    default public On<T> repeat(@NonNull Function<Session, Integer> function) {
        return this.repeat(function, UUID.randomUUID().toString());
    }

    @NonNull
    default public On<T> repeat(@NonNull Function<Session, Integer> function, String string) {
        return new On(ScalaRepeat.apply(this, function, string));
    }

    public static final class On<T extends StructureBuilder<T, ?>> {
        private final ScalaRepeat.Loop<T, ?> wrapped;

        On(ScalaRepeat.Loop<T, ?> loop) {
            this.wrapped = loop;
        }

        @NonNull
        public T on(@NonNull Executable executable, Executable ... executableArray) {
            return this.wrapped.loop(Executables.toChainBuilder(executable, executableArray));
        }
    }
}

