/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.ComponentLibrary$;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.AllSessionsReportGenerator;
import io.gatling.charts.report.AssertionsReportGenerator;
import io.gatling.charts.report.GlobalReportGenerator;
import io.gatling.charts.report.GroupDetailsReportGenerator;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.RequestDetailsReportGenerator;
import io.gatling.charts.report.StatsReportGenerator;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.template.MenuTemplate;
import io.gatling.charts.template.PageTemplate$;
import io.gatling.commons.shared.unstable.model.stats.RequestStatsPath;
import io.gatling.commons.shared.unstable.model.stats.StatsPath;
import io.gatling.commons.shared.unstable.util.ScanHelper$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U2Q\u0001B\u0003\u0001\u00135A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006YA\u0006\u0005\u0006=\u0001!\ta\b\u0005\u0006I\u0001!\t!\n\u0002\u0011%\u0016\u0004xN\u001d;t\u000f\u0016tWM]1u_JT!AB\u0004\u0002\rI,\u0007o\u001c:u\u0015\tA\u0011\"\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003\u0015-\tqaZ1uY&twMC\u0001\r\u0003\tIwn\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fQbY8oM&<WO]1uS>t7\u0001\u0001\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\taaY8oM&<'BA\u000e\n\u0003\u0011\u0019wN]3\n\u0005uA\"\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002AQ\u0011\u0011e\t\t\u0003E\u0001i\u0011!\u0002\u0005\u0006)\t\u0001\u001dAF\u0001\fO\u0016tWM]1uK\u001a{'\u000f\u0006\u0002'aA\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\u0005M&dWM\u0003\u0002,Y\u0005\u0019a.[8\u000b\u00035\nAA[1wC&\u0011q\u0006\u000b\u0002\u0005!\u0006$\b\u000eC\u00032\u0007\u0001\u0007!'A\fsKB|'\u000f^:HK:,'/\u0019;j_:Le\u000e];ugB\u0011!eM\u0005\u0003i\u0015\u0011qCU3q_J$8oR3oKJ\fG/[8o\u0013:\u0004X\u000f^:")
public class ReportsGenerator {
    private final GatlingConfiguration configuration;

    public Path generateFor(ReportsGenerationInputs reportsGenerationInputs) {
        ChartsFiles chartsFiles = new ChartsFiles(reportsGenerationInputs.reportFolderName(), this.configuration);
        if (!ReportsGenerator.hasAtLeastOneRequestReported$1(reportsGenerationInputs)) {
            throw new UnsupportedOperationException("There were no requests sent during the simulation, reports won't be generated");
        }
        List reportGenerators = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReportGenerator[]{new AllSessionsReportGenerator(reportsGenerationInputs, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.configuration), new GlobalReportGenerator(reportsGenerationInputs, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.configuration), new RequestDetailsReportGenerator(reportsGenerationInputs, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.configuration), new GroupDetailsReportGenerator(reportsGenerationInputs, chartsFiles, ComponentLibrary$.MODULE$.Instance(), this.configuration)}));
        ReportsGenerator.copyAssets$1(chartsFiles);
        this.generateMenu$1(chartsFiles);
        PageTemplate$.MODULE$.setRunInfo(reportsGenerationInputs.logFileReader().runMessage(), reportsGenerationInputs.logFileReader().runEnd());
        reportGenerators.foreach((Function1 & Serializable)x$2 -> {
            x$2.generate();
            return BoxedUnit.UNIT;
        });
        this.generateStats$1(reportsGenerationInputs, chartsFiles);
        this.generateAssertions$1(reportsGenerationInputs, chartsFiles);
        return chartsFiles.globalFile();
    }

    public static final /* synthetic */ boolean $anonfun$generateFor$1(StatsPath x$1) {
        return x$1 instanceof RequestStatsPath;
    }

    private static final boolean hasAtLeastOneRequestReported$1(ReportsGenerationInputs reportsGenerationInputs$1) {
        return reportsGenerationInputs$1.logFileReader().statsPaths().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReportsGenerator.$anonfun$generateFor$1(x$1)));
    }

    private final void generateMenu$1(ChartsFiles chartsFiles$1) {
        new TemplateWriter(chartsFiles$1.menuFile()).writeToFile(new MenuTemplate().getOutput(), this.configuration);
    }

    private final void generateStats$1(ReportsGenerationInputs reportsGenerationInputs$1, ChartsFiles chartsFiles$1) {
        new StatsReportGenerator(reportsGenerationInputs$1, chartsFiles$1, ComponentLibrary$.MODULE$.Instance(), this.configuration).generate();
    }

    private final void generateAssertions$1(ReportsGenerationInputs reportsGenerationInputs$1, ChartsFiles chartsFiles$1) {
        new AssertionsReportGenerator(reportsGenerationInputs$1, chartsFiles$1, ComponentLibrary$.MODULE$.Instance(), this.configuration).generate();
    }

    private static final void copyAssets$1(ChartsFiles chartsFiles$1) {
        ScanHelper$.MODULE$.deepCopyPackageContent(ChartsFiles$.MODULE$.GatlingAssetsStylePackage(), chartsFiles$1.styleDirectory());
        ScanHelper$.MODULE$.deepCopyPackageContent(ChartsFiles$.MODULE$.GatlingAssetsJsPackage(), chartsFiles$1.jsDirectory());
    }

    public ReportsGenerator(GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

