/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.template;

import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.stats.ErrorStats;
import io.gatling.core.stats.writer.ConsoleStatsFormat$;
import io.gatling.core.stats.writer.ConsoleSummary$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class ConsoleTemplate$ {
    public static final ConsoleTemplate$ MODULE$ = new ConsoleTemplate$();

    public <T> String writeRequestCounters(Stats<T> statistics, Numeric<T> evidence$1) {
        return ConsoleStatsFormat$.MODULE$.Header() + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString(statistics.name()), ConsoleStatsFormat$.MODULE$.ConsoleWidth() - ConsoleStatsFormat$.MODULE$.HeaderLength() - 3 * (ConsoleStatsFormat$.MODULE$.NumberLength() + 3)) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(statistics.total(), evidence$1) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(statistics.success(), evidence$1) + " | " + ConsoleStatsFormat$.MODULE$.formatNumber(statistics.failure(), evidence$1);
    }

    public String writeRange(String textLabel, int count, double percentage) {
        return ConsoleStatsFormat$.MODULE$.Header() + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString(textLabel), ConsoleStatsFormat$.MODULE$.ConsoleWidth() - ConsoleStatsFormat$.MODULE$.HeaderLength() - ConsoleStatsFormat$.MODULE$.NumberLength() - ConsoleStatsFormat$.MODULE$.PercentageLength() - 2) + " " + ConsoleStatsFormat$.MODULE$.formatNumber((Object)BoxesRunTime.boxToInteger((int)count), (Numeric)Numeric.IntIsIntegral$.MODULE$) + " " + ConsoleStatsFormat$.MODULE$.formatPercentage(percentage);
    }

    public StringBuilder writeErrorsBlock(StringBuilder sb, Seq<ErrorStats> errors) {
        block0: {
            if (!errors.nonEmpty()) break block0;
            sb.append(ConsoleSummary$.MODULE$.formatSubTitle("Errors")).append(StringHelper$.MODULE$.Eol());
            errors.foreach((Function1 & Serializable)x$1 -> ConsoleStatsFormat$.MODULE$.writeError(sb, x$1).append(StringHelper$.MODULE$.Eol()));
        }
        return sb;
    }

    public String println(RequestStatistics requestStatistics, Seq<ErrorStats> errors) {
        StringBuilder sb = new StringBuilder().append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |" + ConsoleStatsFormat$.MODULE$.NewBlock() + "\n                 |" + ConsoleStatsFormat$.MODULE$.formatSubTitleWithStatuses("Global Information") + "\n                 |" + this.writeRequestCounters(requestStatistics.numberOfRequestsStatistics(), (Numeric)Numeric.LongIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.minResponseTimeStatistics(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.maxResponseTimeStatistics(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.meanResponseTimeStatistics(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.stdDeviationStatistics(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.percentiles1(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.percentiles2(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.percentiles3(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.percentiles4(), (Numeric)Numeric.IntIsIntegral$.MODULE$) + "\n                 |" + this.writeRequestCounters(requestStatistics.meanNumberOfRequestsPerSecondStatistics(), (Numeric)Numeric.DoubleIsFractional$.MODULE$) + "\n                 |" + StringHelper.RichString$.MODULE$.rightPad$extension(StringHelper$.MODULE$.RichString("---- Response Time Distribution "), ConsoleStatsFormat$.MODULE$.ConsoleWidth(), "-") + "\n                 |" + this.writeRange("OK: t < " + requestStatistics.ranges().lowerBound() + " ms", requestStatistics.ranges().lowCount(), requestStatistics.ranges().lowPercentage()) + "\n                 |" + this.writeRange("OK: " + requestStatistics.ranges().lowerBound() + " ms <= t < " + requestStatistics.ranges().higherBound() + " ms", requestStatistics.ranges().middleCount(), requestStatistics.ranges().middlePercentage()) + "\n                 |" + this.writeRange("OK: t >= " + requestStatistics.ranges().higherBound() + " ms", requestStatistics.ranges().highCount(), requestStatistics.ranges().highPercentage()) + "\n                 |" + this.writeRange("KO", requestStatistics.ranges().koCount(), requestStatistics.ranges().koPercentage()) + "\n                 |")));
        this.writeErrorsBlock(sb, errors);
        return sb.append(ConsoleStatsFormat$.MODULE$.NewBlock()).append(StringHelper$.MODULE$.Eol()).toString();
    }

    private ConsoleTemplate$() {
    }
}

