/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.GeneralStats;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.GroupStatsPath;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.RequestStatsPath;
import io.gatling.charts.stats.StatsPath;
import io.gatling.charts.template.ConsoleTemplate$;
import io.gatling.charts.template.GlobalStatsJsonTemplate;
import io.gatling.charts.template.StatsJsTemplate;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u000513Qa\u0002\u0005\u0001\u0015AA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00159\u0005\u0001\"\u0001I\u0005Q\u0019F/\u0019;t%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011\u0011BC\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qi\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\t1aY8n\u0013\t\u0001\u0013DA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0018e\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\u001c\u0001\u0001\u0005\u0002%K5\t\u0001\"\u0003\u0002'\u0011\t9\"+\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho]\u0001\fG\"\f'\u000f^:GS2,7\u000f\u0005\u0002*Y5\t!F\u0003\u0002,\u0015\u000511m\u001c8gS\u001eL!!\f\u0016\u0003\u0017\rC\u0017M\u001d;t\r&dWm]\u0001\bG\"\f'o]3u!\t\u0001d'D\u00012\u0015\tq#G\u0003\u00024i\u0005\u0019a.[8\u000b\u0003U\nAA[1wC&\u0011q'\r\u0002\b\u0007\"\f'o]3u\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011!HP\u0007\u0002w)\u00111\u0006\u0010\u0006\u0003{1\tAaY8sK&\u0011qh\u000f\u0002\u0015%\u0016\u0004xN\u001d;t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\t!\u0003\u0001C\u0003\"\u000b\u0001\u00071\u0005C\u0003(\u000b\u0001\u0007\u0001\u0006C\u0003/\u000b\u0001\u0007q\u0006C\u00039\u000b\u0001\u0007\u0011(\u0001\u0005hK:,'/\u0019;f)\u0005I\u0005C\u0001\nK\u0013\tY5C\u0001\u0003V]&$\b")
public class StatsReportGenerator
implements StrictLogging {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final Charset charset;
    private final ReportsConfiguration configuration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void generate() {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1(ChartsFiles$.MODULE$.AllRequestLineTitle(), (Option)None$.MODULE$, (Option)None$.MODULE$));
        List<StatsPath> statsPaths = this.reportsGenerationInputs.logFileData().statsPaths();
        Map groupsByHierarchy = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    Group group = groupStatsPath.group();
                    return (B1)group;
                }
                if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Some some = (Some)option;
                    Group group = (Group)some.value();
                    return (B1)group;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                StatsPath statsPath = x1;
                if (statsPath instanceof GroupStatsPath) {
                    return true;
                }
                return statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
            }
        }).map((Function1 & Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RequestStatsPath) {
                    RequestStatsPath requestStatsPath = (RequestStatsPath)A1;
                    return (B1)requestStatsPath;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                return statsPath instanceof RequestStatsPath;
            }
        });
        requestStatsPaths.foreach((Function1 & Serializable)x0$1 -> {
            StatsReportGenerator.$anonfun$generate$11(this, rootContainer, seenGroups, groupsByHierarchy, x0$1);
            return BoxedUnit.UNIT;
        });
        new TemplateWriter(this.chartsFiles.statsJsFile()).writeToFile(new StatsJsTemplate(rootContainer, false).getOutput(), this.charset);
        new TemplateWriter(this.chartsFiles.statsJsonFile()).writeToFile(new StatsJsTemplate(rootContainer, true).getOutput(), this.charset);
        new TemplateWriter(this.chartsFiles.globalStatsJsonFile()).writeToFile(new GlobalStatsJsonTemplate(rootContainer.stats(), true).getOutput(), this.charset);
        Predef$.MODULE$.println((Object)ConsoleTemplate$.MODULE$.println(rootContainer.stats(), this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)));
    }

    private static final Stats percentiles$1(double rank, Function1 title, GeneralStats total, GeneralStats ok, GeneralStats ko) {
        return new Stats<Integer>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)) + " (ms)", BoxesRunTime.boxToInteger((int)total.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ok.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ko.percentile().apply$mcID$sp(rank)), (Numeric<Integer>)Numeric.IntIsIntegral$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$1(double rank) {
        return "response time " + NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank)) + " percentile";
    }

    private final RequestStatistics computeRequestStats$1(String name, Option requestName, Option group2) {
        String string;
        GeneralStats total = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)None$.MODULE$);
        GeneralStats ok = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)OK$.MODULE$));
        GeneralStats ko = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)KO$.MODULE$));
        Function1 & Serializable percentilesTitle = (Function1 & Serializable)rank -> StatsReportGenerator.$anonfun$generate$1(BoxesRunTime.unboxToDouble((Object)rank));
        Option option = requestName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = RequestPath$.MODULE$.path(n, (Option<Group>)group2);
        } else {
            string = (String)group2.map((Function1 & Serializable)group -> RequestPath$.MODULE$.path((Group)group)).getOrElse((Function0 & Serializable)() -> "");
        }
        String path = string;
        return new RequestStatistics(name, path, new Stats<Object>("request count", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("min response time (ms)", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("max response time (ms)", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("mean response time (ms)", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("response time std deviation (ms)", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile1(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile2(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile3(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile4(), percentilesTitle, total, ok, ko), this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRanges((Option<String>)requestName, (Option<Group>)group2), new Stats<Object>("mean throughput (rps)", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final Function2 groupStatsFunction$1() {
        BoxedUnit boxedUnit;
        if (this.configuration.useGroupDurationMetric()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupDurationGeneralStats((Group)group, (Option<Status>)status);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Use group cumulated response time stats.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
    }

    public static final /* synthetic */ String $anonfun$generate$6(double x$1) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$generate$7(double x$2) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$generate$8(double x$3) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$generate$9(double x$4) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(String name, Group group) {
        GeneralStats total = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)None$.MODULE$);
        GeneralStats ok = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        GeneralStats ko = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        return new RequestStatistics(name, RequestPath$.MODULE$.path(group), new Stats<Object>("numberOfRequests", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("minResponseTime", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("maxResponseTime", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("meanResponseTime", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("stdDeviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile1(), (Function1 & Serializable)x$1 -> StatsReportGenerator.$anonfun$generate$6(BoxesRunTime.unboxToDouble((Object)x$1)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile2(), (Function1 & Serializable)x$2 -> StatsReportGenerator.$anonfun$generate$7(BoxesRunTime.unboxToDouble((Object)x$2)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile3(), (Function1 & Serializable)x$3 -> StatsReportGenerator.$anonfun$generate$8(BoxesRunTime.unboxToDouble((Object)x$3)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile4(), (Function1 & Serializable)x$4 -> StatsReportGenerator.$anonfun$generate$9(BoxesRunTime.unboxToDouble((Object)x$4)), total, ok, ko), this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)), new Stats<Object>("meanNumberOfRequestsPerSecond", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final void addGroupsRec$1(List hierarchy, HashSet seenGroups$1, Map groupsByHierarchy$1, GroupContainer rootContainer$1) {
        if (!seenGroups$1.contains((Object)hierarchy)) {
            .colon.colon colon2;
            List tail;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).next$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, seenGroups$1, groupsByHierarchy$1, rootContainer$1);
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group.name(), group);
            rootContainer$1.addGroup(group, stats);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$generate$11(StatsReportGenerator $this, GroupContainer rootContainer$1, HashSet seenGroups$1, Map groupsByHierarchy$1, RequestStatsPath x0$1) {
        RequestStatsPath requestStatsPath = x0$1;
        if (requestStatsPath != null) {
            String request = requestStatsPath.request();
            Option<Group> group2 = requestStatsPath.group();
            group2.foreach((Function1 & Serializable)group -> {
                $this.addGroupsRec$1(group.hierarchy().reverse(), seenGroups$1, groupsByHierarchy$1, rootContainer$1);
                return BoxedUnit.UNIT;
            });
            RequestStatistics stats = $this.computeRequestStats$1(request, (Option)new Some((Object)request), group2);
            rootContainer$1.addRequest(group2, request, stats);
            return;
        }
        throw new MatchError((Object)requestStatsPath);
    }

    public StatsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, Charset charset, ReportsConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.charset = charset;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

