/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.Container$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.config.IndicatorsConfiguration;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=3Q!\u0003\u0006\u0003\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006O\u0001!\t\u0001\u000b\u0005\bW\u0001\u0011\r\u0011\"\u0011-\u0011\u0019A\u0004\u0001)A\u0005[!9\u0011\b\u0001b\u0001\n\u0003Q\u0004B\u0002\"\u0001A\u0003%1\bC\u0004D\u0001\t\u0007I\u0011\u0001#\t\r9\u0003\u0001\u0015!\u0003F\u0005e9En\u001c2bYN#\u0018\r^:UC\ndWmQ8na>tWM\u001c;\u000b\u0005-a\u0011!C2p[B|g.\u001a8u\u0015\tia\"\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003\u001fA\tqaZ1uY&twMC\u0001\u0012\u0003\tIwnE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001c\u001b\u0005Q\u0011B\u0001\u000f\u000b\u0005%\u0019u.\u001c9p]\u0016tG/A\u0007d_:4\u0017nZ;sCRLwN\\\u0002\u0001!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0004d_:4\u0017n\u001a\u0006\u0003I9\tAaY8sK&\u0011a%\t\u0002\u0018\u0013:$\u0017nY1u_J\u001c8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDCA\u0015+!\tQ\u0002\u0001C\u0003\u001e\u0005\u0001\u0007q$\u0001\u0003ii6dW#A\u0017\u0011\u00059*dBA\u00184!\t\u0001T#D\u00012\u0015\t\u0011d$\u0001\u0004=e>|GOP\u0005\u0003iU\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'F\u0001\u0006QRlG\u000eI\u0001\u0003UN,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\u001c>\u0003\rQ7\u000fI\u0001\bUN4\u0015\u000e\\3t+\u0005)\u0005c\u0001$L[9\u0011q)\u0013\b\u0003a!K\u0011AF\u0005\u0003\u0015V\tq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n\u00191+Z9\u000b\u0005)+\u0012\u0001\u00036t\r&dWm\u001d\u0011")
public final class GlobalStatsTableComponent
implements Component {
    private final String html;
    private final String js;
    private final Seq<String> jsFiles;

    @Override
    public String html() {
        return this.html;
    }

    @Override
    public String js() {
        return this.js;
    }

    @Override
    public Seq<String> jsFiles() {
        return this.jsFiles;
    }

    private static final String pctTitle$1(double pct) {
        return NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(pct)) + " pct";
    }

    public GlobalStatsTableComponent(IndicatorsConfiguration configuration) {
        List responseTimeFields = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Min", GlobalStatsTableComponent.pctTitle$1(configuration.percentile1()), GlobalStatsTableComponent.pctTitle$1(configuration.percentile2()), GlobalStatsTableComponent.pctTitle$1(configuration.percentile3()), GlobalStatsTableComponent.pctTitle$1(configuration.percentile4()), "Max", "Mean", "<abbr title=\"Standard Deviation\">Std Dev</abbr>"}));
        this.html = "\n                      <div id=\"statistics_table_container\">\n                        <div id=\"stats\" class=\"statistics extensible-geant collapsed\">\n                            <div class=\"title\">\n                              <div id=\"statistics_title\" class=\"title_base\"><span class=\"title_base_stats\">Stats</span><span class=\"expand-table\">Fixed height</span><span id=\"toggle-stats\" class=\"toggle-table\"></span><span class=\"collapse-table\">Full size</span></div>\n                              <div class=\"right\">\n                                  <button id=\"statistics_full_screen\" class=\"statistics-button\" onclick=\"openStatisticsTableModal()\">Full Screen</button>\n                                  <button class=\"statistics-button expand-all-button\">Expand all groups</button>\n                                  <button class=\"statistics-button collapse-all-button\">Collapse all groups</button>\n                              </div>\n                            </div>\n                            <div class=\"scrollable\">\n                              <table id=\"container_statistics_head\" class=\"statistics-in extensible-geant\">\n                                  <thead>\n                                      <tr>\n                                          <th rowspan=\"2\" id=\"col-1\" class=\"header sortable sorted-up\"><span>Requests</span></th>\n                                          <th colspan=\"5\" class=\"header\"><span class=\"executions\">Executions</span></th>\n                                          <th colspan=\"" + responseTimeFields.size() + "\" class=\"header\"><span class=\"response-time\">Response Time (ms)</span></th>\n                                      </tr>\n                                      <tr>\n                                          <th id=\"col-2\" class=\"header sortable\"><span>Total</span></th>\n                                          <th id=\"col-3\" class=\"header sortable\"><span>OK</span></th>\n                                          <th id=\"col-4\" class=\"header sortable\"><span>KO</span></th>\n                                          <th id=\"col-5\" class=\"header sortable\"><span>% KO</span></th>\n                                          <th id=\"col-6\" class=\"header sortable\"><span><abbr title=\"Count of events per second\">Cnt/s</abbr></span></th>\n                                          " + ((List)responseTimeFields.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String header = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return "<th id=\"col-" + (i + 7) + "\" class=\"header sortable\"><span>" + header + "</span></th>";
            }
            throw new MatchError((Object)tuple2);
        }).mkString(StringHelper$.MODULE$.Eol()) + "\n                                      </tr>\n                                  </thead>\n                                  <tbody></tbody>\n                              </table>\n                              <table id=\"container_statistics_body\" class=\"statistics-in extensible-geant\">\n                                  <tbody></tbody>\n                              </table>\n                            </div>\n                        </div>\n                      </div>\n<dialog id=\"statistics_table_modal\" class=\"statistics-table-modal\">\n  <div class=\"statistics-table-modal-header\"><button class=\"button-modal\" onclick=\"closeStatisticsTableModal()\">x</button></div>\n  <div class=\"statistics-table-modal-container\">\n    <div id=\"statistics_table_modal_content\" class=\"statistics-table-modal-content\"></div>\n  </div>\n</dialog>\n<script>\nfunction openStatisticsTableModal () {\n  const statsTable = document.getElementById(\"stats\");\n  const statsTableModal = document.getElementById(\"statistics_table_modal\");\n  const fullScreenButton = document.getElementById(\"statistics_full_screen\");\n\n  fullScreenButton.disabled = true;\n\n  if (typeof statsTableModal.showModal === \"function\") {\n    const statsTableModalContent = document.getElementById(\"statistics_table_modal_content\");\n\n    statsTableModalContent.innerHTML = \"\";\n    statsTableModalContent.appendChild(statsTable);\n    statsTableModal.showModal();\n\n    statsTableModal.addEventListener(\"close\", function () {\n      const container = document.getElementById(\"statistics_table_container\");\n\n      container.appendChild(statsTable);\n      fullScreenButton.disabled = false;\n    });\n  } else {\n    const incompatibleBrowserVersionMessage = document.createElement(\"div\");\n\n    incompatibleBrowserVersionMessage.innerText = \"Sorry, the <dialog> API is not supported by this browser.\";\n    statsTable.insertBefore(incompatibleBrowserVersionMessage, statsTable.children[0]);\n  }\n}\n\nfunction closeStatisticsTableModal () {\n  const statsTableModal = document.getElementById(\"statistics_table_modal\");\n\n  statsTableModal.close();\n}\n</script>\n";
        this.js = "\n\nfunction generateHtmlRow(request, level, index, parent, group) {\n    if (request.name == '" + ChartsFiles$.MODULE$.AllRequestLineTitle() + "')\n        var url = 'index.html';\n    else\n        var url = request.pathFormatted + '.html';\n\n    if (group)\n        var expandButtonStyle = '';\n    else\n        var expandButtonStyle = ' hidden';\n\n    if (request.stats.numberOfRequests.total != 0)\n        var koPercent = (request.stats.numberOfRequests.ko * 100 / request.stats.numberOfRequests.total).toFixed(0) + '%';\n    else\n        var koPercent = '-'\n\n    return '<tr id=\"' + request.pathFormatted + '\" data-parent=' + parent + '> \\\n        <td class=\"total col-1\"> \\\n          <div class=\"expandable-container\"> \\\n            <span id=\"' + request.pathFormatted + '\" style=\"margin-left: ' + (level * 10) + 'px;\" class=\"expand-button' + expandButtonStyle + '\">&nbsp;</span> \\\n            <a href=\"' + url +'\" class=\"withTooltip\">' + ellipsedLabel({ name: request.name, parentClass: \"table-cell-tooltip\" }) + '</a><span class=\"value\" style=\"display:none;\">' + index + '</span> \\\n          </div> \\\n        </td> \\\n        <td class=\"value total col-2\">' + request.stats.numberOfRequests.total + '</td> \\\n        <td class=\"value ok col-3\">' + request.stats.numberOfRequests.ok + '</td> \\\n        <td class=\"value ko col-4\">' + request.stats.numberOfRequests.ko + '</td> \\\n        <td class=\"value ko col-5\">' + koPercent + '</td> \\\n        <td class=\"value total col-6\">' + request.stats.meanNumberOfRequestsPerSecond.total + '</td> \\\n        <td class=\"value total col-7\">' + request.stats.minResponseTime.total + '</td> \\\n        <td class=\"value total col-8\">' + request.stats.percentiles1.total + '</td> \\\n        <td class=\"value total col-9\">' + request.stats.percentiles2.total + '</td> \\\n        <td class=\"value total col-10\">' + request.stats.percentiles3.total + '</td> \\\n        <td class=\"value total col-11\">' + request.stats.percentiles4.total + '</td> \\\n        <td class=\"value total col-12\">' + request.stats.maxResponseTime.total + '</td> \\\n        <td class=\"value total col-13\">' + request.stats.meanResponseTime.total + '</td> \\\n        <td class=\"value total col-14\">' + request.stats.standardDeviation.total + '</td> \\\n        </tr>';\n}\n\nfunction generateHtmlRowsForGroup(group, level, index, parent) {\n    var buffer = '';\n\n    if (!parent)\n        parent = 'ROOT';\n    else {\n        buffer += generateHtmlRow(group, level - 1, index, parent, true);\n        index++;\n        parent = group.pathFormatted;\n    }\n\n    $.each(group.contents, function(contentName, content) {\n        if (content.type == '" + Container$.MODULE$.Group() + "') {\n            var result = generateHtmlRowsForGroup(content, level + 1, index, parent);\n            buffer += result.html;\n            index = result.index;\n        }\n        else if (content.type == '" + Container$.MODULE$.Request() + "') {\n            buffer += generateHtmlRow(content, level, index, parent);\n            index++;\n        }\n    });\n\n    return { html: buffer, index: index };\n}\n\n$('#container_statistics_head tbody').append(generateHtmlRow(stats, 0, 0));\n\nvar lines = generateHtmlRowsForGroup(stats, 0, 0);\n$('#container_statistics_body tbody').append(lines.html);\n\n$('#container_statistics_head').sortable('#container_statistics_body');\n$('.statistics').expandable();\n\nif (lines.index < 30) {\n    $('#statistics_title span').attr('style', 'display: none;');\n} else {\n    $('#statistics_title').addClass('title_collapsed');\n    $('#statistics_title').click(function() {\n        $('#toggle-stats').toggleClass(\"off\");\n        $(this).toggleClass('title_collapsed').toggleClass('title_expanded');\n        $('#container_statistics_body').parent().toggleClass('scrollable').toggleClass('');\n    });\n}\n$('.table-cell-tooltip').popover({trigger:'hover'});\n";
        this.jsFiles = Nil$.MODULE$;
    }
}

