/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats.buffers;

import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.core.stats.IntVsTimePlot;
import java.io.Serializable;
import java.util.Map;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable$;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t1\u0011!cU3tg&|g\u000eR3mi\u0006\u0014UO\u001a4fe*\u00111\u0001B\u0001\bEV4g-\u001a:t\u0015\t)a!A\u0003ti\u0006$8O\u0003\u0002\b\u0011\u000511\r[1siNT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_N\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011Q\u0001!\u0011!Q\u0001\nY\tA\"\\5o)&lWm\u001d;b[B\u001c\u0001\u0001\u0005\u0002\u000f/%\u0011\u0001d\u0004\u0002\u0005\u0019>tw\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u0017\u00031i\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0011!a\u0002A!A!\u0002\u0013i\u0012a\u00022vG.,Go\u001d\t\u0004\u001dy\u0001\u0013BA\u0010\u0010\u0005\u0015\t%O]1z!\tq\u0011%\u0003\u0002#\u001f\t\u0019\u0011J\u001c;\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\u00111\u0003&\u000b\u0016\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000bQ\u0019\u0003\u0019\u0001\f\t\u000bi\u0019\u0003\u0019\u0001\f\t\u000bq\u0019\u0003\u0019A\u000f\t\u000f1\u0002!\u0019!C\u0005[\u0005!\"/\u001e8EkJ\fG/[8o\u0013:\u001cVmY8oIN,\u0012\u0001\t\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0011\u0002+I,h\u000eR;sCRLwN\\%o'\u0016\u001cwN\u001c3tA!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014aC:uCJ$8i\\;oiN,\u0012!\b\u0005\u0007i\u0001\u0001\u000b\u0011B\u000f\u0002\u0019M$\u0018M\u001d;D_VtGo\u001d\u0011\t\u000fY\u0002!\u0019!C\u0005e\u0005IQM\u001c3D_VtGo\u001d\u0005\u0007q\u0001\u0001\u000b\u0011B\u000f\u0002\u0015\u0015tGmQ8v]R\u001c\b\u0005C\u0003;\u0001\u0011%1(\u0001\u0004pM\u001a\u001cX\r\u001e\u000b\u0003AqBQ!P\u001dA\u0002Y\t\u0011\u0002^5nKN$\u0018-\u001c9\t\u000b}\u0002A\u0011\u0001!\u0002\u0011\u0005$Gm\u0015;beR$\"!\u0011#\u0011\u00059\u0011\u0015BA\"\u0010\u0005\u0011)f.\u001b;\t\u000bur\u0004\u0019\u0001\f\t\u000b\u0019\u0003A\u0011A$\u0002\r\u0005$G-\u00128e)\t\t\u0005\nC\u0003>\u000b\u0002\u0007a\u0003C\u0004K\u0001\t\u0007I\u0011B\u0017\u0002'\t,8m[3u/&$G\u000f[%o\u001b&dG.[:\t\r1\u0003\u0001\u0015!\u0003!\u0003Q\u0011WoY6fi^KG\r\u001e5J]6KG\u000e\\5tA!)a\n\u0001C\u0005\u001f\u0006q1/Z2p]\u0012$vNQ;dW\u0016$HC\u0001\u0011Q\u0011\u0015\tV\n1\u0001!\u0003\u0019\u0019XmY8oI\")1\u000b\u0001C\u0001)\u0006aA-[:ue&\u0014W\u000f^5p]V\tQ\u000bE\u0002W=\u0006t!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i+\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tiv\"A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'\u0001\u0002'jgRT!!X\b\u0011\u0005\t4W\"A2\u000b\u0005\u0015!'BA3\t\u0003\u0011\u0019wN]3\n\u0005\u001d\u001c'!D%oiZ\u001bH+[7f!2|G\u000f")
public class SessionDeltaBuffer {
    private final long minTimestamp;
    private final int[] buckets;
    private final int runDurationInSeconds;
    private final int[] startCounts;
    private final int[] endCounts;
    private final int bucketWidthInMillis;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    private int runDurationInSeconds() {
        return this.runDurationInSeconds;
    }

    private int[] startCounts() {
        return this.startCounts;
    }

    private int[] endCounts() {
        return this.endCounts;
    }

    private int offset(long timestamp) {
        return (int)((timestamp - this.minTimestamp) / 1000L);
    }

    public void addStart(long timestamp) {
        int n = this.offset(timestamp);
        this.startCounts()[n] = this.startCounts()[n] + 1;
    }

    public void addEnd(long timestamp) {
        int n = this.offset(timestamp);
        this.endCounts()[n] = this.endCounts()[n] + 1;
    }

    private int bucketWidthInMillis() {
        return this.bucketWidthInMillis;
    }

    private int secondToBucket(int second) {
        return package$.MODULE$.min(second * 1000 / this.bucketWidthInMillis(), this.buckets.length - 1);
    }

    public List<IntVsTimePlot> distribution() {
        int[] eachSecondActiveSessions = (int[])Array$.MODULE$.fill(this.runDurationInSeconds(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runDurationInSeconds()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)second -> {
            int bucketSessions;
            int previousSessions;
            int n = second == 0 ? 0 : (previousSessions = eachSecondActiveSessions[second - 1]);
            int previousEnds = second == 0 ? 0 : this.endCounts()[second - 1];
            eachSecondActiveSessions$1[second] = bucketSessions = previousSessions - previousEnds + this.startCounts()[second];
        });
        return (List)((TraversableOnce)Maps.PimpedPairTraversableOnce$.MODULE$.groupByKey$extension(Maps$.MODULE$.PimpedPairTraversableOnce((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(eachSecondActiveSessions).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).iterator().map((Function1)(JFunction1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int sessions = tuple2._1$mcI$sp();
            int second = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)second)), (Object)BoxesRunTime.boxToInteger((int)sessions));
            return tuple22;
        })), (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)second -> this.secondToBucket(second)).map((Function1)(JFunction1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int bucket = tuple2._1$mcI$sp();
            ArrayBuffer sessionCounts = (ArrayBuffer)tuple2._2();
            int averageSessionCount = BoxesRunTime.unboxToInt((Object)sessionCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / sessionCounts.size();
            int time = this.buckets[bucket];
            IntVsTimePlot intVsTimePlot = new IntVsTimePlot(time, averageSessionCount);
            return intVsTimePlot;
        }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.time()), (Ordering)Ordering.Int$.MODULE$);
    }

    public SessionDeltaBuffer(long minTimestamp, long maxTimestamp, int[] buckets) {
        this.minTimestamp = minTimestamp;
        this.buckets = buckets;
        this.runDurationInSeconds = (int)package$.MODULE$.ceil((double)(maxTimestamp - minTimestamp) / 1000.0);
        this.startCounts = (int[])Array$.MODULE$.fill(this.runDurationInSeconds(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        this.endCounts = (int[])Array$.MODULE$.fill(this.runDurationInSeconds(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        this.bucketWidthInMillis = (int)((maxTimestamp - minTimestamp) / (long)buckets.length);
    }
}

