/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.Analytics$;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.app.SimulationClass;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.inject.ScenarioFlows;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001duAB\b\u0011\u0011\u0003\u0011bC\u0002\u0004\u0019!!\u0005!#\u0007\u0005\u0006A\u0005!\tA\t\u0005\u0006G\u0005!\t\u0001\n\u0004\u00061A\u0001!C\n\u0005\tc\u0011\u0011\t\u0011)A\u0005e!A!\b\u0002B\u0001B\u0003%1\b\u0003\u0005D\t\t\u0005\t\u0015!\u0003E\u0011!aEA!A!\u0002\u0013i\u0005\"\u0002\u0011\u0005\t\u0003)\u0006B\u0002.\u0005\t\u000b\u00012\fC\u0003h\t\u0011E\u0001\u000eC\u0004\u0000\t\u0011E!#!\u0001\t\u0011\u0005\u001dC\u0001\"\u0005\u0013\u0003\u0013Bq!a\u001e\u0005\t#\tI(\u0001\u0004Sk:tWM\u001d\u0006\u0003#I\t1!\u00199q\u0015\t\u0019B#A\u0004hCRd\u0017N\\4\u000b\u0003U\t!![8\u0011\u0005]\tQ\"\u0001\t\u0003\rI+hN\\3s'\t\t!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\ta#A\u0003baBd\u0017\u0010F\u0004&\u0003\u0003\u000b\u0019)!\"\u0011\u0005]!1c\u0001\u0003\u001bOA\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003Y5\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002]\u0005\u00191m\\7\n\u0005AJ#!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0004tsN$X-\u001c\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nQ!Y2u_JT\u0011aN\u0001\u0005C.\\\u0017-\u0003\u0002:i\tY\u0011i\u0019;peNK8\u000f^3n\u00039)g/\u001a8u\u0019>|\u0007o\u0012:pkB\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000f\rD\u0017M\u001c8fY*\u0011\u0001\tF\u0001\u0006]\u0016$H/_\u0005\u0003\u0005v\u0012a\"\u0012<f]Rdun\u001c9He>,\b/A\u0003dY>\u001c7\u000e\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\tI%#A\u0004d_6lwN\\:\n\u0005-3%!B\"m_\u000e\\\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002O'6\tqJ\u0003\u0002Q#\u000611m\u001c8gS\u001eT!A\u0015\n\u0002\t\r|'/Z\u0005\u0003)>\u0013AcR1uY&twmQ8oM&<WO]1uS>tG#B\u0013W/bK\u0006\"B\u0019\n\u0001\u0004\u0011\u0004\"\u0002\u001e\n\u0001\u0004Y\u0004\"B\"\n\u0001\u0004!\u0005\"\u0002'\n\u0001\u0004i\u0015a\u0001:v]R\u0011Al\u0018\t\u0003/uK!A\u0018\t\u0003\u0013I+hNU3tk2$\b\"\u00021\u000b\u0001\u0004\t\u0017!\u00064pe\u000e,GmU5nk2\fG/[8o\u00072\f7o\u001d\t\u00047\t$\u0017BA2\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011q#Z\u0005\u0003MB\u0011qbU5nk2\fG/[8o\u00072\f7o]\u0001\u000f]\u0016<8\u000b^1ug\u0016sw-\u001b8f)\rIwn\u001e\t\u0003U6l\u0011a\u001b\u0006\u0003YF\u000bQa\u001d;biNL!A\\6\u0003\u0017M#\u0018\r^:F]\u001eLg.\u001a\u0005\u0006a.\u0001\r!]\u0001\u0011g&lW\u000f\\1uS>t\u0007+\u0019:b[N\u0004\"A];\u000e\u0003MT!\u0001^)\u0002\u0011M\u001cWM\\1sS>L!A^:\u0003!MKW.\u001e7bi&|g\u000eU1sC6\u001c\b\"\u0002=\f\u0001\u0004I\u0018A\u0003:v]6+7o]1hKB\u0011!0`\u0007\u0002w*\u0011Ap[\u0001\u0007oJLG/\u001a:\n\u0005y\\(A\u0003*v]6+7o]1hK\u0006!An\\1e)\u0011\t\u0019!!\u0010\u0011\u0013m\t)!]=\u0002\n\u0005E\u0011bAA\u00049\t1A+\u001e9mKR\u0002B!a\u0003\u0002\u000e5\t\u0011+C\u0002\u0002\u0010E\u0013abQ8sK\u000e{W\u000e]8oK:$8\u000f\u0005\u0005\u0002\u0014\u0005u\u0011\u0011EA\u001c\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AB5oU\u0016\u001cGOC\u0002\u0002\u001cE\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\ty\"!\u0006\u0003\u001bM\u001bWM\\1sS>4En\\<t!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003OaRBAA\u0015\u0015\r\tY#I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=B$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_a\u0002c\u0001:\u0002:%\u0019\u00111H:\u0003\u0011M\u001bWM\\1sS>Dq!a\u0010\r\u0001\u0004\t\t%A\u0005tK2,7\r^5p]B\u0019q#a\u0011\n\u0007\u0005\u0015\u0003CA\u0005TK2,7\r^5p]\u0006)1\u000f^1siRA\u00111JA7\u0003_\n\u0019\b\r\u0003\u0002N\u0005m\u0003CBA(\u0003'\n9&\u0004\u0002\u0002R)\u0011q\tH\u0005\u0005\u0003+\n\tFA\u0002Uef\u0004B!!\u0017\u0002\\1\u0001AaCA/\u001b\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00132#\u0011\t\t'a\u001a\u0011\u0007m\t\u0019'C\u0002\u0002fq\u0011qAT8uQ&tw\rE\u0002\u001c\u0003SJ1!a\u001b\u001d\u0005\r\te.\u001f\u0005\u0006a6\u0001\r!\u001d\u0005\b\u0003cj\u0001\u0019AA\t\u00035\u00198-\u001a8be&|g\t\\8xg\"9\u0011QO\u0007A\u0002\u0005%\u0011AD2pe\u0016\u001cu.\u001c9p]\u0016tGo]\u0001\u0016I&\u001c\b\u000f\\1z-\u0016\u00148/[8o/\u0006\u0014h.\u001b8h)\t\tY\bE\u0002\u001c\u0003{J1!a \u001d\u0005\u0011)f.\u001b;\t\u000bE\u001a\u0001\u0019\u0001\u001a\t\u000bi\u001a\u0001\u0019A\u001e\t\u000b1\u001b\u0001\u0019A'")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static Runner apply(ActorSystem system, EventLoopGroup eventLoopGroup, GatlingConfiguration configuration) {
        return Runner$.MODULE$.apply(system, eventLoopGroup, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public final RunResult run(Option<SimulationClass> forcedSimulationClass) {
        BoxedUnit boxedUnit;
        Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> tuple4;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.displayVersionWarning();
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(forcedSimulationClass, this.configuration);
        if (this.configuration.data().enableAnalytics()) {
            Analytics$.MODULE$.send(selection.simulationClass(), (Option<String>)this.configuration.data().launcher(), (Option<String>)this.configuration.data().buildToolVersion());
        }
        if ((tuple4 = this.load(selection)) == null) {
            throw new MatchError(tuple4);
        }
        SimulationParams simulationParams = (SimulationParams)tuple4._1();
        RunMessage runMessage = (RunMessage)tuple4._2();
        CoreComponents coreComponents = (CoreComponents)tuple4._3();
        ScenarioFlows scenarioFlows = (ScenarioFlows)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
        SimulationParams simulationParams2 = (SimulationParams)tuple42._1();
        RunMessage runMessage2 = (RunMessage)tuple42._2();
        CoreComponents coreComponents2 = (CoreComponents)tuple42._3();
        ScenarioFlows scenarioFlows2 = (ScenarioFlows)tuple42._4();
        Try<?> try_ = this.start(simulationParams2, (ScenarioFlows<String, Scenario>)scenarioFlows2, coreComponents2);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulationParams2.after().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hook executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new RunResult(runMessage2.runId(), simulationParams2.assertions().nonEmpty());
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    public Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> load(Selection selection) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        SimulationParams simulationParams = selection.simulationClass().params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        simulationParams.before().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hook executed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), GatlingVersion$.MODULE$.ThisVersion().fullVersion());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Option throttler = Throttler$.MODULE$.newThrottler(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, this.eventLoopGroup, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ScenarioFlows scenarioFlows = simulationParams.scenarioFlows(coreComponents);
        return new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
    }

    public Try<?> start(SimulationParams simulationParams, ScenarioFlows<String, Scenario> scenarioFlows, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarioFlows);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public void displayVersionWarning() {
        GatlingVersion$.MODULE$.LatestRelease().foreach((Function1 & Serializable)latest -> {
            Runner.$anonfun$displayVersionWarning$1(latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$displayVersionWarning$1(GatlingVersion latest) {
        String string = latest.fullVersion();
        String string2 = GatlingVersion$.MODULE$.ThisVersion().fullVersion();
        if ((string == null ? string2 != null : !string.equals(string2)) && latest.releaseDate().isAfter(GatlingVersion$.MODULE$.ThisVersion().releaseDate())) {
            scala.Predef$.MODULE$.println((Object)new StringBuilder(38).append("Gatling ").append(latest.fullVersion()).append(" is available! (you're using ").append(GatlingVersion$.MODULE$.ThisVersion().fullVersion()).append(")").toString());
            return;
        }
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

