/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.Analytics$;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.cli.GatlingArgs;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.inject.ScenarioFlows;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=tA\u0002\t\u0012\u0011\u0003\u0019rC\u0002\u0004\u001a#!\u00051C\u0007\u0005\u0006C\u0005!\ta\t\u0005\u0006I\u0005!\t!\n\u0004\u00063E\u00011c\n\u0005\te\u0011\u0011\t\u0011)A\u0005g!A1\b\u0002B\u0001B\u0003%A\b\u0003\u0005E\t\t\u0005\t\u0015!\u0003F\u0011!iEA!A!\u0002\u0013q\u0005\u0002\u0003+\u0005\u0005\u0003\u0005\u000b\u0011B+\t\u000b\u0005\"A\u0011A.\t\r\u0005$AQA\tc\u0011\u00151G\u0001\"\u0005h\u0011\u0019qH\u0001\"\u0005\u0014\u007f\"A\u0011Q\t\u0003\u0005\u0012M\t9\u0005C\u0004\u0002d\u0011!\t\"!\u001a\u0002\rI+hN\\3s\u0015\t\u00112#A\u0002baBT!\u0001F\u000b\u0002\u000f\u001d\fG\u000f\\5oO*\ta#\u0001\u0002j_B\u0011\u0001$A\u0007\u0002#\t1!+\u001e8oKJ\u001c\"!A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013\u0019\n9'!\u001b\u0002l\u00055\u0004C\u0001\r\u0005'\r!1\u0004\u000b\t\u0003SAj\u0011A\u000b\u0006\u0003W1\nAb]2bY\u0006dwnZ4j]\u001eT!!\f\u0018\u0002\u0011QL\b/Z:bM\u0016T\u0011aL\u0001\u0004G>l\u0017BA\u0019+\u00055\u0019FO]5di2{wmZ5oO\u000611/_:uK6\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005a\u001a\u0012\u0001B2pe\u0016L!AO\u001b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u000fKZ,g\u000e\u001e'p_B<%o\\;q!\ti$)D\u0001?\u0015\ty\u0004)A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u0005+\u0012!\u00028fiRL\u0018BA\"?\u00059)e/\u001a8u\u0019>|\u0007o\u0012:pkB\fQa\u00197pG.\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0015N\tqaY8n[>t7/\u0003\u0002M\u000f\n)1\t\\8dW\u0006Yq-\u0019;mS:<\u0017I]4t!\ty%+D\u0001Q\u0015\t\tv'A\u0002dY&L!a\u0015)\u0003\u0017\u001d\u000bG\u000f\\5oO\u0006\u0013xm]\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005YKV\"A,\u000b\u0005a;\u0014AB2p]\u001aLw-\u0003\u0002[/\n!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:$bA\n/^=~\u0003\u0007\"\u0002\u001a\u000b\u0001\u0004\u0019\u0004\"B\u001e\u000b\u0001\u0004a\u0004\"\u0002#\u000b\u0001\u0004)\u0005\"B'\u000b\u0001\u0004q\u0005\"\u0002+\u000b\u0001\u0004)\u0016a\u0001:v]R\t1\r\u0005\u0002\u0019I&\u0011Q-\u0005\u0002\n%Vt'+Z:vYR\faB\\3x'R\fGo]#oO&tW\rF\u0002i]Z\u0004\"!\u001b7\u000e\u0003)T!a[\u001c\u0002\u000bM$\u0018\r^:\n\u00055T'aC*uCR\u001cXI\\4j]\u0016DQa\u001c\u0007A\u0002A\f\u0001c]5nk2\fG/[8o!\u0006\u0014\u0018-\\:\u0011\u0005E$X\"\u0001:\u000b\u0005M<\u0014\u0001C:dK:\f'/[8\n\u0005U\u0014(\u0001E*j[Vd\u0017\r^5p]B\u000b'/Y7t\u0011\u00159H\u00021\u0001y\u0003)\u0011XO\\'fgN\fw-\u001a\t\u0003srl\u0011A\u001f\u0006\u0003w*\faa\u001e:ji\u0016\u0014\u0018BA?{\u0005)\u0011VO\\'fgN\fw-Z\u0001\u0005Y>\fG\r\u0006\u0003\u0002\u0002\u0005m\u0002#\u0003\u000f\u0002\u0004AD\u0018qAA\b\u0013\r\t)!\b\u0002\u0007)V\u0004H.\u001a\u001b\u0011\t\u0005%\u00111B\u0007\u0002o%\u0019\u0011QB\u001c\u0003\u001d\r{'/Z\"p[B|g.\u001a8ugBA\u0011\u0011CA\u000e\u0003?\t)$\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0019IgN[3di*\u0019\u0011\u0011D\u001c\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002\u001e\u0005M!!D*dK:\f'/[8GY><8\u000f\u0005\u0003\u0002\"\u0005=b\u0002BA\u0012\u0003W\u00012!!\n\u001e\u001b\t\t9CC\u0002\u0002*\t\na\u0001\u0010:p_Rt\u0014bAA\u0017;\u00051\u0001K]3eK\u001aLA!!\r\u00024\t11\u000b\u001e:j]\u001eT1!!\f\u001e!\r\t\u0018qG\u0005\u0004\u0003s\u0011(\u0001C*dK:\f'/[8\t\u000f\u0005uR\u00021\u0001\u0002@\u0005I1/\u001a7fGRLwN\u001c\t\u00041\u0005\u0005\u0013bAA\"#\tI1+\u001a7fGRLwN\\\u0001\u0006gR\f'\u000f\u001e\u000b\t\u0003\u0013\nI&a\u0017\u0002`A1\u00111JA(\u0003'j!!!\u0014\u000b\u0005!k\u0012\u0002BA)\u0003\u001b\u00121\u0001\u0016:z!\ra\u0012QK\u0005\u0004\u0003/j\"\u0001B+oSRDQa\u001c\bA\u0002ADq!!\u0018\u000f\u0001\u0004\ty!A\u0007tG\u0016t\u0017M]5p\r2|wo\u001d\u0005\b\u0003Cr\u0001\u0019AA\u0004\u00039\u0019wN]3D_6\u0004xN\\3oiN\fQ\u0003Z5ta2\f\u0017PV3sg&|gnV1s]&tw\r\u0006\u0002\u0002T!)!g\u0001a\u0001g!)1h\u0001a\u0001y!)Qj\u0001a\u0001\u001d\")Ak\u0001a\u0001+\u0002")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingArgs gatlingArgs;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static Runner apply(ActorSystem system, EventLoopGroup eventLoopGroup, GatlingArgs gatlingArgs, GatlingConfiguration configuration) {
        return Runner$.MODULE$.apply(system, eventLoopGroup, gatlingArgs, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public final RunResult run() {
        BoxedUnit boxedUnit;
        Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> tuple4;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.displayVersionWarning();
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(this.gatlingArgs);
        if (this.configuration.data().enableAnalytics()) {
            Analytics$.MODULE$.send(selection.simulationClass(), (Option<String>)this.gatlingArgs.launcher(), (Option<String>)this.gatlingArgs.buildToolVersion());
        }
        if ((tuple4 = this.load(selection)) == null) {
            throw new MatchError(tuple4);
        }
        SimulationParams simulationParams = (SimulationParams)tuple4._1();
        RunMessage runMessage = (RunMessage)tuple4._2();
        CoreComponents coreComponents = (CoreComponents)tuple4._3();
        ScenarioFlows scenarioFlows = (ScenarioFlows)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
        SimulationParams simulationParams2 = (SimulationParams)tuple42._1();
        RunMessage runMessage2 = (RunMessage)tuple42._2();
        CoreComponents coreComponents2 = (CoreComponents)tuple42._3();
        ScenarioFlows scenarioFlows2 = (ScenarioFlows)tuple42._4();
        Try<BoxedUnit> try_ = this.start(simulationParams2, (ScenarioFlows<String, Scenario>)scenarioFlows2, coreComponents2);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulationParams2.after().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hook executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new RunResult(runMessage2.runId(), simulationParams2.assertions().nonEmpty());
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.gatlingArgs.resultsDirectory(), this.configuration);
    }

    public Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> load(Selection selection) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        SimulationParams simulationParams = selection.simulationClass().params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        simulationParams.before().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hook executed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), GatlingVersion$.MODULE$.ThisVersion().fullVersion(), this.configuration.data().zoneId());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Option throttler = Throttler$.MODULE$.actor(simulationParams.throttlings()).map((Function1 & Serializable)actor -> $this.system.actorOf(actor));
        ActorRef injector = this.system.actorOf(Injector$.MODULE$.actor(this.eventLoopGroup, statsEngine, this.clock));
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.actor(statsEngine, injector, throttler, simulationParams));
        Exit exit = new Exit(injector);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ScenarioFlows scenarioFlows = simulationParams.scenarioFlows(coreComponents);
        return new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
    }

    public Try<BoxedUnit> start(SimulationParams simulationParams, ScenarioFlows<String, Scenario> scenarioFlows, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)("Simulation " + simulationParams.name() + " started..."));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Promise runDonePromise = coreComponents.controller().replyPromise(timeout);
        coreComponents.controller().$bang((Object)new Controller.Command$.Start(scenarioFlows, runDonePromise));
        Try runDone = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Await$.MODULE$.result((Awaitable)runDonePromise.future(), (Duration)timeout));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Simulation {} completed in {} seconds", new Object[]{simulationParams.name(), BoxesRunTime.boxToLong((long)((coreComponents.clock().nowMillis() - start) / 1000L))});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return runDone;
    }

    public void displayVersionWarning() {
        GatlingVersion$.MODULE$.LatestRelease().foreach((Function1 & Serializable)latest -> {
            Runner.$anonfun$displayVersionWarning$1(latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$displayVersionWarning$1(GatlingVersion latest) {
        String string = latest.fullVersion();
        String string2 = GatlingVersion$.MODULE$.ThisVersion().fullVersion();
        if ((string == null ? string2 != null : !string.equals(string2)) && latest.releaseDate().isAfter(GatlingVersion$.MODULE$.ThisVersion().releaseDate())) {
            scala.Predef$.MODULE$.println((Object)("Gatling " + latest.fullVersion() + " is available! (you're using " + GatlingVersion$.MODULE$.ThisVersion().fullVersion() + ")"));
            return;
        }
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingArgs gatlingArgs, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.gatlingArgs = gatlingArgs;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

