/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.utils;

import io.fluentlenium.utils.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public final class UrlUtils {
    private static final String PATH_SEPARATOR = "/";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    private UrlUtils() {
    }

    public static String concat(String baseUriSpec, String uriSpec) {
        URI baseUri;
        if (baseUriSpec != null && !((String)baseUriSpec).endsWith(PATH_SEPARATOR)) {
            baseUriSpec = (String)baseUriSpec + PATH_SEPARATOR;
        }
        if ((baseUri = UrlUtils.uriFromSpec((String)baseUriSpec)) != null && uriSpec != null && uriSpec.startsWith(PATH_SEPARATOR)) {
            uriSpec = uriSpec.substring(1);
        }
        URI uri = UrlUtils.uriFromSpec(uriSpec);
        if (baseUri != null) {
            return uri == null ? baseUri.toString() : baseUri.resolve(uri).toString();
        }
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    private static URI uriFromSpec(String uriSpec) {
        return uriSpec == null ? null : URI.create(uriSpec);
    }

    public static String sanitizeBaseUrl(String baseUriSpec, String uriSpec) {
        if (baseUriSpec != null) {
            URI baseUri = URI.create(baseUriSpec);
            try {
                String scheme;
                baseUri = UrlUtils.ensureScheme(baseUri, HTTP);
                URI uri = UrlUtils.uriFromSpec(uriSpec);
                String string = scheme = uri == null || !Objects.equals(baseUri.getAuthority(), uri.getAuthority()) || !Arrays.asList(HTTP, HTTPS).contains(uri.getScheme()) ? baseUri.getScheme() : uri.getScheme();
                if (!scheme.equals(baseUri.getScheme())) {
                    return new URIBuilder(baseUri).setScheme(scheme).build().toString();
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return baseUri.toString();
        }
        return null;
    }

    private static URI ensureScheme(URI uri, String defaultScheme) throws URISyntaxException {
        URI uriWithScheme = uri;
        Object fixedBaseUriSpec = uri.toString();
        if (uri.getScheme() == null) {
            while (!((String)fixedBaseUriSpec).startsWith("//")) {
                fixedBaseUriSpec = PATH_SEPARATOR + (String)fixedBaseUriSpec;
            }
            uriWithScheme = new URIBuilder((String)fixedBaseUriSpec).setScheme(defaultScheme).build();
        }
        return uriWithScheme;
    }

    public static String getAbsoluteUrlFromFile(String file) {
        Preconditions.checkArgument(file, "file must not be null");
        URL url = ClassLoader.getSystemResource(file);
        Preconditions.checkArgument(url, "url from file=" + file + " is null");
        return url.toString();
    }

    public static String getAbsoluteUrlPathFromFile(String file) {
        String url = UrlUtils.getAbsoluteUrlFromFile(file);
        return url.substring(0, url.lastIndexOf(47));
    }
}

