/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.components;

import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.components.AbstractComponentInstantiator;
import io.fluentlenium.core.components.ComponentInstantiator;
import io.fluentlenium.core.components.ComponentsAccessor;
import io.fluentlenium.core.components.ComponentsListener;
import io.fluentlenium.core.components.DefaultComponentInstantiator;
import io.fluentlenium.core.domain.ElementUtils;
import io.fluentlenium.core.proxy.LocatorProxies;
import io.fluentlenium.core.proxy.ProxyElementListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ComponentsManager
extends AbstractComponentInstantiator
implements ComponentInstantiator,
ComponentsAccessor,
ProxyElementListener {
    private final DefaultComponentInstantiator instantiator;
    private final Map<WebElement, Set<Object>> components = new IdentityHashMap<WebElement, Set<Object>>();
    private final List<ComponentsListener> listeners = new ArrayList<ComponentsListener>();

    public ComponentsManager(FluentControl control) {
        this.instantiator = new DefaultComponentInstantiator(control, this);
    }

    public ComponentInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public Set<Object> getComponents(WebElement element) {
        return this.components.get(this.unwrapElement(element));
    }

    @Override
    public boolean isComponentClass(Class<?> componentClass) {
        return this.instantiator.isComponentClass(componentClass);
    }

    @Override
    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        return this.instantiator.isComponentListClass(componentListClass);
    }

    @Override
    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        T component = this.instantiator.newComponent(componentClass, element);
        this.register(element, component);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addComponentsListener(ComponentsListener listener) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeComponentsListener(ComponentsListener listener) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireComponentRegistered(WebElement element, Object component) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            for (ComponentsListener listener : this.listeners) {
                listener.componentRegistered(element, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireComponentReleased(WebElement element, Object component) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            for (ComponentsListener listener : this.listeners) {
                listener.componentReleased(element, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void register(WebElement element, T component) {
        WebElement webElement = this.unwrapElement(element);
        LocatorProxies.addProxyListener(webElement, this);
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            Set elementComponents = this.components.computeIfAbsent(webElement, k -> new HashSet());
            elementComponents.add(component);
            this.fireComponentRegistered(element, component);
        }
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        return this.instantiator.newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, Iterable<WebElement> elementList) {
        L componentList = this.instantiator.asComponentList(listClass, componentClass, elementList);
        int i = 0;
        for (WebElement element : elementList) {
            this.register(element, componentList.get(i));
            ++i;
        }
        return componentList;
    }

    @Override
    public void proxyElementSearch(Object proxy, ElementLocator locator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyElementFound(Object proxy, ElementLocator locator, List<WebElement> elements) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            for (WebElement element : elements) {
                Set<Object> proxyComponents = this.components.remove(proxy);
                if (proxyComponents == null) continue;
                this.components.put(this.unwrapElement(element), proxyComponents);
            }
        }
    }

    private WebElement unwrapElement(WebElement element) {
        WebElement wrappedElement;
        if (element instanceof WrapsElement && (wrappedElement = ElementUtils.getWrappedElement(element)) != element && wrappedElement != null) {
            return this.unwrapElement(wrappedElement);
        }
        return element;
    }

    public void release() {
        for (Map.Entry<WebElement, Set<Object>> elementEntry : this.components.entrySet()) {
            LocatorProxies.removeProxyListener(elementEntry.getKey(), this);
            for (Object component : elementEntry.getValue()) {
                this.fireComponentRegistered(elementEntry.getKey(), component);
            }
        }
        this.components.clear();
    }
}

