/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core;

import io.fluentlenium.configuration.Configuration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;

public class FluentDriverTimeoutConfigurer {
    private final Configuration configuration;
    private final WebDriver driver;

    public FluentDriverTimeoutConfigurer(Configuration configuration, WebDriver driver) {
        this.configuration = Objects.requireNonNull(configuration);
        this.driver = driver;
    }

    public void configureDriver() {
        if (this.driver != null && this.driver.manage() != null && this.driver.manage().timeouts() != null) {
            this.configurePageLoadTimeout();
            this.configureImplicitlyWait();
            this.configureScriptTimeout();
        }
    }

    private void configurePageLoadTimeout() {
        if (this.configuration.getPageLoadTimeout() != null) {
            this.driver.manage().timeouts().pageLoadTimeout(this.configuration.getPageLoadTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
    }

    private void configureImplicitlyWait() {
        if (this.configuration.getImplicitlyWait() != null) {
            this.driver.manage().timeouts().implicitlyWait(this.configuration.getImplicitlyWait().longValue(), TimeUnit.MILLISECONDS);
        }
    }

    private void configureScriptTimeout() {
        if (this.configuration.getScriptTimeout() != null) {
            this.driver.manage().timeouts().setScriptTimeout(this.configuration.getScriptTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
    }
}

