/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.adapter.sharedwebdriver;

import io.fluentlenium.adapter.sharedwebdriver.FluentLeniumDriver;
import io.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ThreadDriver
implements FluentLeniumDriver {
    private final Map<ClassAndTestNameWithThreadId, SharedWebDriver> threadDrivers = new HashMap<ClassAndTestNameWithThreadId, SharedWebDriver>();

    Map<ClassAndTestNameWithThreadId, SharedWebDriver> getThreadDrivers() {
        return this.threadDrivers;
    }

    @Override
    public void quitDriver(SharedWebDriver driver) {
        List<Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>> threadDriversToClose = this.getThreadDriversToClose(driver);
        threadDriversToClose.forEach(item -> this.closeThreadDriver(driver, (Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>)item));
    }

    @Override
    public void addDriver(SharedWebDriver driver) {
        this.threadDrivers.put(new ClassAndTestNameWithThreadId(driver.getTestClass(), driver.getTestName(), Thread.currentThread().getId()), driver);
    }

    public <T> SharedWebDriver getDriver(Class<T> testClass, String testName, long id) {
        return this.threadDrivers.get(new ClassAndTestNameWithThreadId(testClass, testName, id));
    }

    private void closeThreadDriver(SharedWebDriver sharedWebDriver, Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver> item) {
        SharedWebDriver testThreadDriver = this.threadDrivers.remove(item.getKey());
        this.quitDriver(sharedWebDriver, testThreadDriver);
    }

    private List<Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>> getThreadDriversToClose(SharedWebDriver driver) {
        return this.threadDrivers.entrySet().stream().filter(entry -> ((ClassAndTestNameWithThreadId)entry.getKey()).testClass.equals(driver.getTestClass()) && ((ClassAndTestNameWithThreadId)entry.getKey()).testName.equals(driver.getTestName()) && ((SharedWebDriver)entry.getValue()).getDriver().equals((Object)driver.getDriver())).collect(Collectors.toList());
    }

    private class ClassAndTestNameWithThreadId {
        protected final Class<?> testClass;
        protected final String testName;
        private final Long threadId;

        ClassAndTestNameWithThreadId(Class<?> testClass, String testName, Long threadId) {
            this.testClass = testClass;
            this.testName = testName;
            this.threadId = threadId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassAndTestNameWithThreadId)) {
                return false;
            }
            ClassAndTestNameWithThreadId other = (ClassAndTestNameWithThreadId)obj;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Objects.equals(this.testClass, other.testClass)) {
                return false;
            }
            if (!Objects.equals(this.testName, other.testName)) {
                return false;
            }
            return Objects.equals(this.threadId, other.threadId);
        }

        boolean canEqual(Object other) {
            return other instanceof ClassAndTestNameWithThreadId;
        }

        public int hashCode() {
            int prime = 59;
            int result = 1;
            Class<?> testClazz = this.testClass;
            result = result * 59 + (testClazz == null ? 43 : testClazz.hashCode());
            String nameOfTest = this.testName;
            result = result * 59 + (nameOfTest == null ? 43 : nameOfTest.hashCode());
            Long idOfThread = this.threadId;
            result = result * 59 + (idOfThread == null ? 43 : ((Object)idOfThread).hashCode());
            return result;
        }
    }
}

