/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Maps;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.BeanUtils;
import org.boon.validation.ValidationContext;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.validators.BaseValidator;

public class DomainValidator
extends BaseValidator {
    private static final long serialVersionUID = 1L;
    private Object rootObject;
    private static Set<String> allowedPackages = new HashSet<String>();

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    @Override
    public ValidatorMessageHolder validate(Object fieldValue, String fieldLabel) {
        Map<String, AnnotationData> map;
        String detailMessage = "";
        String summaryMessage = "";
        this.noMessages = true;
        boolean error = false;
        Object child = this.rootObject == null ? ValidationContext.getCurrentInstance().getParentObject() : this.rootObject;
        List<AnnotationData> annotationDataForProperty = Annotations.getAnnotationDataForProperty(child.getClass(), fieldLabel, false, allowedPackages);
        if (annotationDataForProperty.size() == 0) {
            annotationDataForProperty = Annotations.getAnnotationDataForField(child.getClass(), fieldLabel, allowedPackages);
        }
        boolean found = (map = Maps.toMap("name", annotationDataForProperty)).get("domainValidation") != null;
        boolean sameLevel = false;
        boolean noArgs = false;
        if (found) {
            AnnotationData ad = map.get("domainValidation");
            Object parentReference = ad.getValues().get("parentProperty");
            Object validator = null;
            if (parentReference != null && !"".equals(parentReference)) {
                BeanUtils.getPropertyValue(child, (String)parentReference);
            } else {
                validator = child;
                sameLevel = true;
            }
            noArgs = (Boolean)ad.getValues().get("global");
            Method m = null;
            if (validator != null) {
                try {
                    String methodName = (String)ad.getValues().get("method");
                    if (noArgs) {
                        m = validator.getClass().getDeclaredMethod(methodName, new Class[0]);
                    } else if (sameLevel) {
                        Class[] parameters = new Class[]{BeanUtils.getPropertyType(child, fieldLabel)};
                        m = validator.getClass().getDeclaredMethod(methodName, parameters);
                    } else {
                        Class[] parameters = new Class[]{child.getClass(), BeanUtils.getPropertyType(child, fieldLabel)};
                        m = validator.getClass().getDeclaredMethod(methodName, parameters);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    detailMessage = nsme.getMessage();
                    summaryMessage = nsme.getMessage();
                    error = true;
                }
                catch (Exception e) {
                    detailMessage = e.getMessage();
                    summaryMessage = e.getMessage();
                    error = true;
                }
            }
            try {
                if (noArgs) {
                    m.invoke(validator, new Object[0]);
                } else if (sameLevel) {
                    m.invoke(validator, fieldValue);
                } else {
                    m.invoke(validator, child, fieldValue);
                }
            }
            catch (IllegalAccessException iae) {
                detailMessage = iae.getCause().getMessage();
                summaryMessage = iae.getCause().getMessage();
                error = true;
            }
            catch (InvocationTargetException ite) {
                detailMessage = ite.getCause().getMessage();
                summaryMessage = ite.getCause().getMessage();
                error = true;
            }
            catch (Exception e) {
                detailMessage = e.getCause().getMessage();
                summaryMessage = e.getCause().getMessage();
                error = true;
            }
        }
        ValidatorMessage message = new ValidatorMessage();
        if (error) {
            message = new ValidatorMessage(summaryMessage, detailMessage);
            this.populateMessage(message, noArgs ? null : fieldLabel, new Object[0]);
        }
        return message;
    }

    static {
        allowedPackages.add("org.boon.annotation.validation");
    }
}

