/*
 * Decompiled with CFR 0.152.
 */
package org.boon.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.boon.validation.ValidationContext;

public class MessageSpecification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String detailMessage = "detailMessage";
    private String summaryMessage = "summaryMessage";
    private List<String> detailArgs;
    private List<String> summaryArgs;
    private String name;
    private String parent;
    private String subject = "";
    private boolean noSummary;
    private static final String SUMMARY_KEY = ".summary";
    private static final String DETAIL_KEY = ".detail";

    public void init() {
        if (this.name == null && this.parent == null) {
            this.setDetailMessage("{" + this.getClass().getName() + DETAIL_KEY + "}");
            this.setSummaryMessage("{" + this.getClass().getName() + SUMMARY_KEY + "}");
        } else if (this.name != null && this.parent == null) {
            this.setDetailMessage("{message." + this.getName() + DETAIL_KEY + "}");
            this.setSummaryMessage("{message." + this.getName() + SUMMARY_KEY + "}");
        } else if (this.parent != null) {
            this.setDetailMessage("{message." + this.parent + DETAIL_KEY + "}");
            this.setSummaryMessage("{message." + this.parent + SUMMARY_KEY + "}");
        }
    }

    public boolean isNoSummary() {
        return this.noSummary;
    }

    public void setNoSummary(boolean noSummary) {
        this.noSummary = noSummary;
    }

    public String createSummaryMessage(Object ... args) {
        return this.createMessage(this.summaryMessage, this.summaryArgs, args);
    }

    public String createDetailMessage(Object ... args) {
        return this.createMessage(this.detailMessage, this.detailArgs, args);
    }

    public String createMessage(String key, List<String> argKeys, Object ... args) {
        String message = this.getMessage(key);
        Object[] actualArgs = args.length > 0 ? args : (argKeys != null ? this.keysToValues(argKeys) : new Object[]{});
        return this.doCreateMessage(message, actualArgs);
    }

    private String doCreateMessage(String message, Object[] actualArgs) {
        return ValidationContext.get().createMessage(message, this.getSubject(), actualArgs);
    }

    private String getMessage(String key) {
        return ValidationContext.get().getMessage(key);
    }

    private Object[] keysToValues(List<String> argKeys) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : argKeys) {
            values.add(this.getMessage(key));
        }
        return values.toArray();
    }

    public void setCurrentSubject(String subject) {
        ValidationContext.get().setCurrentSubject(subject);
    }

    public String getSubject() {
        return ValidationContext.get().getCurrentSubject() == null ? this.subject : ValidationContext.get().getCurrentSubject();
    }

    protected String getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(String detailKey) {
        this.detailMessage = detailKey;
    }

    protected String getSummaryMessage() {
        return this.summaryMessage;
    }

    public void setSummaryMessage(String summaryKey) {
        this.summaryMessage = summaryKey;
    }

    protected List<String> getDetailArgs() {
        return this.detailArgs;
    }

    public void setDetailArgs(List<String> argKeys) {
        this.detailArgs = argKeys;
    }

    protected List<String> getSummaryArgs() {
        return this.summaryArgs;
    }

    public void setSummaryArgs(List<String> summaryArgKeys) {
        this.summaryArgs = summaryArgKeys;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}

