/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.json.serializers.StringSerializer;
import org.boon.primitive.CharBuf;

public class StringSerializerImpl
implements StringSerializer {
    final boolean encodeStrings;
    final boolean asAscii;
    final boolean includeBlank;

    public StringSerializerImpl(boolean encodeStrings, boolean asAscii, boolean includeBlank) {
        this.encodeStrings = encodeStrings;
        this.asAscii = asAscii;
        this.includeBlank = includeBlank;
    }

    @Override
    public final void serializeString(JsonSerializerInternal serializer, String string, CharBuf builder) {
        if (this.includeBlank || string != null && !string.isEmpty()) {
            if (this.encodeStrings) {
                builder.asJsonString(string, this.asAscii);
            } else {
                builder.addQuoted(string);
            }
        }
    }
}

