/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.boon.Sets;
import org.boon.core.TypeType;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.json.serializers.CustomFieldSerializer;
import org.boon.json.serializers.CustomObjectSerializer;
import org.boon.json.serializers.FieldFilter;
import org.boon.json.serializers.FieldSerializer;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.json.serializers.impl.SerializeUtils;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;

public class FieldSerializerUseAnnotationsImpl
implements FieldSerializer {
    private final boolean includeNulls;
    private final boolean includeDefault;
    private final boolean useAnnotations;
    private final boolean includeEmpty;
    private final boolean handleSimpleBackReference;
    private final boolean handleComplexBackReference;
    private final String view;
    private IdentityHashMap idMap;
    private Map<Class, CustomObjectSerializer> overrideMap;
    private Map<String, CustomFieldSerializer> customFieldSerializerMap;
    private List<CustomFieldSerializer> customFieldSerializers;
    private final Set<Class> noHandle = Sets.safeSet(Class.class);
    private final List<FieldFilter> filterProperties;

    public FieldSerializerUseAnnotationsImpl(boolean includeNulls, boolean includeDefault, boolean useAnnotations, boolean includeEmpty, boolean handleSimpleBackReference, boolean handleComplexBackReference, Map<Class, CustomObjectSerializer> overrideMap, List<FieldFilter> filterProperties, Map<String, CustomFieldSerializer> customFieldSerializerMap, List<CustomFieldSerializer> customFieldSerializers, String view) {
        this.includeNulls = includeNulls;
        this.includeDefault = includeDefault;
        this.useAnnotations = useAnnotations;
        this.includeEmpty = includeEmpty;
        this.handleSimpleBackReference = handleSimpleBackReference;
        this.handleComplexBackReference = handleComplexBackReference;
        this.view = view;
        if (handleComplexBackReference) {
            this.idMap = new IdentityHashMap();
        }
        this.overrideMap = overrideMap;
        this.filterProperties = filterProperties;
        this.customFieldSerializerMap = customFieldSerializerMap;
        this.customFieldSerializers = customFieldSerializers;
    }

    private void serializeFieldName(String name, CharBuf builder) {
        builder.addJsonFieldName(FastStringUtils.toCharArray(name));
    }

    @Override
    public final boolean serializeField(JsonSerializerInternal serializer, Object parent, FieldAccess fieldAccess, CharBuf builder) {
        CustomFieldSerializer customFieldSerializer;
        boolean include;
        String fieldName = fieldAccess.alias();
        TypeType typeEnum = fieldAccess.typeEnum();
        if (this.useAnnotations && fieldAccess.ignore()) {
            return false;
        }
        if (this.useAnnotations && this.view != null && !fieldAccess.isViewActive(this.view)) {
            return false;
        }
        boolean bl = include = this.useAnnotations && fieldAccess.include();
        if (this.filterProperties != null) {
            for (FieldFilter filter : this.filterProperties) {
                if (filter.include(parent, fieldAccess)) continue;
                return false;
            }
        }
        if (this.customFieldSerializerMap != null && (customFieldSerializer = this.customFieldSerializerMap.get(fieldAccess.name())).serializeField(serializer, parent, fieldAccess, builder)) {
            return true;
        }
        if (this.customFieldSerializers != null) {
            for (CustomFieldSerializer cfs : this.customFieldSerializers) {
                if (!cfs.serializeField(serializer, parent, fieldAccess, builder)) continue;
                return true;
            }
        }
        switch (typeEnum) {
            case INT: {
                int value = fieldAccess.getInt(parent);
                if (this.includeDefault || include || value != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addInt(value);
                    return true;
                }
                return false;
            }
            case BOOLEAN: {
                boolean bvalue = fieldAccess.getBoolean(parent);
                if (this.includeDefault || include || bvalue) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addBoolean(bvalue);
                    return true;
                }
                return false;
            }
            case BYTE: {
                byte byvalue = fieldAccess.getByte(parent);
                if (this.includeDefault || include || byvalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addByte(byvalue);
                    return true;
                }
                return false;
            }
            case LONG: {
                long lvalue = fieldAccess.getLong(parent);
                if (this.includeDefault || include || lvalue != 0L) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addLong(lvalue);
                    return true;
                }
                return false;
            }
            case DOUBLE: {
                double dvalue = fieldAccess.getDouble(parent);
                if (this.includeDefault || include || dvalue != 0.0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addDouble(dvalue);
                    return true;
                }
                return false;
            }
            case FLOAT: {
                float fvalue = fieldAccess.getFloat(parent);
                if (this.includeDefault || include || fvalue != 0.0f) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addFloat(fvalue);
                    return true;
                }
                return false;
            }
            case SHORT: {
                short svalue = fieldAccess.getShort(parent);
                if (this.includeDefault || include || svalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addShort(svalue);
                    return true;
                }
                return false;
            }
            case CHAR: {
                char cvalue = fieldAccess.getChar(parent);
                if (this.includeDefault || include || cvalue != '\u0000') {
                    this.serializeFieldName(fieldName, builder);
                    builder.addQuoted("" + cvalue);
                    return true;
                }
                return false;
            }
        }
        Object value = fieldAccess.getObject(parent);
        if (!this.includeNulls && !include && value == null) {
            return false;
        }
        if ((this.includeNulls || fieldAccess.include()) && value == null) {
            this.serializeFieldName(fieldName, builder);
            builder.addNull();
            return true;
        }
        switch (typeEnum) {
            case BIG_DECIMAL: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigDecimal((BigDecimal)value);
                return true;
            }
            case BIG_INT: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigInteger((BigInteger)value);
                return true;
            }
            case DATE: {
                this.serializeFieldName(fieldName, builder);
                serializer.serializeDate((Date)value, builder);
                return true;
            }
            case STRING: {
                String string = (String)value;
                if (this.includeEmpty || include || string.length() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeString(string, builder);
                    return true;
                }
                return false;
            }
            case CLASS: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(((Class)value).getName());
                return true;
            }
            case TIME_ZONE: {
                this.serializeFieldName(fieldName, builder);
                TimeZone zone = (TimeZone)value;
                builder.addQuoted(zone.getID());
                return true;
            }
            case CHAR_SEQUENCE: {
                String s2 = value.toString();
                if (this.includeEmpty || include || s2.length() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeString(s2, builder);
                    return true;
                }
                return false;
            }
            case BOOLEAN_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addBoolean((Boolean)value);
                return true;
            }
            case INTEGER_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addInt((Integer)value);
                return true;
            }
            case LONG_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addLong((Long)value);
                return true;
            }
            case FLOAT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addFloat((Float)value);
                return true;
            }
            case DOUBLE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addDouble((Double)value);
                return true;
            }
            case SHORT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addShort((Short)value);
                return true;
            }
            case BYTE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addByte((Byte)value);
                return true;
            }
            case CHAR_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(value.toString());
                return true;
            }
            case ENUM: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(value.toString());
                return true;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                Collection collection = (Collection)value;
                if (this.includeEmpty || include || collection.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeCollection(collection, builder);
                    return true;
                }
                return false;
            }
            case MAP: {
                Map map = (Map)value;
                if (this.includeEmpty || include || map.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeMap(map, builder);
                    return true;
                }
                return false;
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                if (this.includeEmpty || include || Arry.len(value) > 0) {
                    this.serializeFieldName(fieldName, builder);
                    serializer.serializeArray(value, builder);
                    return true;
                }
                return false;
            }
            case INTERFACE: 
            case ABSTRACT: {
                if (this.handleSimpleBackReference && value == parent) {
                    return false;
                }
                if (this.handleComplexBackReference) {
                    if (this.idMap.containsKey(value)) {
                        return false;
                    }
                    this.idMap.put(value, value);
                }
                this.serializeFieldName(fieldName, builder);
                if (this.overrideMap != null) {
                    SerializeUtils.handleInstance(serializer, value, builder, this.overrideMap, this.noHandle, false, typeEnum);
                } else {
                    serializer.serializeSubtypeInstance(value, builder);
                }
                return true;
            }
            case INSTANCE: {
                if (this.handleSimpleBackReference && value == parent) {
                    return false;
                }
                if (this.handleComplexBackReference) {
                    if (this.idMap.containsKey(value)) {
                        return false;
                    }
                    this.idMap.put(value, value);
                }
                this.serializeFieldName(fieldName, builder);
                if (this.overrideMap != null) {
                    SerializeUtils.handleInstance(serializer, value, builder, this.overrideMap, this.noHandle, false, typeEnum);
                } else if (fieldAccess.type() == value.getClass()) {
                    serializer.serializeInstance(value, builder);
                } else {
                    serializer.serializeSubtypeInstance(value, builder);
                }
                return true;
            }
            case CURRENCY: {
                this.serializeFieldName(fieldName, builder);
                builder.addCurrency((Currency)value);
                return true;
            }
        }
        this.serializeFieldName(fieldName, builder);
        serializer.serializeUnknown(value, builder);
        return true;
    }
}

