/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.Sets;
import org.boon.collections.MultiMapImpl;
import org.boon.core.Supplier;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.di.ProviderInfo;
import org.boon.di.modules.BaseModule;
import org.boon.di.modules.NamedUtils;

public class SupplierModule
extends BaseModule {
    private Map<Class, ProviderInfo> supplierTypeMap = new ConcurrentHashMap<Class, ProviderInfo>();
    private MultiMapImpl<String, ProviderInfo> supplierNameMap = new MultiMapImpl();

    public SupplierModule(ProviderInfo ... suppliers) {
        this.supplierExtraction(suppliers);
    }

    public SupplierModule(List<ProviderInfo> suppliers) {
        this.supplierExtraction(suppliers.toArray(new ProviderInfo[suppliers.size()]));
    }

    @Override
    public Iterable<Object> values() {
        return this.supplierNameMap.values();
    }

    @Override
    public Iterable<String> names() {
        return this.supplierNameMap.keySet();
    }

    public Iterable types() {
        return this.supplierTypeMap.keySet();
    }

    public SupplierModule(Map<?, ?> map) {
        ArrayList list = new ArrayList();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                ProviderInfo pi = this.addProviderFromMapToList(key, valueMap);
                list.add(pi);
                continue;
            }
            list.add(ProviderInfo.provider(key, value));
        }
        this.supplierExtraction(list.toArray(new ProviderInfo[list.size()]));
    }

    private ProviderInfo addProviderFromMapToList(Object key, final Map<String, Object> valueMap) {
        String className;
        if (valueMap.containsKey("class") && (className = (String)valueMap.get("class")) != null) {
            try {
                Class<?> type = Class.forName(className.toString());
                Supplier<Object> supplier = new Supplier<Object>(){

                    @Override
                    public Object get() {
                        return MapObjectConversion.fromMap(valueMap);
                    }
                };
                return ProviderInfo.providerOf(key.toString(), type, supplier);
            }
            catch (ClassNotFoundException e) {
                return ProviderInfo.provider(key, valueMap);
            }
        }
        return ProviderInfo.provider(key, valueMap);
    }

    @Override
    public <T> T get(Class<T> type) {
        ProviderInfo pi = this.supplierTypeMap.get(type);
        if (pi != null) {
            return pi.supplier().get();
        }
        return null;
    }

    @Override
    public Object get(String name) {
        ProviderInfo pi = this.supplierNameMap.get(name);
        if (pi != null) {
            return pi.supplier().get();
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        ProviderInfo providerInfo = this.getProviderInfo(type, name);
        if (providerInfo != null) {
            return providerInfo.supplier().get();
        }
        return null;
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type) {
        return this.supplierTypeMap.get(type);
    }

    @Override
    public ProviderInfo getProviderInfo(String name) {
        return this.supplierNameMap.get(name);
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type, String name) {
        return this.doGetProvider(type, name);
    }

    @Override
    public <T> Supplier<T> getSupplier(Class<T> type, String name) {
        ProviderInfo nullInfo = null;
        try {
            Set<ProviderInfo> set = Sets.set(this.supplierNameMap.getAll(name));
            for (ProviderInfo info : set) {
                if (info.type() == null) {
                    nullInfo = info;
                    continue;
                }
                if (!type.isAssignableFrom(info.type())) continue;
                return info.supplier();
            }
            return nullInfo != null ? nullInfo.supplier() : new Supplier<T>(){

                @Override
                public T get() {
                    return null;
                }
            };
        }
        catch (Exception e) {
            Exceptions.handle(e);
            return null;
        }
    }

    private ProviderInfo doGetProvider(Class<?> type, String name) {
        Set<ProviderInfo> set = Sets.set(this.supplierNameMap.getAll(name));
        ProviderInfo nullTypeInfo = null;
        for (ProviderInfo info : set) {
            if (info.type() == null) {
                nullTypeInfo = info;
                continue;
            }
            if (!type.isAssignableFrom(info.type())) continue;
            return info;
        }
        return nullTypeInfo;
    }

    @Override
    public <T> Supplier<T> getSupplier(Class<T> type) {
        Supplier supplier = (Supplier)((Object)this.supplierTypeMap.get(type));
        if (supplier == null) {
            supplier = new Supplier<T>(){

                @Override
                public T get() {
                    return null;
                }
            };
        }
        return supplier;
    }

    @Override
    public boolean has(Class type) {
        return this.supplierTypeMap.containsKey(type);
    }

    @Override
    public boolean has(String name) {
        return this.supplierNameMap.containsKey(name);
    }

    private void extractClassIntoMaps(ProviderInfo info, Class type, boolean foundName, Supplier supplier) {
        Class<?>[] superTypes;
        if (type == null) {
            return;
        }
        String named = null;
        Class superClass = type.getSuperclass();
        for (Class<?> superType : superTypes = type.getInterfaces()) {
            this.supplierTypeMap.put(superType, info);
        }
        while (superClass != Object.class) {
            this.supplierTypeMap.put(superClass, info);
            if (!foundName && (named = NamedUtils.namedValueForClass(superClass)) != null) {
                this.supplierNameMap.put(named, new ProviderInfo<Object>(named, type, supplier, null));
                foundName = true;
            }
            for (Class<?> superType : superTypes = type.getInterfaces()) {
                this.supplierTypeMap.put(superType, info);
            }
            superClass = superClass.getSuperclass();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void supplierExtraction(ProviderInfo[] suppliers) {
        for (ProviderInfo providerInfo : suppliers) {
            void var5_5;
            Class<Object> type = providerInfo.type();
            if (type == null && providerInfo.value() != null) {
                type = providerInfo.value().getClass();
            }
            String named = providerInfo.name();
            Supplier supplier = providerInfo.supplier();
            if (supplier == null) {
                supplier = this.createSupplier(providerInfo.prototype(), type, providerInfo.value());
                ProviderInfo<Object> providerInfo2 = new ProviderInfo<Object>(named, type, supplier, providerInfo.value());
            }
            if (type != null) {
                this.supplierTypeMap.put(type, (ProviderInfo)var5_5);
                if (named == null) {
                    named = NamedUtils.namedValueForClass(type);
                }
            }
            this.extractClassIntoMaps((ProviderInfo)var5_5, type, named != null, supplier);
            if (named == null) continue;
            this.supplierNameMap.put(named, new ProviderInfo<Object>(named, type, supplier, var5_5.value()));
        }
    }

    private Supplier createSupplier(boolean prototype, final Class<?> type, final Object value) {
        if (value != null && !prototype) {
            return new Supplier(){

                public Object get() {
                    return value;
                }
            };
        }
        if (value != null && prototype) {
            return new Supplier(){

                public Object get() {
                    return BeanUtils.copy(value);
                }
            };
        }
        if (type != null) {
            return new Supplier(){

                public Object get() {
                    return Reflection.newInstance(type);
                }
            };
        }
        return new Supplier(){

            public Object get() {
                return null;
            }
        };
    }
}

