/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import org.boon.core.Supplier;

public class ProviderInfo<T> {
    private String name;
    private Class<T> type;
    private Supplier<T> supplier;
    private T object;
    private boolean postConstructCalled;
    boolean prototype;

    public ProviderInfo(Class<T> type) {
        this.type = type;
    }

    public ProviderInfo(String name, Class<T> type, Supplier<T> supplier, T object) {
        this.name = name;
        this.type = type;
        this.supplier = supplier;
        this.object = object;
    }

    public ProviderInfo(String name, Class<T> type, Supplier<T> supplier, T object, boolean prototype) {
        this.name = name;
        this.type = type;
        this.supplier = supplier;
        this.object = object;
        this.prototype = prototype;
    }

    public static <T> ProviderInfo<T> providerOf(Class<T> type, Supplier<T> supplier) {
        return new ProviderInfo<Object>(null, type, supplier, null);
    }

    public static <T> ProviderInfo<T> providerOf(String name, Class<T> type, Supplier<T> supplier) {
        return new ProviderInfo<Object>(name, type, supplier, null);
    }

    public static <T> ProviderInfo<T> providerOf(String name, Supplier<T> supplier) {
        return new ProviderInfo<Object>(name, null, supplier, null);
    }

    public static <T> ProviderInfo<T> providerOf(String name, Class<T> type) {
        return new ProviderInfo<Object>(name, type, null, null);
    }

    public static <T> ProviderInfo<T> providerOf(Class<T> type) {
        return new ProviderInfo<Object>(null, type, null, null);
    }

    public static <T> ProviderInfo<T> providerOf(String name, T object) {
        return new ProviderInfo<T>(name, null, null, object);
    }

    public static <T> ProviderInfo<T> providerOf(T object) {
        return new ProviderInfo<T>(null, null, null, object);
    }

    public static <T> ProviderInfo<T> objectProviderOf(T object) {
        return new ProviderInfo<T>(null, null, null, object);
    }

    public static <T> ProviderInfo<T> prototypeProviderOf(T object) {
        return new ProviderInfo<T>(null, null, null, object, true);
    }

    public static <T> ProviderInfo<T> provider(Object name, Object value) {
        ProviderInfo<Object> info;
        if (value instanceof ProviderInfo) {
            ProviderInfo valueInfo = (ProviderInfo)value;
            info = new ProviderInfo<Object>(name.toString(), valueInfo.type(), valueInfo.supplier(), valueInfo.value());
        } else {
            info = value instanceof Class ? new ProviderInfo<Object>(name.toString(), (Class)value, null, null) : (value instanceof Supplier ? new ProviderInfo<Object>(name.toString(), null, (Supplier)value, null) : (value == null ? new ProviderInfo<Object>(name.toString(), null, null, value) : new ProviderInfo<Object>(name.toString(), value.getClass(), null, value)));
        }
        return info;
    }

    public Class<T> type() {
        return this.type;
    }

    public Supplier<T> supplier() {
        return this.supplier;
    }

    public String name() {
        return this.name;
    }

    public Object value() {
        return this.object;
    }

    public boolean isPostConstructCalled() {
        return this.postConstructCalled;
    }

    public void setPostConstructCalled(boolean postConstructCalled) {
        this.postConstructCalled = postConstructCalled;
    }

    public boolean prototype() {
        return this.prototype;
    }
}

