/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.indexes;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.boon.core.Function;
import org.boon.core.Typ;
import org.boon.datarepo.impl.indexes.LookupIndexDefault;
import org.boon.datarepo.impl.indexes.MultiValue;
import org.boon.datarepo.spi.SPIFactory;
import org.boon.datarepo.spi.SearchIndex;
import org.boon.primitive.CharBuf;

public class SearchIndexDefault<KEY, ITEM>
extends LookupIndexDefault<KEY, ITEM>
implements SearchIndex<KEY, ITEM> {
    private NavigableMap<KEY, MultiValue> navigableMap;
    private Comparator collator;
    private Class<?> keyType;
    boolean init;

    public SearchIndexDefault(Class<?> keyType) {
        super(keyType);
        this.keyType = keyType;
    }

    public SearchIndexDefault(Class<?> keyType, List<ITEM> items, Function<ITEM, KEY> keyGetter) {
        super(null);
        this.keyGetter = keyGetter;
        this.map = SPIFactory.getMapCreatorFactory().get().createNavigableMap(keyType);
        this.navigableMap = (NavigableMap)this.map;
        for (ITEM item : items) {
            this.add(item);
        }
    }

    public SearchIndexDefault(Class<?> keyType, List<ITEM> items, Function<ITEM, KEY> keyGetter, Collator collator) {
        super(null);
        this.keyGetter = keyGetter;
        this.map = SPIFactory.getMapCreatorFactory().get().createNavigableMap(keyType, collator);
        this.navigableMap = (NavigableMap)this.map;
        for (ITEM item : items) {
            this.add(item);
        }
    }

    @Override
    public void setComparator(Comparator collator) {
        this.collator = collator;
    }

    @Override
    public void init() {
        this.map = this.collator != null ? SPIFactory.getMapCreatorFactory().get().createNavigableMap(this.keyType, this.collator) : (this.keyType == Typ.number ? SPIFactory.getMapCreatorFactory().get().createNavigableMap(this.keyType, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                double long2;
                if (o1 instanceof Long) {
                    long long22;
                    long long1 = o1.longValue();
                    if (long1 > (long22 = o2.longValue())) {
                        return 1;
                    }
                    if (long1 < long22) {
                        return -1;
                    }
                    return 0;
                }
                if (o1 instanceof Double) {
                    double long23;
                    double long1 = o1.doubleValue();
                    if (long1 > (long23 = o2.doubleValue())) {
                        return 1;
                    }
                    if (long1 < long23) {
                        return -1;
                    }
                    return 0;
                }
                if (o1 instanceof BigDecimal) {
                    double long24;
                    double long1 = o1.doubleValue();
                    if (long1 > (long24 = o2.doubleValue())) {
                        return 1;
                    }
                    if (long1 < long24) {
                        return -1;
                    }
                    return 0;
                }
                double long1 = o1.doubleValue();
                if (long1 > (long2 = o2.doubleValue())) {
                    return 1;
                }
                if (long1 < long2) {
                    return -1;
                }
                return 0;
            }
        }) : SPIFactory.getMapCreatorFactory().get().createNavigableMap(this.keyType));
        this.navigableMap = (NavigableMap)this.map;
    }

    @Override
    public ITEM findFirst() {
        return (ITEM)this.navigableMap.firstEntry().getValue().getValue();
    }

    @Override
    public ITEM findLast() {
        return (ITEM)this.navigableMap.lastEntry().getValue().getValue();
    }

    @Override
    public KEY findFirstKey() {
        return this.navigableMap.firstEntry().getKey();
    }

    @Override
    public KEY findLastKey() {
        return this.navigableMap.lastEntry().getKey();
    }

    @Override
    public List<ITEM> findEquals(KEY key) {
        MultiValue items = (MultiValue)this.navigableMap.get(key = this.getKey(key));
        if (items == null) {
            return null;
        }
        return items.getValues();
    }

    @Override
    public List<ITEM> findStartsWith(KEY keyFrag) {
        if ((keyFrag = this.getKey(keyFrag)) instanceof String) {
            String start = (String)keyFrag;
            if (start.length() == 0 || start == null) {
                return Collections.EMPTY_LIST;
            }
            char endLetter = start.charAt(start.length() - 1);
            String sub = start.substring(0, start.length() - 1);
            CharBuf after = CharBuf.create(start.length());
            after.add(sub);
            after.add((char)(endLetter + '\u0001'));
            NavigableMap<KEY, MultiValue> sortMap = this.navigableMap;
            SortedMap<String, MultiValue> sortedSubMap = sortMap.subMap(start, after.toString());
            if (sortedSubMap.size() > 0) {
                ArrayList results = new ArrayList();
                for (MultiValue values : sortedSubMap.values()) {
                    values.addTo(results);
                }
                return results;
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<ITEM> findEndsWith(KEY keyFrag) {
        keyFrag = this.getKey(keyFrag);
        ArrayList results = new ArrayList();
        if (keyFrag instanceof String) {
            Collection values = this.navigableMap.values();
            for (MultiValue mv : values) {
                for (Object value : mv.getValues()) {
                    String svalue = (String)this.keyGetter.apply(value);
                    if (!svalue.endsWith((String)keyFrag)) continue;
                    results.add(value);
                }
            }
        }
        return results;
    }

    @Override
    public List<ITEM> findContains(KEY keyFrag) {
        keyFrag = this.getKey(keyFrag);
        ArrayList results = new ArrayList();
        if (keyFrag instanceof String) {
            Collection values = this.navigableMap.values();
            for (MultiValue mv : values) {
                for (Object value : mv.getValues()) {
                    String svalue = (String)this.keyGetter.apply(value);
                    if (!svalue.endsWith((String)keyFrag)) continue;
                    results.add(value);
                }
            }
        }
        return results;
    }

    void initIfNeeded() {
        if (!this.init) {
            this.init = true;
            Object t = ((MultiValue)((Object)this.navigableMap.firstEntry())).getValue();
        }
    }

    @Override
    public List<ITEM> findBetween(KEY start, KEY end) {
        start = this.getKey(start);
        end = this.getKey(end);
        SortedMap<KEY, MultiValue> keyMultiValueSortedMap = this.navigableMap.subMap(start, end);
        return this.getResults(keyMultiValueSortedMap);
    }

    private List<ITEM> getResults(SortedMap<KEY, MultiValue> keyMultiValueSortedMap) {
        ArrayList results = null;
        if (keyMultiValueSortedMap.size() > 0) {
            results = new ArrayList();
            for (MultiValue values : keyMultiValueSortedMap.values()) {
                values.addTo(results);
            }
            return results;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<ITEM> findGreaterThan(KEY key) {
        key = this.getKey(key);
        NavigableMap<KEY, MultiValue> keyMultiValueSortedMap = this.navigableMap.tailMap(key, false);
        return this.getResults(keyMultiValueSortedMap);
    }

    @Override
    public List<ITEM> findLessThan(KEY key) {
        key = this.getKey(key);
        NavigableMap<KEY, MultiValue> keyMultiValueSortedMap = this.navigableMap.headMap(key, false);
        return this.getResults(keyMultiValueSortedMap);
    }

    @Override
    public List<ITEM> findGreaterThanEqual(KEY key) {
        key = this.getKey(key);
        SortedMap<KEY, MultiValue> keyMultiValueSortedMap = this.navigableMap.tailMap(key);
        return this.getResults(keyMultiValueSortedMap);
    }

    @Override
    public List<ITEM> findLessThanEqual(KEY key) {
        key = this.getKey(key);
        SortedMap<KEY, MultiValue> keyMultiValueSortedMap = this.navigableMap.headMap(key);
        return this.getResults(keyMultiValueSortedMap);
    }

    @Override
    public ITEM min() {
        return (ITEM)this.navigableMap.firstEntry().getValue().getValue();
    }

    @Override
    public ITEM max() {
        return (ITEM)this.navigableMap.lastEntry().getValue().getValue();
    }

    @Override
    public int count(KEY key) {
        return ((MultiValue)this.navigableMap.get(key)).size();
    }

    @Override
    public int size() {
        return this.navigableMap.size();
    }
}

