/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.tekton.client.NamespacedTektonClient;
import io.fabric8.tekton.client.TektonClient;
import io.fabric8.tekton.mock.EnableTektonMockClient;
import io.fabric8.tekton.mock.TektonMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TektonMockServerExtension
extends KubernetesMockServerExtension {
    private TektonMockServer tektonMockServer;
    private NamespacedTektonClient tektonClient;

    protected void destroy() {
        this.tektonMockServer.destroy();
        this.tektonClient.close();
    }

    protected Class<?> getClientType() {
        return TektonClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return TektonMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableTektonMockClient a = testClass.getAnnotation(EnableTektonMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.tektonMockServer = a.crud() ? new TektonMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new TektonMockServer(a.https());
        this.tektonMockServer.init();
        this.tektonClient = this.tektonMockServer.createTekton();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.tektonClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.tektonMockServer));
    }
}

