/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.BasicAuthConfig;
import io.fabric8.servicecatalog.api.model.BasicAuthConfigBuilder;
import io.fabric8.servicecatalog.api.model.BasicAuthConfigFluent;
import io.fabric8.servicecatalog.api.model.BearerTokenAuthConfig;
import io.fabric8.servicecatalog.api.model.BearerTokenAuthConfigBuilder;
import io.fabric8.servicecatalog.api.model.BearerTokenAuthConfigFluent;
import io.fabric8.servicecatalog.api.model.ServiceBrokerAuthInfo;
import java.util.Objects;
import java.util.Optional;

public class ServiceBrokerAuthInfoFluent<A extends ServiceBrokerAuthInfoFluent<A>>
extends BaseFluent<A> {
    private BasicAuthConfigBuilder basic;
    private BearerTokenAuthConfigBuilder bearer;

    public ServiceBrokerAuthInfoFluent() {
    }

    public ServiceBrokerAuthInfoFluent(ServiceBrokerAuthInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBrokerAuthInfo instance) {
        ServiceBrokerAuthInfo serviceBrokerAuthInfo = instance = instance != null ? instance : new ServiceBrokerAuthInfo();
        if (instance != null) {
            this.withBasic(instance.getBasic());
            this.withBearer(instance.getBearer());
            this.withBasic(instance.getBasic());
            this.withBearer(instance.getBearer());
        }
    }

    public BasicAuthConfig buildBasic() {
        return this.basic != null ? this.basic.build() : null;
    }

    public A withBasic(BasicAuthConfig basic) {
        this._visitables.remove((Object)this.basic);
        if (basic != null) {
            this.basic = new BasicAuthConfigBuilder(basic);
            this._visitables.get((Object)"basic").add(this.basic);
        } else {
            this.basic = null;
            this._visitables.get((Object)"basic").remove((Object)this.basic);
        }
        return (A)((Object)this);
    }

    public boolean hasBasic() {
        return this.basic != null;
    }

    public BasicNested<A> withNewBasic() {
        return new BasicNested(null);
    }

    public BasicNested<A> withNewBasicLike(BasicAuthConfig item) {
        return new BasicNested(item);
    }

    public BasicNested<A> editBasic() {
        return this.withNewBasicLike(Optional.ofNullable(this.buildBasic()).orElse(null));
    }

    public BasicNested<A> editOrNewBasic() {
        return this.withNewBasicLike(Optional.ofNullable(this.buildBasic()).orElse(new BasicAuthConfigBuilder().build()));
    }

    public BasicNested<A> editOrNewBasicLike(BasicAuthConfig item) {
        return this.withNewBasicLike(Optional.ofNullable(this.buildBasic()).orElse(item));
    }

    public BearerTokenAuthConfig buildBearer() {
        return this.bearer != null ? this.bearer.build() : null;
    }

    public A withBearer(BearerTokenAuthConfig bearer) {
        this._visitables.remove((Object)this.bearer);
        if (bearer != null) {
            this.bearer = new BearerTokenAuthConfigBuilder(bearer);
            this._visitables.get((Object)"bearer").add(this.bearer);
        } else {
            this.bearer = null;
            this._visitables.get((Object)"bearer").remove((Object)this.bearer);
        }
        return (A)((Object)this);
    }

    public boolean hasBearer() {
        return this.bearer != null;
    }

    public BearerNested<A> withNewBearer() {
        return new BearerNested(null);
    }

    public BearerNested<A> withNewBearerLike(BearerTokenAuthConfig item) {
        return new BearerNested(item);
    }

    public BearerNested<A> editBearer() {
        return this.withNewBearerLike(Optional.ofNullable(this.buildBearer()).orElse(null));
    }

    public BearerNested<A> editOrNewBearer() {
        return this.withNewBearerLike(Optional.ofNullable(this.buildBearer()).orElse(new BearerTokenAuthConfigBuilder().build()));
    }

    public BearerNested<A> editOrNewBearerLike(BearerTokenAuthConfig item) {
        return this.withNewBearerLike(Optional.ofNullable(this.buildBearer()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBrokerAuthInfoFluent that = (ServiceBrokerAuthInfoFluent)((Object)o);
        if (!Objects.equals((Object)this.basic, (Object)that.basic)) {
            return false;
        }
        return Objects.equals((Object)this.bearer, (Object)that.bearer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basic, this.bearer, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.basic != null) {
            sb.append("basic:");
            sb.append((Object)((Object)this.basic) + ",");
        }
        if (this.bearer != null) {
            sb.append("bearer:");
            sb.append((Object)this.bearer);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BearerNested<N>
    extends BearerTokenAuthConfigFluent<BearerNested<N>>
    implements Nested<N> {
        BearerTokenAuthConfigBuilder builder;

        BearerNested(BearerTokenAuthConfig item) {
            this.builder = new BearerTokenAuthConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBrokerAuthInfoFluent.this.withBearer(this.builder.build());
        }

        public N endBearer() {
            return this.and();
        }
    }

    public class BasicNested<N>
    extends BasicAuthConfigFluent<BasicNested<N>>
    implements Nested<N> {
        BasicAuthConfigBuilder builder;

        BasicNested(BasicAuthConfig item) {
            this.builder = new BasicAuthConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBrokerAuthInfoFluent.this.withBasic(this.builder.build());
        }

        public N endBasic() {
            return this.and();
        }
    }
}

