package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstanceSpecBuilder extends ServiceInstanceSpecFluent<ServiceInstanceSpecBuilder> implements VisitableBuilder<ServiceInstanceSpec,ServiceInstanceSpecBuilder>{
  public ServiceInstanceSpecBuilder() {
    this(new ServiceInstanceSpec());
  }
  
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent) {
    this(fluent, new ServiceInstanceSpec());
  }
  
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent,ServiceInstanceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstanceSpecBuilder(ServiceInstanceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstanceSpecFluent<?> fluent;
  
  public ServiceInstanceSpec build() {
    ServiceInstanceSpec buildable = new ServiceInstanceSpec(fluent.getClusterServiceClassExternalID(),fluent.getClusterServiceClassExternalName(),fluent.getClusterServiceClassName(),fluent.buildClusterServiceClassRef(),fluent.getClusterServicePlanExternalID(),fluent.getClusterServicePlanExternalName(),fluent.getClusterServicePlanName(),fluent.buildClusterServicePlanRef(),fluent.getExternalID(),fluent.getParameters(),fluent.buildParametersFrom(),fluent.getServiceClassExternalID(),fluent.getServiceClassExternalName(),fluent.getServiceClassName(),fluent.buildServiceClassRef(),fluent.getServicePlanExternalID(),fluent.getServicePlanExternalName(),fluent.getServicePlanName(),fluent.buildServicePlanRef(),fluent.getUpdateRequests(),fluent.buildUserInfo());
    return buildable;
  }
  

}