package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstanceConditionBuilder extends ServiceInstanceConditionFluent<ServiceInstanceConditionBuilder> implements VisitableBuilder<ServiceInstanceCondition,ServiceInstanceConditionBuilder>{
  public ServiceInstanceConditionBuilder() {
    this(new ServiceInstanceCondition());
  }
  
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent) {
    this(fluent, new ServiceInstanceCondition());
  }
  
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent,ServiceInstanceCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstanceConditionBuilder(ServiceInstanceCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstanceConditionFluent<?> fluent;
  
  public ServiceInstanceCondition build() {
    ServiceInstanceCondition buildable = new ServiceInstanceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  

}