package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBrokerBuilder extends ServiceBrokerFluent<ServiceBrokerBuilder> implements VisitableBuilder<ServiceBroker,ServiceBrokerBuilder>{
  public ServiceBrokerBuilder() {
    this(new ServiceBroker());
  }
  
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent) {
    this(fluent, new ServiceBroker());
  }
  
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent,ServiceBroker instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBrokerBuilder(ServiceBroker instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBrokerFluent<?> fluent;
  
  public ServiceBroker build() {
    ServiceBroker buildable = new ServiceBroker(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}