package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterServicePlanSpecFluent<A extends ClusterServicePlanSpecFluent<A>> extends BaseFluent<A>{
  public ClusterServicePlanSpecFluent() {
  }
  
  public ClusterServicePlanSpecFluent(ClusterServicePlanSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean bindable;
  private String clusterServiceBrokerName;
  private ClusterObjectReferenceBuilder clusterServiceClassRef;
  private Map<String,Object> defaultProvisionParameters;
  private String description;
  private String externalID;
  private Map<String,Object> externalMetadata;
  private String externalName;
  private Boolean free;
  private Map<String,Object> instanceCreateParameterSchema;
  private Map<String,Object> instanceUpdateParameterSchema;
  private Map<String,Object> serviceBindingCreateParameterSchema;
  private Map<String,Object> serviceBindingCreateResponseSchema;
  
  protected void copyInstance(ClusterServicePlanSpec instance) {
    instance = (instance != null ? instance : new ClusterServicePlanSpec());
    if (instance != null) {
          this.withBindable(instance.getBindable());
          this.withClusterServiceBrokerName(instance.getClusterServiceBrokerName());
          this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
          this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
          this.withDescription(instance.getDescription());
          this.withExternalID(instance.getExternalID());
          this.withExternalMetadata(instance.getExternalMetadata());
          this.withExternalName(instance.getExternalName());
          this.withFree(instance.getFree());
          this.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema());
          this.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema());
          this.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema());
          this.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema());
          this.withBindable(instance.getBindable());
          this.withClusterServiceBrokerName(instance.getClusterServiceBrokerName());
          this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
          this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
          this.withDescription(instance.getDescription());
          this.withExternalID(instance.getExternalID());
          this.withExternalMetadata(instance.getExternalMetadata());
          this.withExternalName(instance.getExternalName());
          this.withFree(instance.getFree());
          this.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema());
          this.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema());
          this.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema());
          this.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema());
        }
  }
  
  public Boolean getBindable() {
    return this.bindable;
  }
  
  public A withBindable(Boolean bindable) {
    this.bindable = bindable;
    return (A) this;
  }
  
  public boolean hasBindable() {
    return this.bindable != null;
  }
  
  public String getClusterServiceBrokerName() {
    return this.clusterServiceBrokerName;
  }
  
  public A withClusterServiceBrokerName(String clusterServiceBrokerName) {
    this.clusterServiceBrokerName = clusterServiceBrokerName;
    return (A) this;
  }
  
  public boolean hasClusterServiceBrokerName() {
    return this.clusterServiceBrokerName != null;
  }
  
  public ClusterObjectReference buildClusterServiceClassRef() {
    return this.clusterServiceClassRef != null ? this.clusterServiceClassRef.build() : null;
  }
  
  public A withClusterServiceClassRef(ClusterObjectReference clusterServiceClassRef) {
    this._visitables.remove(this.clusterServiceClassRef);
    if (clusterServiceClassRef != null) {
        this.clusterServiceClassRef = new ClusterObjectReferenceBuilder(clusterServiceClassRef);
        this._visitables.get("clusterServiceClassRef").add(this.clusterServiceClassRef);
    } else {
        this.clusterServiceClassRef = null;
        this._visitables.get("clusterServiceClassRef").remove(this.clusterServiceClassRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterServiceClassRef() {
    return this.clusterServiceClassRef != null;
  }
  
  public A withNewClusterServiceClassRef(String name) {
    return (A)withClusterServiceClassRef(new ClusterObjectReference(name));
  }
  
  public ClusterServiceClassRefNested<A> withNewClusterServiceClassRef() {
    return new ClusterServiceClassRefNested(null);
  }
  
  public ClusterServiceClassRefNested<A> withNewClusterServiceClassRefLike(ClusterObjectReference item) {
    return new ClusterServiceClassRefNested(item);
  }
  
  public ClusterServiceClassRefNested<A> editClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(null));
  }
  
  public ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(new ClusterObjectReferenceBuilder().build()));
  }
  
  public ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRefLike(ClusterObjectReference item) {
    return withNewClusterServiceClassRefLike(java.util.Optional.ofNullable(buildClusterServiceClassRef()).orElse(item));
  }
  
  public A addToDefaultProvisionParameters(String key,Object value) {
    if(this.defaultProvisionParameters == null && key != null && value != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.defaultProvisionParameters.put(key, value);} return (A)this;
  }
  
  public A addToDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null && map != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(map != null) { this.defaultProvisionParameters.putAll(map);} return (A)this;
  }
  
  public A removeFromDefaultProvisionParameters(String key) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(key != null && this.defaultProvisionParameters != null) {this.defaultProvisionParameters.remove(key);} return (A)this;
  }
  
  public A removeFromDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.defaultProvisionParameters != null){this.defaultProvisionParameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getDefaultProvisionParameters() {
    return this.defaultProvisionParameters;
  }
  
  public <K,V>A withDefaultProvisionParameters(Map<String,Object> defaultProvisionParameters) {
    if (defaultProvisionParameters == null) {
      this.defaultProvisionParameters = null;
    } else {
      this.defaultProvisionParameters = new LinkedHashMap(defaultProvisionParameters);
    }
    return (A) this;
  }
  
  public boolean hasDefaultProvisionParameters() {
    return this.defaultProvisionParameters != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public String getExternalID() {
    return this.externalID;
  }
  
  public A withExternalID(String externalID) {
    this.externalID = externalID;
    return (A) this;
  }
  
  public boolean hasExternalID() {
    return this.externalID != null;
  }
  
  public A addToExternalMetadata(String key,Object value) {
    if(this.externalMetadata == null && key != null && value != null) { this.externalMetadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.externalMetadata.put(key, value);} return (A)this;
  }
  
  public A addToExternalMetadata(Map<String,Object> map) {
    if(this.externalMetadata == null && map != null) { this.externalMetadata = new LinkedHashMap(); }
    if(map != null) { this.externalMetadata.putAll(map);} return (A)this;
  }
  
  public A removeFromExternalMetadata(String key) {
    if(this.externalMetadata == null) { return (A) this; }
    if(key != null && this.externalMetadata != null) {this.externalMetadata.remove(key);} return (A)this;
  }
  
  public A removeFromExternalMetadata(Map<String,Object> map) {
    if(this.externalMetadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.externalMetadata != null){this.externalMetadata.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getExternalMetadata() {
    return this.externalMetadata;
  }
  
  public <K,V>A withExternalMetadata(Map<String,Object> externalMetadata) {
    if (externalMetadata == null) {
      this.externalMetadata = null;
    } else {
      this.externalMetadata = new LinkedHashMap(externalMetadata);
    }
    return (A) this;
  }
  
  public boolean hasExternalMetadata() {
    return this.externalMetadata != null;
  }
  
  public String getExternalName() {
    return this.externalName;
  }
  
  public A withExternalName(String externalName) {
    this.externalName = externalName;
    return (A) this;
  }
  
  public boolean hasExternalName() {
    return this.externalName != null;
  }
  
  public Boolean getFree() {
    return this.free;
  }
  
  public A withFree(Boolean free) {
    this.free = free;
    return (A) this;
  }
  
  public boolean hasFree() {
    return this.free != null;
  }
  
  public A addToInstanceCreateParameterSchema(String key,Object value) {
    if(this.instanceCreateParameterSchema == null && key != null && value != null) { this.instanceCreateParameterSchema = new LinkedHashMap(); }
    if(key != null && value != null) {this.instanceCreateParameterSchema.put(key, value);} return (A)this;
  }
  
  public A addToInstanceCreateParameterSchema(Map<String,Object> map) {
    if(this.instanceCreateParameterSchema == null && map != null) { this.instanceCreateParameterSchema = new LinkedHashMap(); }
    if(map != null) { this.instanceCreateParameterSchema.putAll(map);} return (A)this;
  }
  
  public A removeFromInstanceCreateParameterSchema(String key) {
    if(this.instanceCreateParameterSchema == null) { return (A) this; }
    if(key != null && this.instanceCreateParameterSchema != null) {this.instanceCreateParameterSchema.remove(key);} return (A)this;
  }
  
  public A removeFromInstanceCreateParameterSchema(Map<String,Object> map) {
    if(this.instanceCreateParameterSchema == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.instanceCreateParameterSchema != null){this.instanceCreateParameterSchema.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getInstanceCreateParameterSchema() {
    return this.instanceCreateParameterSchema;
  }
  
  public <K,V>A withInstanceCreateParameterSchema(Map<String,Object> instanceCreateParameterSchema) {
    if (instanceCreateParameterSchema == null) {
      this.instanceCreateParameterSchema = null;
    } else {
      this.instanceCreateParameterSchema = new LinkedHashMap(instanceCreateParameterSchema);
    }
    return (A) this;
  }
  
  public boolean hasInstanceCreateParameterSchema() {
    return this.instanceCreateParameterSchema != null;
  }
  
  public A addToInstanceUpdateParameterSchema(String key,Object value) {
    if(this.instanceUpdateParameterSchema == null && key != null && value != null) { this.instanceUpdateParameterSchema = new LinkedHashMap(); }
    if(key != null && value != null) {this.instanceUpdateParameterSchema.put(key, value);} return (A)this;
  }
  
  public A addToInstanceUpdateParameterSchema(Map<String,Object> map) {
    if(this.instanceUpdateParameterSchema == null && map != null) { this.instanceUpdateParameterSchema = new LinkedHashMap(); }
    if(map != null) { this.instanceUpdateParameterSchema.putAll(map);} return (A)this;
  }
  
  public A removeFromInstanceUpdateParameterSchema(String key) {
    if(this.instanceUpdateParameterSchema == null) { return (A) this; }
    if(key != null && this.instanceUpdateParameterSchema != null) {this.instanceUpdateParameterSchema.remove(key);} return (A)this;
  }
  
  public A removeFromInstanceUpdateParameterSchema(Map<String,Object> map) {
    if(this.instanceUpdateParameterSchema == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.instanceUpdateParameterSchema != null){this.instanceUpdateParameterSchema.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getInstanceUpdateParameterSchema() {
    return this.instanceUpdateParameterSchema;
  }
  
  public <K,V>A withInstanceUpdateParameterSchema(Map<String,Object> instanceUpdateParameterSchema) {
    if (instanceUpdateParameterSchema == null) {
      this.instanceUpdateParameterSchema = null;
    } else {
      this.instanceUpdateParameterSchema = new LinkedHashMap(instanceUpdateParameterSchema);
    }
    return (A) this;
  }
  
  public boolean hasInstanceUpdateParameterSchema() {
    return this.instanceUpdateParameterSchema != null;
  }
  
  public A addToServiceBindingCreateParameterSchema(String key,Object value) {
    if(this.serviceBindingCreateParameterSchema == null && key != null && value != null) { this.serviceBindingCreateParameterSchema = new LinkedHashMap(); }
    if(key != null && value != null) {this.serviceBindingCreateParameterSchema.put(key, value);} return (A)this;
  }
  
  public A addToServiceBindingCreateParameterSchema(Map<String,Object> map) {
    if(this.serviceBindingCreateParameterSchema == null && map != null) { this.serviceBindingCreateParameterSchema = new LinkedHashMap(); }
    if(map != null) { this.serviceBindingCreateParameterSchema.putAll(map);} return (A)this;
  }
  
  public A removeFromServiceBindingCreateParameterSchema(String key) {
    if(this.serviceBindingCreateParameterSchema == null) { return (A) this; }
    if(key != null && this.serviceBindingCreateParameterSchema != null) {this.serviceBindingCreateParameterSchema.remove(key);} return (A)this;
  }
  
  public A removeFromServiceBindingCreateParameterSchema(Map<String,Object> map) {
    if(this.serviceBindingCreateParameterSchema == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.serviceBindingCreateParameterSchema != null){this.serviceBindingCreateParameterSchema.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getServiceBindingCreateParameterSchema() {
    return this.serviceBindingCreateParameterSchema;
  }
  
  public <K,V>A withServiceBindingCreateParameterSchema(Map<String,Object> serviceBindingCreateParameterSchema) {
    if (serviceBindingCreateParameterSchema == null) {
      this.serviceBindingCreateParameterSchema = null;
    } else {
      this.serviceBindingCreateParameterSchema = new LinkedHashMap(serviceBindingCreateParameterSchema);
    }
    return (A) this;
  }
  
  public boolean hasServiceBindingCreateParameterSchema() {
    return this.serviceBindingCreateParameterSchema != null;
  }
  
  public A addToServiceBindingCreateResponseSchema(String key,Object value) {
    if(this.serviceBindingCreateResponseSchema == null && key != null && value != null) { this.serviceBindingCreateResponseSchema = new LinkedHashMap(); }
    if(key != null && value != null) {this.serviceBindingCreateResponseSchema.put(key, value);} return (A)this;
  }
  
  public A addToServiceBindingCreateResponseSchema(Map<String,Object> map) {
    if(this.serviceBindingCreateResponseSchema == null && map != null) { this.serviceBindingCreateResponseSchema = new LinkedHashMap(); }
    if(map != null) { this.serviceBindingCreateResponseSchema.putAll(map);} return (A)this;
  }
  
  public A removeFromServiceBindingCreateResponseSchema(String key) {
    if(this.serviceBindingCreateResponseSchema == null) { return (A) this; }
    if(key != null && this.serviceBindingCreateResponseSchema != null) {this.serviceBindingCreateResponseSchema.remove(key);} return (A)this;
  }
  
  public A removeFromServiceBindingCreateResponseSchema(Map<String,Object> map) {
    if(this.serviceBindingCreateResponseSchema == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.serviceBindingCreateResponseSchema != null){this.serviceBindingCreateResponseSchema.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getServiceBindingCreateResponseSchema() {
    return this.serviceBindingCreateResponseSchema;
  }
  
  public <K,V>A withServiceBindingCreateResponseSchema(Map<String,Object> serviceBindingCreateResponseSchema) {
    if (serviceBindingCreateResponseSchema == null) {
      this.serviceBindingCreateResponseSchema = null;
    } else {
      this.serviceBindingCreateResponseSchema = new LinkedHashMap(serviceBindingCreateResponseSchema);
    }
    return (A) this;
  }
  
  public boolean hasServiceBindingCreateResponseSchema() {
    return this.serviceBindingCreateResponseSchema != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterServicePlanSpecFluent that = (ClusterServicePlanSpecFluent) o;
    if (!java.util.Objects.equals(bindable, that.bindable)) return false;
    if (!java.util.Objects.equals(clusterServiceBrokerName, that.clusterServiceBrokerName)) return false;
    if (!java.util.Objects.equals(clusterServiceClassRef, that.clusterServiceClassRef)) return false;
    if (!java.util.Objects.equals(defaultProvisionParameters, that.defaultProvisionParameters)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(externalID, that.externalID)) return false;
    if (!java.util.Objects.equals(externalMetadata, that.externalMetadata)) return false;
    if (!java.util.Objects.equals(externalName, that.externalName)) return false;
    if (!java.util.Objects.equals(free, that.free)) return false;
    if (!java.util.Objects.equals(instanceCreateParameterSchema, that.instanceCreateParameterSchema)) return false;
    if (!java.util.Objects.equals(instanceUpdateParameterSchema, that.instanceUpdateParameterSchema)) return false;
    if (!java.util.Objects.equals(serviceBindingCreateParameterSchema, that.serviceBindingCreateParameterSchema)) return false;
    if (!java.util.Objects.equals(serviceBindingCreateResponseSchema, that.serviceBindingCreateResponseSchema)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bindable,  clusterServiceBrokerName,  clusterServiceClassRef,  defaultProvisionParameters,  description,  externalID,  externalMetadata,  externalName,  free,  instanceCreateParameterSchema,  instanceUpdateParameterSchema,  serviceBindingCreateParameterSchema,  serviceBindingCreateResponseSchema,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindable != null) { sb.append("bindable:"); sb.append(bindable + ","); }
    if (clusterServiceBrokerName != null) { sb.append("clusterServiceBrokerName:"); sb.append(clusterServiceBrokerName + ","); }
    if (clusterServiceClassRef != null) { sb.append("clusterServiceClassRef:"); sb.append(clusterServiceClassRef + ","); }
    if (defaultProvisionParameters != null && !defaultProvisionParameters.isEmpty()) { sb.append("defaultProvisionParameters:"); sb.append(defaultProvisionParameters + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (externalID != null) { sb.append("externalID:"); sb.append(externalID + ","); }
    if (externalMetadata != null && !externalMetadata.isEmpty()) { sb.append("externalMetadata:"); sb.append(externalMetadata + ","); }
    if (externalName != null) { sb.append("externalName:"); sb.append(externalName + ","); }
    if (free != null) { sb.append("free:"); sb.append(free + ","); }
    if (instanceCreateParameterSchema != null && !instanceCreateParameterSchema.isEmpty()) { sb.append("instanceCreateParameterSchema:"); sb.append(instanceCreateParameterSchema + ","); }
    if (instanceUpdateParameterSchema != null && !instanceUpdateParameterSchema.isEmpty()) { sb.append("instanceUpdateParameterSchema:"); sb.append(instanceUpdateParameterSchema + ","); }
    if (serviceBindingCreateParameterSchema != null && !serviceBindingCreateParameterSchema.isEmpty()) { sb.append("serviceBindingCreateParameterSchema:"); sb.append(serviceBindingCreateParameterSchema + ","); }
    if (serviceBindingCreateResponseSchema != null && !serviceBindingCreateResponseSchema.isEmpty()) { sb.append("serviceBindingCreateResponseSchema:"); sb.append(serviceBindingCreateResponseSchema); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withBindable() {
    return withBindable(true);
  }
  
  public A withFree() {
    return withFree(true);
  }
  public class ClusterServiceClassRefNested<N> extends ClusterObjectReferenceFluent<ClusterServiceClassRefNested<N>> implements Nested<N>{
    ClusterServiceClassRefNested(ClusterObjectReference item) {
      this.builder = new ClusterObjectReferenceBuilder(this, item);
    }
    ClusterObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterServicePlanSpecFluent.this.withClusterServiceClassRef(builder.build());
    }
    
    public N endClusterServiceClassRef() {
      return and();
    }
    
  
  }

}