package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServiceBrokerStatusBuilder extends ClusterServiceBrokerStatusFluent<ClusterServiceBrokerStatusBuilder> implements VisitableBuilder<ClusterServiceBrokerStatus,ClusterServiceBrokerStatusBuilder>{
  public ClusterServiceBrokerStatusBuilder() {
    this(new ClusterServiceBrokerStatus());
  }
  
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent) {
    this(fluent, new ClusterServiceBrokerStatus());
  }
  
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatusFluent<?> fluent,ClusterServiceBrokerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServiceBrokerStatusBuilder(ClusterServiceBrokerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServiceBrokerStatusFluent<?> fluent;
  
  public ClusterServiceBrokerStatus build() {
    ClusterServiceBrokerStatus buildable = new ClusterServiceBrokerStatus(fluent.buildConditions(),fluent.getLastCatalogRetrievalTime(),fluent.getOperationStartTime(),fluent.getReconciledGeneration());
    return buildable;
  }
  

}