package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BasicAuthConfigBuilder extends BasicAuthConfigFluent<BasicAuthConfigBuilder> implements VisitableBuilder<BasicAuthConfig,BasicAuthConfigBuilder>{
  public BasicAuthConfigBuilder() {
    this(new BasicAuthConfig());
  }
  
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent) {
    this(fluent, new BasicAuthConfig());
  }
  
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent,BasicAuthConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BasicAuthConfigBuilder(BasicAuthConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BasicAuthConfigFluent<?> fluent;
  
  public BasicAuthConfig build() {
    BasicAuthConfig buildable = new BasicAuthConfig(fluent.buildSecretRef());
    return buildable;
  }
  

}