package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServicePlanBuilder extends ServicePlanFluent<ServicePlanBuilder> implements VisitableBuilder<ServicePlan,ServicePlanBuilder>{
  public ServicePlanBuilder() {
    this(new ServicePlan());
  }
  
  public ServicePlanBuilder(ServicePlanFluent<?> fluent) {
    this(fluent, new ServicePlan());
  }
  
  public ServicePlanBuilder(ServicePlanFluent<?> fluent,ServicePlan instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServicePlanBuilder(ServicePlan instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServicePlanFluent<?> fluent;
  
  public ServicePlan build() {
    ServicePlan buildable = new ServicePlan(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}