package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceInstanceStatusFluent<A extends ServiceInstanceStatusFluent<A>> extends BaseFluent<A>{
  public ServiceInstanceStatusFluent() {
  }
  
  public ServiceInstanceStatusFluent(ServiceInstanceStatus instance) {
    this.copyInstance(instance);
  }
  private Boolean asyncOpInProgress;
  private ArrayList<ServiceInstanceConditionBuilder> conditions = new ArrayList<ServiceInstanceConditionBuilder>();
  private String currentOperation;
  private String dashboardURL;
  private Map<String,Object> defaultProvisionParameters;
  private String deprovisionStatus;
  private ServiceInstancePropertiesStateBuilder externalProperties;
  private ServiceInstancePropertiesStateBuilder inProgressProperties;
  private String lastOperation;
  private Long observedGeneration;
  private String operationStartTime;
  private Boolean orphanMitigationInProgress;
  private String provisionStatus;
  private Long reconciledGeneration;
  
  protected void copyInstance(ServiceInstanceStatus instance) {
    instance = (instance != null ? instance : new ServiceInstanceStatus());
  
    if (instance != null) {
        this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
        this.withConditions(instance.getConditions());
        this.withCurrentOperation(instance.getCurrentOperation());
        this.withDashboardURL(instance.getDashboardURL());
        this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
        this.withDeprovisionStatus(instance.getDeprovisionStatus());
        this.withExternalProperties(instance.getExternalProperties());
        this.withInProgressProperties(instance.getInProgressProperties());
        this.withLastOperation(instance.getLastOperation());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withOperationStartTime(instance.getOperationStartTime());
        this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
        this.withProvisionStatus(instance.getProvisionStatus());
        this.withReconciledGeneration(instance.getReconciledGeneration());
        this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
        this.withConditions(instance.getConditions());
        this.withCurrentOperation(instance.getCurrentOperation());
        this.withDashboardURL(instance.getDashboardURL());
        this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
        this.withDeprovisionStatus(instance.getDeprovisionStatus());
        this.withExternalProperties(instance.getExternalProperties());
        this.withInProgressProperties(instance.getInProgressProperties());
        this.withLastOperation(instance.getLastOperation());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withOperationStartTime(instance.getOperationStartTime());
        this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
        this.withProvisionStatus(instance.getProvisionStatus());
        this.withReconciledGeneration(instance.getReconciledGeneration());
      }
  }
  
  public Boolean getAsyncOpInProgress() {
    return this.asyncOpInProgress;
  }
  
  public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
    this.asyncOpInProgress=asyncOpInProgress; return (A) this;
  }
  
  public boolean hasAsyncOpInProgress() {
    return this.asyncOpInProgress != null;
  }
  
  public A addToConditions(int index,ServiceInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,ServiceInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<ServiceInstanceCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<ServiceInstanceCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ServiceInstanceConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceInstanceConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceInstanceConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServiceInstanceCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public ServiceInstanceCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public ServiceInstanceCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public ServiceInstanceCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public ServiceInstanceCondition buildMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    for (ServiceInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    for (ServiceInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<ServiceInstanceCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceInstanceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ServiceInstanceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(ServiceInstanceCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,ServiceInstanceCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getCurrentOperation() {
    return this.currentOperation;
  }
  
  public A withCurrentOperation(String currentOperation) {
    this.currentOperation=currentOperation; return (A) this;
  }
  
  public boolean hasCurrentOperation() {
    return this.currentOperation != null;
  }
  
  public String getDashboardURL() {
    return this.dashboardURL;
  }
  
  public A withDashboardURL(String dashboardURL) {
    this.dashboardURL=dashboardURL; return (A) this;
  }
  
  public boolean hasDashboardURL() {
    return this.dashboardURL != null;
  }
  
  public A addToDefaultProvisionParameters(String key,Object value) {
    if(this.defaultProvisionParameters == null && key != null && value != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.defaultProvisionParameters.put(key, value);} return (A)this;
  }
  
  public A addToDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null && map != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(map != null) { this.defaultProvisionParameters.putAll(map);} return (A)this;
  }
  
  public A removeFromDefaultProvisionParameters(String key) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(key != null && this.defaultProvisionParameters != null) {this.defaultProvisionParameters.remove(key);} return (A)this;
  }
  
  public A removeFromDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.defaultProvisionParameters != null){this.defaultProvisionParameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getDefaultProvisionParameters() {
    return this.defaultProvisionParameters;
  }
  
  public <K,V>A withDefaultProvisionParameters(Map<String,Object> defaultProvisionParameters) {
    if (defaultProvisionParameters == null) { this.defaultProvisionParameters =  null;} else {this.defaultProvisionParameters = new LinkedHashMap(defaultProvisionParameters);} return (A) this;
  }
  
  public boolean hasDefaultProvisionParameters() {
    return this.defaultProvisionParameters != null;
  }
  
  public String getDeprovisionStatus() {
    return this.deprovisionStatus;
  }
  
  public A withDeprovisionStatus(String deprovisionStatus) {
    this.deprovisionStatus=deprovisionStatus; return (A) this;
  }
  
  public boolean hasDeprovisionStatus() {
    return this.deprovisionStatus != null;
  }
  
  public ServiceInstancePropertiesState buildExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  
  public A withExternalProperties(ServiceInstancePropertiesState externalProperties) {
    _visitables.get("externalProperties").remove(this.externalProperties);
    if (externalProperties!=null){ this.externalProperties= new ServiceInstancePropertiesStateBuilder(externalProperties); _visitables.get("externalProperties").add(this.externalProperties);} else { this.externalProperties = null; _visitables.get("externalProperties").remove(this.externalProperties); } return (A) this;
  }
  
  public boolean hasExternalProperties() {
    return this.externalProperties != null;
  }
  
  public ExternalPropertiesNested<A> withNewExternalProperties() {
    return new ExternalPropertiesNested(null);
  }
  
  public ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
    return new ExternalPropertiesNested(item);
  }
  
  public ExternalPropertiesNested<A> editExternalProperties() {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(null));
  }
  
  public ExternalPropertiesNested<A> editOrNewExternalProperties() {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(new ServiceInstancePropertiesStateBuilder().build()));
  }
  
  public ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
    return withNewExternalPropertiesLike(java.util.Optional.ofNullable(buildExternalProperties()).orElse(item));
  }
  
  public ServiceInstancePropertiesState buildInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  
  public A withInProgressProperties(ServiceInstancePropertiesState inProgressProperties) {
    _visitables.get("inProgressProperties").remove(this.inProgressProperties);
    if (inProgressProperties!=null){ this.inProgressProperties= new ServiceInstancePropertiesStateBuilder(inProgressProperties); _visitables.get("inProgressProperties").add(this.inProgressProperties);} else { this.inProgressProperties = null; _visitables.get("inProgressProperties").remove(this.inProgressProperties); } return (A) this;
  }
  
  public boolean hasInProgressProperties() {
    return this.inProgressProperties != null;
  }
  
  public InProgressPropertiesNested<A> withNewInProgressProperties() {
    return new InProgressPropertiesNested(null);
  }
  
  public InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
    return new InProgressPropertiesNested(item);
  }
  
  public InProgressPropertiesNested<A> editInProgressProperties() {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(null));
  }
  
  public InProgressPropertiesNested<A> editOrNewInProgressProperties() {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(new ServiceInstancePropertiesStateBuilder().build()));
  }
  
  public InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
    return withNewInProgressPropertiesLike(java.util.Optional.ofNullable(buildInProgressProperties()).orElse(item));
  }
  
  public String getLastOperation() {
    return this.lastOperation;
  }
  
  public A withLastOperation(String lastOperation) {
    this.lastOperation=lastOperation; return (A) this;
  }
  
  public boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  
  public boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  
  public Boolean getOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress;
  }
  
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
    this.orphanMitigationInProgress=orphanMitigationInProgress; return (A) this;
  }
  
  public boolean hasOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress != null;
  }
  
  public String getProvisionStatus() {
    return this.provisionStatus;
  }
  
  public A withProvisionStatus(String provisionStatus) {
    this.provisionStatus=provisionStatus; return (A) this;
  }
  
  public boolean hasProvisionStatus() {
    return this.provisionStatus != null;
  }
  
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  
  public boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceStatusFluent that = (ServiceInstanceStatusFluent) o;
    if (!java.util.Objects.equals(asyncOpInProgress, that.asyncOpInProgress)) return false;
  
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(currentOperation, that.currentOperation)) return false;
  
    if (!java.util.Objects.equals(dashboardURL, that.dashboardURL)) return false;
  
    if (!java.util.Objects.equals(defaultProvisionParameters, that.defaultProvisionParameters)) return false;
  
    if (!java.util.Objects.equals(deprovisionStatus, that.deprovisionStatus)) return false;
  
    if (!java.util.Objects.equals(externalProperties, that.externalProperties)) return false;
  
    if (!java.util.Objects.equals(inProgressProperties, that.inProgressProperties)) return false;
  
    if (!java.util.Objects.equals(lastOperation, that.lastOperation)) return false;
  
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
  
    if (!java.util.Objects.equals(operationStartTime, that.operationStartTime)) return false;
  
    if (!java.util.Objects.equals(orphanMitigationInProgress, that.orphanMitigationInProgress)) return false;
  
    if (!java.util.Objects.equals(provisionStatus, that.provisionStatus)) return false;
  
    if (!java.util.Objects.equals(reconciledGeneration, that.reconciledGeneration)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(asyncOpInProgress,  conditions,  currentOperation,  dashboardURL,  defaultProvisionParameters,  deprovisionStatus,  externalProperties,  inProgressProperties,  lastOperation,  observedGeneration,  operationStartTime,  orphanMitigationInProgress,  provisionStatus,  reconciledGeneration,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (asyncOpInProgress != null) { sb.append("asyncOpInProgress:"); sb.append(asyncOpInProgress + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentOperation != null) { sb.append("currentOperation:"); sb.append(currentOperation + ","); }
    if (dashboardURL != null) { sb.append("dashboardURL:"); sb.append(dashboardURL + ","); }
    if (defaultProvisionParameters != null && !defaultProvisionParameters.isEmpty()) { sb.append("defaultProvisionParameters:"); sb.append(defaultProvisionParameters + ","); }
    if (deprovisionStatus != null) { sb.append("deprovisionStatus:"); sb.append(deprovisionStatus + ","); }
    if (externalProperties != null) { sb.append("externalProperties:"); sb.append(externalProperties + ","); }
    if (inProgressProperties != null) { sb.append("inProgressProperties:"); sb.append(inProgressProperties + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (orphanMitigationInProgress != null) { sb.append("orphanMitigationInProgress:"); sb.append(orphanMitigationInProgress + ","); }
    if (provisionStatus != null) { sb.append("provisionStatus:"); sb.append(provisionStatus + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAsyncOpInProgress() {
    return withAsyncOpInProgress(true);
  }
  
  public A withOrphanMitigationInProgress() {
    return withOrphanMitigationInProgress(true);
  }
  public class ConditionsNested<N> extends ServiceInstanceConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ServiceInstanceCondition item) {
      this.index = index;
      this.builder = new ServiceInstanceConditionBuilder(this, item);
    }
    ServiceInstanceConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceInstanceStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ExternalPropertiesNested<N> extends ServiceInstancePropertiesStateFluent<ExternalPropertiesNested<N>> implements Nested<N>{
    ExternalPropertiesNested(ServiceInstancePropertiesState item) {
      this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
    }
    ServiceInstancePropertiesStateBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceStatusFluent.this.withExternalProperties(builder.build());
    }
    
    public N endExternalProperties() {
      return and();
    }
    
  
  }
  public class InProgressPropertiesNested<N> extends ServiceInstancePropertiesStateFluent<InProgressPropertiesNested<N>> implements Nested<N>{
    InProgressPropertiesNested(ServiceInstancePropertiesState item) {
      this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
    }
    ServiceInstancePropertiesStateBuilder builder;
    
    public N and() {
      return (N) ServiceInstanceStatusFluent.this.withInProgressProperties(builder.build());
    }
    
    public N endInProgressProperties() {
      return and();
    }
    
  
  }

}