package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingListFluent<A extends ServiceBindingListFluent<A>> extends BaseFluent<A>{
  public ServiceBindingListFluent() {
  }
  
  public ServiceBindingListFluent(ServiceBindingList instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private ArrayList<ServiceBindingBuilder> items = new ArrayList<ServiceBindingBuilder>();
  private String kind;
  private ListMeta metadata;
  
  protected void copyInstance(ServiceBindingList instance) {
    instance = (instance != null ? instance : new ServiceBindingList());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToItems(int index,ServiceBinding item) {
    if (this.items == null) {this.items = new ArrayList<ServiceBindingBuilder>();}
    ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  
  public A setToItems(int index,ServiceBinding item) {
    if (this.items == null) {this.items = new ArrayList<ServiceBindingBuilder>();}
    ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  
  public A addToItems(io.fabric8.servicecatalog.api.model.ServiceBinding... items) {
    if (this.items == null) {this.items = new ArrayList<ServiceBindingBuilder>();}
    for (ServiceBinding item : items) {ServiceBindingBuilder builder = new ServiceBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A addAllToItems(Collection<ServiceBinding> items) {
    if (this.items == null) {this.items = new ArrayList<ServiceBindingBuilder>();}
    for (ServiceBinding item : items) {ServiceBindingBuilder builder = new ServiceBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A removeFromItems(io.fabric8.servicecatalog.api.model.ServiceBinding... items) {
    if (this.items == null) return (A)this;
    for (ServiceBinding item : items) {ServiceBindingBuilder builder = new ServiceBindingBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeAllFromItems(Collection<ServiceBinding> items) {
    if (this.items == null) return (A)this;
    for (ServiceBinding item : items) {ServiceBindingBuilder builder = new ServiceBindingBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromItems(Predicate<ServiceBindingBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<ServiceBindingBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      ServiceBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServiceBinding> buildItems() {
    return items != null ? build(items) : null;
  }
  
  public ServiceBinding buildItem(int index) {
    return this.items.get(index).build();
  }
  
  public ServiceBinding buildFirstItem() {
    return this.items.get(0).build();
  }
  
  public ServiceBinding buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  
  public ServiceBinding buildMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
    for (ServiceBindingBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
    for (ServiceBindingBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withItems(List<ServiceBinding> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (ServiceBinding item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  
  public A withItems(io.fabric8.servicecatalog.api.model.ServiceBinding... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (ServiceBinding item :items){ this.addToItems(item);}} return (A) this;
  }
  
  public boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  
  public ItemsNested<A> addNewItemLike(ServiceBinding item) {
    return new ItemsNested(-1, item);
  }
  
  public ItemsNested<A> setNewItemLike(int index,ServiceBinding item) {
    return new ItemsNested(index, item);
  }
  
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ListMeta getMetadata() {
    return this.metadata;
  }
  
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingListFluent that = (ServiceBindingListFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(items, that.items)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  public class ItemsNested<N> extends ServiceBindingFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,ServiceBinding item) {
      this.index = index;
      this.builder = new ServiceBindingBuilder(this, item);
    }
    ServiceBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingListFluent.this.setToItems(index,builder.build());
    }
    
    public N endItem() {
      return and();
    }
    
  
  }

}