package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServicePlanBuilder extends ClusterServicePlanFluent<ClusterServicePlanBuilder> implements VisitableBuilder<ClusterServicePlan,ClusterServicePlanBuilder>{
  public ClusterServicePlanBuilder() {
    this(new ClusterServicePlan());
  }
  
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent) {
    this(fluent, new ClusterServicePlan());
  }
  
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent,ClusterServicePlan instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServicePlanBuilder(ClusterServicePlan instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServicePlanFluent<?> fluent;
  
  public ClusterServicePlan build() {
    ClusterServicePlan buildable = new ClusterServicePlan(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}