/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.ServiceBrokerCondition;
import io.fabric8.servicecatalog.api.model.ServiceBrokerConditionBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBrokerConditionFluent;
import io.fabric8.servicecatalog.api.model.ServiceBrokerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceBrokerStatusFluent<A extends ServiceBrokerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ServiceBrokerConditionBuilder> conditions = new ArrayList();
    private String lastCatalogRetrievalTime;
    private String operationStartTime;
    private Long reconciledGeneration;

    public ServiceBrokerStatusFluent() {
    }

    public ServiceBrokerStatusFluent(ServiceBrokerStatus instance) {
        ServiceBrokerStatus serviceBrokerStatus = instance = instance != null ? instance : new ServiceBrokerStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withReconciledGeneration(instance.getReconciledGeneration());
            this.withConditions(instance.getConditions());
            this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withReconciledGeneration(instance.getReconciledGeneration());
        }
    }

    public A addToConditions(int index, ServiceBrokerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, ServiceBrokerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ServiceBrokerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceBrokerCondition item : items) {
            ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<ServiceBrokerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceBrokerCondition item : items) {
            ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ServiceBrokerCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceBrokerCondition item : items) {
            ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<ServiceBrokerCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceBrokerCondition item : items) {
            ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ServiceBrokerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceBrokerConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ServiceBrokerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServiceBrokerCondition> buildConditions() {
        return this.conditions != null ? ServiceBrokerStatusFluent.build(this.conditions) : null;
    }

    public ServiceBrokerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ServiceBrokerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ServiceBrokerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ServiceBrokerCondition buildMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
        for (ServiceBrokerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
        for (ServiceBrokerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<ServiceBrokerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ServiceBrokerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ServiceBrokerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ServiceBrokerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ServiceBrokerCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ServiceBrokerCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ServiceBrokerCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getLastCatalogRetrievalTime() {
        return this.lastCatalogRetrievalTime;
    }

    public A withLastCatalogRetrievalTime(String lastCatalogRetrievalTime) {
        this.lastCatalogRetrievalTime = lastCatalogRetrievalTime;
        return (A)((Object)this);
    }

    public boolean hasLastCatalogRetrievalTime() {
        return this.lastCatalogRetrievalTime != null;
    }

    public String getOperationStartTime() {
        return this.operationStartTime;
    }

    public A withOperationStartTime(String operationStartTime) {
        this.operationStartTime = operationStartTime;
        return (A)((Object)this);
    }

    public boolean hasOperationStartTime() {
        return this.operationStartTime != null;
    }

    public Long getReconciledGeneration() {
        return this.reconciledGeneration;
    }

    public A withReconciledGeneration(Long reconciledGeneration) {
        this.reconciledGeneration = reconciledGeneration;
        return (A)((Object)this);
    }

    public boolean hasReconciledGeneration() {
        return this.reconciledGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBrokerStatusFluent that = (ServiceBrokerStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.lastCatalogRetrievalTime, that.lastCatalogRetrievalTime)) {
            return false;
        }
        if (!Objects.equals(this.operationStartTime, that.operationStartTime)) {
            return false;
        }
        return Objects.equals(this.reconciledGeneration, that.reconciledGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.lastCatalogRetrievalTime, this.operationStartTime, this.reconciledGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.lastCatalogRetrievalTime != null) {
            sb.append("lastCatalogRetrievalTime:");
            sb.append(this.lastCatalogRetrievalTime + ",");
        }
        if (this.operationStartTime != null) {
            sb.append("operationStartTime:");
            sb.append(this.operationStartTime + ",");
        }
        if (this.reconciledGeneration != null) {
            sb.append("reconciledGeneration:");
            sb.append(this.reconciledGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ServiceBrokerConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ServiceBrokerConditionBuilder builder;
        int index;

        ConditionsNested(int index, ServiceBrokerCondition item) {
            this.index = index;
            this.builder = new ServiceBrokerConditionBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBrokerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

